/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.contextmenu;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jd.gui.swing.jdgui.views.settings.components.FolderChooser;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtTextField;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;

public class NewPackageDialog
extends AbstractDialog<Object> {
    private SelectionInfo<?, ?> selection;
    private ExtTextField tf;
    private FolderChooser fc;
    private String preSet = null;

    public NewPackageDialog(SelectionInfo<?, ?> selection) {
        super(0, _GUI.T.NewPackageDialog_NewPackageDialog_(), null, null, null);
        this.selection = selection;
    }

    protected int getPreferredWidth() {
        return Math.min(Math.max(this.tf.getPreferredSize().width, this.fc.getPreferredSize().width) * 2, this.getDialog().getParent().getWidth());
    }

    private String getNewName() {
        String defValue = _GUI.T.MergeToPackageAction_actionPerformed_newpackage_();
        try {
            defValue = this.selection.getFirstPackage().getName();
        }
        catch (Throwable e2) {
            LoggerFactory.getDefaultLogger().log(e2);
        }
        return defValue;
    }

    protected void initFocus(JComponent focus) {
        super.initFocus((JComponent)this.tf);
    }

    protected Object createReturnValue() {
        return null;
    }

    public JComponent layoutDialogContent() {
        MigPanel p = new MigPanel("ins 0,wrap 2", "[][grow,fill]", "[]");
        p.add((Component)new JLabel(_GUI.T.NewPackageDialog_layoutDialogContent_newname_()));
        this.tf = new ExtTextField();
        this.tf.setText(this.getNewName());
        p.add((Component)this.tf);
        p.add((Component)new JLabel(_GUI.T.NewPackageDialog_layoutDialogContent_saveto()));
        this.fc = new FolderChooser();
        File path = null;
        if (StringUtils.isNotEmpty((String)this.preSet)) {
            this.fc.setText(this.preSet);
        } else {
            path = LinkTreeUtils.getRawDownloadDirectory(this.selection.getFirstPackage());
            if (path != null) {
                this.fc.setText(path.getAbsolutePath());
            }
        }
        p.add((Component)this.fc, (Object)"pushx,growx");
        return p;
    }

    protected void packed() {
        this.tf.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                NewPackageDialog.this.tf.selectAll();
            }
        });
        this.tf.requestFocusInWindow();
        this.tf.selectAll();
    }

    public String getName() {
        return this.tf.getText();
    }

    public void setDownloadFolder(String path) {
        this.preSet = path;
    }

    public String getDownloadFolder() {
        return this.fc.getText();
    }
}

