/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.contextmenu;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import org.appwork.swing.exttable.ExtTableEvent;
import org.appwork.swing.exttable.ExtTableListener;
import org.appwork.swing.exttable.ExtTableModelEventWrapper;
import org.appwork.swing.exttable.ExtTableModelListener;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkArchiveFile;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.downloads.action.ByPassDialogSetup;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.bottombar.IncludedSelectionSetup;

public class RemoveIncompleteArchives
extends CustomizableTableContextAppAction<CrawledPackage, CrawledLink>
implements ExtTableListener,
ActionContext,
ExtTableModelListener {
    private static final long serialVersionUID = 2816227528827363428L;
    private ByPassDialogSetup byPassDialog;
    private IncludedSelectionSetup includedSelection;

    public RemoveIncompleteArchives() {
        this.setName(_GUI.T.RemoveIncompleteArchives_RemoveIncompleteArchives_object_());
        this.setIconKey("extract_error");
        this.byPassDialog = new ByPassDialogSetup();
        this.addContextSetup(this.byPassDialog);
        this.initIncludeSelectionSupport();
    }

    protected void initIncludeSelectionSupport() {
        this.includedSelection = new IncludedSelectionSetup(LinkGrabberTable.getInstance(), this, this);
        this.addContextSetup(this.includedSelection);
    }

    @Override
    protected void getSelection(PackageControllerTable.SelectionInfoCallback<CrawledPackage, CrawledLink> callback, PackageControllerTable.SelectionType selectionType) {
        LinkGrabberTable.getInstance().getSelectionInfo(callback, selectionType);
    }

    @Override
    protected PackageControllerTable.SelectionType getSelectionType() {
        return this.includedSelection.getSelectionType();
    }

    @Override
    protected void onActionPerformed(ActionEvent e, final PackageControllerTable.SelectionType selectionType, final SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
        if (this.isEnabled()) {
            switch (selectionType) {
                case SELECTED: {
                    break;
                }
                case UNSELECTED: {
                    if (selectionInfo.getUnselectedChildren() != null) break;
                    return;
                }
                case ALL: {
                    break;
                }
                default: {
                    return;
                }
            }
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        List archives;
                        switch (selectionType) {
                            case NONE: {
                                ArrayList archives2 = new ArrayList();
                                return;
                            }
                            case SELECTED: {
                                archives = ArchiveValidator.getArchivesFromPackageChildren(selectionInfo.getChildren());
                                break;
                            }
                            case UNSELECTED: {
                                if (selectionInfo.getUnselectedChildren() == null) {
                                    return;
                                }
                                archives = ArchiveValidator.getArchivesFromPackageChildren(selectionInfo.getUnselectedChildren());
                                break;
                            }
                            case ALL: {
                                archives = ArchiveValidator.getArchivesFromPackageChildren(selectionInfo.getChildren());
                                break;
                            }
                            default: {
                                ArrayList archives3 = new ArrayList();
                                return;
                            }
                        }
                        for (Archive archive : archives) {
                            DummyArchive da = ExtractionExtension.getInstance().createDummyArchive(archive);
                            if (da.isComplete()) continue;
                            try {
                                if (JDGui.bugme((WarnLevel)WarnLevel.LOW) && !RemoveIncompleteArchives.this.byPassDialog.isBypassDialog()) {
                                    Dialog.getInstance().showConfirmDialog(544, _GUI.T.literally_are_you_sure(), _GUI.T.RemoveIncompleteArchives_run_(da.getName()), null, _GUI.T.literally_yes(), _GUI.T.literall_no());
                                }
                                ArrayList<CrawledLink> links = new ArrayList<CrawledLink>();
                                for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                                    if (!(archiveFile instanceof CrawledLinkArchiveFile)) continue;
                                    links.addAll(((CrawledLinkArchiveFile)archiveFile).getLinks());
                                }
                                LinkCollector.getInstance().removeChildren((List<CrawledLink>)links);
                            }
                            catch (DialogCanceledException dialogCanceledException) {}
                        }
                    }
                    catch (DialogNoAnswerException e) {
                        return;
                    }
                    catch (Throwable e) {
                        LoggerFactory.getDefaultLogger().log(e);
                    }
                }
            };
            thread.setDaemon(true);
            thread.setPriority(1);
            thread.setName(this.getClass().getName());
            thread.start();
        }
    }

    public void onExtTableModelEvent(ExtTableModelEventWrapper event) {
    }

    public void onExtTableEvent(ExtTableEvent<?> event) {
    }
}

