/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.contextmenu;

import java.awt.event.ActionEvent;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageControllerComparator;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.interfaces.View;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModel;
import org.jdownloader.gui.views.downloads.DownloadsView;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberView;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class SortAction<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends CustomizableTableContextAppAction<PackageType, ChildrenType> {
    private static final long serialVersionUID = -3883739313644803093L;
    private ExtColumn<AbstractNode> column;

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        View view = MainTabbedPane.getInstance().getSelectedView();
        if (view instanceof DownloadsView) {
            this.column = DownloadsTable.getInstance().getMouseOverColumn();
        } else if (view instanceof LinkGrabberView) {
            this.column = LinkGrabberTable.getInstance().getMouseOverColumn();
        }
        if (this.getSelection() != null && this.column != null) {
            this.setIconKey("sort");
            this.setName(_GUI.T.SortAction_SortAction_object_(this.column.getName()));
        } else {
            this.setIconKey("sort");
            this.setName(_GUI.T.SortAction_SortAction_object_empty());
        }
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(true);
    }

    public SortAction() {
        super(true, true);
        this.setIconKey("sort");
        this.setName(_GUI.T.SortAction_SortAction_object_empty());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.column == null) {
            return;
        }
        if (!(this.column.getModel() instanceof PackageControllerTableModel)) {
            return;
        }
        final SelectionInfo selection = this.getSelection();
        final PackageControllerTableModel model = (PackageControllerTableModel)this.column.getModel();
        model.getController().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

            protected Void run() throws RuntimeException {
                if (model instanceof PackageControllerTableModel) {
                    PackageControllerComparator<AbstractNode> comparator = null;
                    for (SelectionInfo.PackageView node : selection.getPackageViews()) {
                        if (comparator == null) {
                            String currentID = SortAction.this.column.getModel().getModelID() + ".Column." + SortAction.this.column.getID();
                            PackageControllerComparator<AbstractNode> currentSorter = node.getPackage().getCurrentSorter();
                            boolean asc = currentSorter == null || !currentSorter.getID().equals(currentID) ? CFG_GUI.CFG.isPrimaryTableSorterDesc() : !currentSorter.isAsc();
                            currentID = (asc ? "ASC" : "DESC") + "." + currentID;
                            comparator = PackageControllerComparator.getComparator(currentID);
                        }
                        model.sortPackageChildren((AbstractPackageNode)node.getPackage(), comparator);
                    }
                }
                return null;
            }
        });
    }
}

