/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.quickfilter;

import jd.controlling.linkcrawler.CrawledLink;
import org.appwork.utils.Hash;
import org.jdownloader.controlling.filter.LinkgrabberFilterRule;
import org.jdownloader.controlling.filter.LinkgrabberFilterRuleWrapper;
import org.jdownloader.gui.views.linkgrabber.quickfilter.Filter;
import org.jdownloader.images.NewTheme;

public class ExceptionFilter
extends Filter {
    private final String description;
    private final LinkgrabberFilterRuleWrapper wrapperRule;
    private final String id;

    public ExceptionFilter(LinkgrabberFilterRuleWrapper rule) {
        super(rule.getName());
        this.wrapperRule = rule;
        if (((LinkgrabberFilterRule)rule.getRule()).getIconKey() != null) {
            this.setIcon(NewTheme.I().getIcon(((LinkgrabberFilterRule)rule.getRule()).getIconKey(), 16));
        }
        this.id = "Custom_" + Hash.getMD5((String)(rule.getName() + ":" + this.getDescription()));
        this.enabled = Boolean.TRUE.equals(CONFIG.get(this.getID(), (Object)true));
        this.description = ((LinkgrabberFilterRule)rule.getRule()).toString();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public LinkgrabberFilterRuleWrapper getWrapperRule() {
        return this.wrapperRule;
    }

    @Override
    protected String getID() {
        return this.id;
    }

    @Override
    public boolean isFiltered(CrawledLink link) {
        if (!this.wrapperRule.checkHoster(link)) {
            return false;
        }
        if (!this.wrapperRule.checkPluginStatus(link)) {
            return false;
        }
        if (!this.wrapperRule.checkOrigin(link)) {
            return false;
        }
        if (!this.wrapperRule.checkConditions(link)) {
            return false;
        }
        if (!this.wrapperRule.checkOnlineStatus(link)) {
            return false;
        }
        if (!this.wrapperRule.checkSource(link)) {
            return false;
        }
        if (!this.wrapperRule.checkFileName(link)) {
            return false;
        }
        if (!this.wrapperRule.checkPackageName(link)) {
            return false;
        }
        if (!this.wrapperRule.checkFileSize(link)) {
            return false;
        }
        return this.wrapperRule.checkFileType(link);
    }
}

