/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.quickfilter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import jd.SecondLevelLaunch;
import jd.controlling.linkcrawler.CrawledLink;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.Header;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.quickfilter.ExtensionFilter;
import org.jdownloader.gui.views.linkgrabber.quickfilter.Filter;
import org.jdownloader.gui.views.linkgrabber.quickfilter.FilterTable;
import org.jdownloader.gui.views.linkgrabber.quickfilter.FilterTableDataUpdater;
import org.jdownloader.settings.staticreferences.CFG_LINKFILTER;
import org.jdownloader.translate._JDT;

public class QuickFilterTypeTable
extends FilterTable {
    private static final long serialVersionUID = 2109715691047942399L;
    private CopyOnWriteArrayList<Filter> allFilters = new CopyOnWriteArrayList();
    private CopyOnWriteArraySet<Filter> enabledFilters = new CopyOnWriteArraySet();

    public QuickFilterTypeTable(Header filetypeFilter, LinkGrabberTable table2Filter) {
        super(filetypeFilter, table2Filter, CFG_LINKFILTER.LINKGRABBER_FILETYPE_QUICKFILTER_ENABLED);
        this.init();
    }

    @Override
    protected FilterTableDataUpdater getFilterTableDataUpdater() {
        final ArrayList<Filter> availableFilters = new ArrayList<Filter>(this.allFilters);
        return new FilterTableDataUpdater(){
            private Set<Filter> usedFilters = new HashSet<Filter>();

            @Override
            public void updateVisible(CrawledLink link) {
                for (Filter filter : availableFilters) {
                    if (!((ExtensionFilter)filter).isFiltered(link)) continue;
                    this.usedFilters.add(filter);
                    filter.increaseCounter();
                    break;
                }
            }

            @Override
            public void reset() {
                for (Filter filter : availableFilters) {
                    filter.resetCounter();
                }
            }

            @Override
            public void afterVisible() {
                availableFilters.removeAll(this.usedFilters);
            }

            @Override
            public void updateFiltered(CrawledLink link) {
                if (availableFilters.size() > 0) {
                    Iterator it = availableFilters.iterator();
                    while (it.hasNext()) {
                        Filter filter = (Filter)it.next();
                        if (!((ExtensionFilter)filter).isFiltered(link)) continue;
                        this.usedFilters.add(filter);
                        it.remove();
                        break;
                    }
                }
            }

            @Override
            public List<Filter> finalizeUpdater() {
                return new ArrayList<Filter>(this.usedFilters);
            }

            @Override
            public FilterTable getFilterTable() {
                return QuickFilterTypeTable.this;
            }

            @Override
            public boolean hasNewDisabledFilters() {
                return false;
            }
        };
    }

    private void setEnabled(boolean enabled, ExtensionFilter filter) {
        if (!enabled) {
            this.enabledFilters.add(filter);
        } else {
            this.enabledFilters.remove(filter);
        }
        this.getLinkgrabberTable().getModel().recreateModel(false);
    }

    public void init() {
        SecondLevelLaunch.INIT_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new Thread("QuickFilterTypeTable"){

                    @Override
                    public void run() {
                        ArrayList<1> knownExtensionFilters = new ArrayList<1>();
                        ExtensionFilter filter = null;
                        filter = new ExtensionFilter(CompiledFiletypeFilter.HashExtensions.MD5){
                            private final String description;
                            {
                                this.description = _JDT.T.hashfilter_description();
                            }

                            @Override
                            protected String getID() {
                                return "Type_Hash";
                            }

                            @Override
                            public String getDescription() {
                                return this.description;
                            }

                            @Override
                            public void setEnabled(boolean enabled) {
                                super.setEnabled(enabled);
                                QuickFilterTypeTable.this.setEnabled(enabled, this);
                            }
                        };
                        QuickFilterTypeTable.this.allFilters.add(filter);
                        knownExtensionFilters.add(filter);
                        filter = new ExtensionFilter(CompiledFiletypeFilter.AudioExtensions.AAC){
                            private final String description;
                            {
                                this.description = _JDT.T.audiofilter_description();
                            }

                            @Override
                            protected String getID() {
                                return "Type_Audio";
                            }

                            @Override
                            public String getDescription() {
                                return this.description;
                            }

                            @Override
                            public void setEnabled(boolean enabled) {
                                super.setEnabled(enabled);
                                QuickFilterTypeTable.this.setEnabled(enabled, this);
                            }
                        };
                        QuickFilterTypeTable.this.allFilters.add(filter);
                        knownExtensionFilters.add(filter);
                        filter = new ExtensionFilter(CompiledFiletypeFilter.VideoExtensions.ASF){
                            private final String description;
                            {
                                this.description = _JDT.T.video_description();
                            }

                            @Override
                            protected String getID() {
                                return "Type_Video";
                            }

                            @Override
                            public String getDescription() {
                                return this.description;
                            }

                            @Override
                            public void setEnabled(boolean enabled) {
                                super.setEnabled(enabled);
                                QuickFilterTypeTable.this.setEnabled(enabled, this);
                            }
                        };
                        QuickFilterTypeTable.this.allFilters.add(filter);
                        knownExtensionFilters.add(filter);
                        filter = new ExtensionFilter(CompiledFiletypeFilter.ImageExtensions.BMP){
                            private final String description;
                            {
                                this.description = _JDT.T.image_description();
                            }

                            @Override
                            protected String getID() {
                                return "Type_Image";
                            }

                            @Override
                            public String getDescription() {
                                return this.description;
                            }

                            @Override
                            public void setEnabled(boolean enabled) {
                                super.setEnabled(enabled);
                                QuickFilterTypeTable.this.setEnabled(enabled, this);
                            }
                        };
                        QuickFilterTypeTable.this.allFilters.add(filter);
                        knownExtensionFilters.add(filter);
                        filter = new ExtensionFilter(CompiledFiletypeFilter.ArchiveExtensions.ACE){
                            private final String description;
                            {
                                this.description = _JDT.T.archive_description();
                            }

                            @Override
                            protected String getID() {
                                return "Type_Archive";
                            }

                            @Override
                            public String getDescription() {
                                return this.description;
                            }

                            @Override
                            public void setEnabled(boolean enabled) {
                                super.setEnabled(enabled);
                                QuickFilterTypeTable.this.setEnabled(enabled, this);
                            }
                        };
                        QuickFilterTypeTable.this.allFilters.add(filter);
                        knownExtensionFilters.add(filter);
                        filter = new ExtensionFilter(CompiledFiletypeFilter.DocumentExtensions.TXT){
                            private final String description;
                            {
                                this.description = _JDT.T.doc_description();
                            }

                            @Override
                            protected String getID() {
                                return "Type_Doc";
                            }

                            @Override
                            public String getDescription() {
                                return this.description;
                            }

                            @Override
                            public void setEnabled(boolean enabled) {
                                super.setEnabled(enabled);
                                QuickFilterTypeTable.this.setEnabled(enabled, this);
                            }
                        };
                        QuickFilterTypeTable.this.allFilters.add(filter);
                        knownExtensionFilters.add(filter);
                        filter = new ExtensionFilter(CompiledFiletypeFilter.SubtitleExtensions.SRT){
                            private final String description;
                            {
                                this.description = _JDT.T.sub_description();
                            }

                            @Override
                            protected String getID() {
                                return "Type_Sub";
                            }

                            @Override
                            public String getDescription() {
                                return this.description;
                            }

                            @Override
                            public void setEnabled(boolean enabled) {
                                super.setEnabled(enabled);
                                QuickFilterTypeTable.this.setEnabled(enabled, this);
                            }
                        };
                        QuickFilterTypeTable.this.allFilters.add(filter);
                        knownExtensionFilters.add(filter);
                        filter = new ExtensionFilter(CompiledFiletypeFilter.ExecutableExtensions.EXE){
                            private final String description;
                            {
                                this.description = _JDT.T.exe_description();
                            }

                            @Override
                            protected String getID() {
                                return "Type_Exe";
                            }

                            @Override
                            public String getDescription() {
                                return this.description;
                            }

                            @Override
                            public void setEnabled(boolean enabled) {
                                super.setEnabled(enabled);
                                QuickFilterTypeTable.this.setEnabled(enabled, this);
                            }
                        };
                        QuickFilterTypeTable.this.allFilters.add(filter);
                        knownExtensionFilters.add(filter);
                        knownExtensionFilters.trimToSize();
                        final CompiledFiletypeFilter.ExtensionsFilterInterface other = new CompiledFiletypeFilter.ExtensionsFilterInterface(){

                            @Override
                            public String name() {
                                return "OTHERS";
                            }

                            @Override
                            public boolean isSameExtensionGroup(CompiledFiletypeFilter.ExtensionsFilterInterface extension) {
                                return extension != null && !(extension.getSource() instanceof Enum);
                            }

                            @Override
                            public CompiledFiletypeFilter.ExtensionsFilterInterface[] listSameGroup() {
                                return new CompiledFiletypeFilter.ExtensionsFilterInterface[]{this};
                            }

                            @Override
                            public Pattern getPattern() {
                                return null;
                            }

                            @Override
                            public String getIconID() {
                                return "file";
                            }

                            @Override
                            public String getDesc() {
                                return _GUI.T.settings_linkgrabber_filter_others();
                            }

                            @Override
                            public Pattern compiledAllPattern() {
                                return null;
                            }

                            @Override
                            public CompiledFiletypeFilter.ExtensionsFilterInterface getSource() {
                                return this;
                            }
                        };
                        filter = new ExtensionFilter(other){
                            private final String description;
                            {
                                super(filter);
                                this.description = _JDT.T.other_files_description();
                            }

                            @Override
                            protected String getID() {
                                return "Type_Others";
                            }

                            @Override
                            public String getDescription() {
                                return this.description;
                            }

                            @Override
                            public boolean isFiltered(CrawledLink link) {
                                CompiledFiletypeFilter.ExtensionsFilterInterface extension = link.getLinkInfo().getExtension();
                                return extension == null || other.isSameExtensionGroup(extension);
                            }

                            @Override
                            public void setEnabled(boolean enabled) {
                                super.setEnabled(enabled);
                                QuickFilterTypeTable.this.setEnabled(enabled, this);
                            }
                        };
                        QuickFilterTypeTable.this.allFilters.add(filter);
                        for (Filter filterCheck : QuickFilterTypeTable.this.allFilters) {
                            if (filterCheck.isEnabled()) continue;
                            QuickFilterTypeTable.this.enabledFilters.add(filterCheck);
                        }
                        QuickFilterTypeTable.this.requestUpdate();
                    }
                }.start();
            }
        });
    }

    @Override
    public int getComplexity() {
        return 1;
    }

    @Override
    public boolean isFiltered(CrawledLink v) {
        Filter exception = QuickFilterTypeTable.getFilterException();
        for (Filter enabledFilter : this.enabledFilters) {
            if (enabledFilter == exception || !enabledFilter.isFiltered(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFilteringChildrenNodes() {
        return this.isEnabled() && this.enabledFilters.size() > 0;
    }
}

