/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.icon;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import org.appwork.swing.components.circlebar.CircledProgressBar;
import org.appwork.swing.components.circlebar.IconPainter;
import org.appwork.utils.ImageProvider.ImageProvider;

public class IconBadgePainter {
    private Image back;
    private CircledProgressBar m;

    public IconBadgePainter(Image image) {
        this.back = image;
        this.m = new CircledProgressBar();
        this.m.setValueClipPainter(new IconPainter(){
            private Dimension dimension = new Dimension(75, 75);

            public void paint(CircledProgressBar bar, Graphics2D g2, Shape shape, int diameter, double progress) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setComposite(AlphaComposite.getInstance(3, 0.8f));
                Area a = new Area(shape);
                g2.setColor(Color.GREEN);
                a.intersect(new Area(new Ellipse2D.Float(-diameter / 2, -diameter / 2, diameter, diameter)));
                g2.fill(a);
                g2.setStroke(new BasicStroke(2.0f, 1, 1));
                g2.setColor(Color.DARK_GRAY);
                g2.draw(new Area(new Ellipse2D.Float(-(diameter - 2) / 2, -(diameter - 2) / 2, diameter - 2, diameter - 2)));
            }

            public Dimension getPreferredSize() {
                return this.dimension;
            }
        });
        this.m.setNonvalueClipPainter(new IconPainter(){
            private Dimension dimension = new Dimension(75, 75);

            public void paint(CircledProgressBar bar, Graphics2D g2, Shape shape, int diameter, double progress) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setComposite(AlphaComposite.getInstance(3, 0.8f));
                Area a = new Area(shape);
                g2.setColor(Color.WHITE);
                a.intersect(new Area(new Ellipse2D.Float(-diameter / 2, -diameter / 2, diameter, diameter)));
                g2.fill(a);
            }

            public Dimension getPreferredSize() {
                return this.dimension;
            }
        });
        this.m.setMaximum(100);
    }

    public Image getImage(int percent, String string) {
        this.m.setValue(percent);
        this.m.setSize(75, 75);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage img = gc.createCompatibleImage(this.back.getWidth(null), this.back.getHeight(null), 3);
        Graphics2D g2 = img.createGraphics();
        g2.drawImage(this.back, 0, 0, null);
        g2.translate(128 - this.m.getWidth() - 3, 128 - this.m.getHeight() - 3);
        this.m.paint((Graphics)g2);
        g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g2.setColor(Color.BLACK);
        g2.setFont(new Font(ImageProvider.getDrawFontName(), 1, 30));
        int w = g2.getFontMetrics().stringWidth(string);
        FontRenderContext renderContext = g2.getFontRenderContext();
        Rectangle bounds = g2.getFont().createGlyphVector(renderContext, string).getPixelBounds(null, 0.0f, 0.0f);
        g2.drawString(string, (this.m.getWidth() - w) / 2, (int)((bounds.getHeight() + (double)this.m.getHeight()) / 2.0));
        g2.dispose();
        return img;
    }
}

