/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.jna.unix;

import com.sun.jna.platform.linux.LibC;
import java.io.File;
import org.jdownloader.logging.LogController;

public class FileSystemHelper {
    private static boolean JNA_AVAILABLE = true;

    public static int getAllocationUnitSize(File file) {
        if (!JNA_AVAILABLE) {
            return -1;
        }
        try {
            File path;
            for (path = file; path != null && !path.exists(); path = path.getParentFile()) {
            }
            if (path == null) {
                return -1;
            }
            LibC.Statvfs vfs = new LibC.Statvfs();
            if (LibC.INSTANCE.statvfs(path.getPath(), vfs) != 0) {
                return -1;
            }
            return vfs.f_bsize.intValue();
        }
        catch (LinkageError e) {
            JNA_AVAILABLE = false;
            LogController.CL().log((Throwable)e);
        }
        catch (Exception e) {
            LogController.CL().log((Throwable)e);
        }
        return -1;
    }
}

