/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.jna.windows;

import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinioctlUtil;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.io.IOException;
import org.appwork.utils.Files;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.jna.windows.Kernel32;
import org.jdownloader.logging.LogController;

public class FileSystemHelper {
    public static final int FSCTL_SET_SPARSE = WinioctlUtil.CTL_CODE((int)9, (int)49, (int)0, (int)0);

    public static int getAllocationUnitSize(File file) {
        try {
            String rootPath = Files.guessRoot((File)file).getPath();
            if (!rootPath.endsWith("\\")) {
                rootPath = rootPath + "\\";
            }
            int driveType = com.sun.jna.platform.win32.Kernel32.INSTANCE.GetDriveType(rootPath);
            switch (driveType) {
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    return -1;
                }
            }
            WinDef.DWORDByReference lpSectorsPerCluster = new WinDef.DWORDByReference();
            WinDef.DWORDByReference lpBytesPerSector = new WinDef.DWORDByReference();
            WinDef.DWORDByReference lpNumberOfFreeClusters = new WinDef.DWORDByReference();
            WinDef.DWORDByReference lpTotalNumberOfClusters = new WinDef.DWORDByReference();
            if (!com.sun.jna.platform.win32.Kernel32.INSTANCE.GetDiskFreeSpace(rootPath, lpSectorsPerCluster, lpBytesPerSector, lpNumberOfFreeClusters, lpTotalNumberOfClusters)) {
                throw new IOException("GetDiskFreeSpace:" + rootPath + "|" + Kernel32Util.formatMessage((int)com.sun.jna.platform.win32.Kernel32.INSTANCE.GetLastError()));
            }
            return lpSectorsPerCluster.getValue().intValue() * lpBytesPerSector.getValue().intValue();
        }
        catch (Exception e) {
            LogController.CL().log((Throwable)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean FSCTL_SET_SPARSE(File file, boolean sparseFlag) {
        boolean bl;
        WinNT.HANDLE fileHandle = null;
        try {
            CrossSystem.OperatingSystem os = CrossSystem.getOS();
            if (!os.isMinimum(CrossSystem.OperatingSystem.WINDOWS_8)) {
                boolean bl2 = false;
                return bl2;
            }
            fileHandle = com.sun.jna.platform.win32.Kernel32.INSTANCE.CreateFile(file.getAbsolutePath(), -1073741824, 0, null, 3, 128, null);
            if (fileHandle == null) {
                throw new IOException("CreateFile:" + file + "|" + Kernel32Util.formatMessage((int)com.sun.jna.platform.win32.Kernel32.INSTANCE.GetLastError()));
            }
            FILE_SET_SPARSE_BUFFER b = new FILE_SET_SPARSE_BUFFER(sparseFlag);
            IntByReference lpBytes = new IntByReference();
            if (!Kernel32.INSTANCE.DeviceIoControl(fileHandle, FSCTL_SET_SPARSE, b.getPointer(), b.size(), null, 0, lpBytes, null)) {
                throw new IOException("DeviceIoControl:" + file + "|" + sparseFlag + "|" + Kernel32Util.formatMessage((int)com.sun.jna.platform.win32.Kernel32.INSTANCE.GetLastError()));
            }
            bl = true;
            Kernel32.INSTANCE.CloseHandle(fileHandle);
        }
        catch (Exception e) {
            LogController.CL().log((Throwable)e);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(fileHandle);
        }
        return bl;
    }

    @Structure.FieldOrder(value={"sparseFlag"})
    public static class FILE_SET_SPARSE_BUFFER
    extends Structure {
        public boolean sparseFlag;

        public FILE_SET_SPARSE_BUFFER(boolean sparseFlag) {
            this.sparseFlag = sparseFlag;
            this.write();
        }
    }
}

