/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.myjdownloader.client;

import org.jdownloader.myjdownloader.client.AbstractMyJDClient;
import org.jdownloader.myjdownloader.client.exceptions.DirectConnectionException;
import org.jdownloader.myjdownloader.client.exceptions.MyJDownloaderException;
import org.jdownloader.myjdownloader.client.exceptions.UnexpectedIOException;
import org.jdownloader.myjdownloader.client.json.DirectConnectionInfo;
import org.jdownloader.myjdownloader.client.json.DirectConnectionInfos;

public class AbstractMyJDDeviceClient<GenericType> {
    private final AbstractMyJDClient<GenericType> api;
    private final String deviceID;
    private DirectConnectionInfo connection = null;
    private boolean autoFallback = true;

    public AbstractMyJDDeviceClient(String deviceID, AbstractMyJDClient<GenericType> abstractMyJDClient) {
        this.api = abstractMyJDClient;
        this.deviceID = deviceID;
    }

    public Object callAction(String action, GenericType returnType, Object ... args) throws MyJDownloaderException {
        DirectConnectionInfo lconnection = this.connection;
        String host = null;
        if (lconnection != null) {
            host = "http://" + lconnection.getIp() + ":" + lconnection.getPort();
        }
        try {
            return this.api.callAction(host, this.getDeviceID(), action, returnType, args);
        }
        catch (MyJDownloaderException e) {
            if (this.onDirectConnectionException(lconnection, e)) {
                return this.api.callAction((String)null, this.getDeviceID(), action, returnType, args);
            }
            throw e;
        }
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public DirectConnectionInfo getDirectConnectionInfo() {
        return this.connection;
    }

    public DirectConnectionInfos getDirectConnectionInfos() throws MyJDownloaderException {
        return this.api.getDirectConnectionInfos(this.getDeviceID());
    }

    public boolean isAutoFallbackEnabled() {
        return this.autoFallback;
    }

    protected boolean onDirectConnectionException(DirectConnectionInfo directConnectionInfo, MyJDownloaderException e) throws MyJDownloaderException {
        if (directConnectionInfo != null && e instanceof UnexpectedIOException) {
            if (!this.isAutoFallbackEnabled()) {
                Throwable cause = e;
                Exception rootCause = e;
                while ((cause = cause.getCause()) != null && cause instanceof Exception) {
                    rootCause = cause;
                }
                throw new DirectConnectionException(rootCause);
            }
            return true;
        }
        return false;
    }

    public void setAutoFallbackEnabled(boolean autoFallback) {
        this.autoFallback = autoFallback;
    }

    public void setDirectConnectionInfo(DirectConnectionInfo connection) {
        this.connection = connection;
    }

    public boolean verifyDirectConnectionInfo(DirectConnectionInfo connection) throws MyJDownloaderException {
        if (connection == null) {
            return false;
        }
        return this.api.verifyDirectConnectionInfo(this.getDeviceID(), connection);
    }
}

