/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.myjdownloader.client;

import java.util.List;
import org.jdownloader.myjdownloader.client.AbstractMyJDClient;
import org.jdownloader.myjdownloader.client.SessionInfo;
import org.jdownloader.myjdownloader.client.exceptions.MyJDownloaderException;
import org.jdownloader.myjdownloader.client.json.JSonRequest;
import org.jdownloader.myjdownloader.client.json.MyCaptchaChallenge;
import org.jdownloader.myjdownloader.client.json.MyCaptchaSolution;
import org.jdownloader.myjdownloader.client.json.MyCaptchaSolutionsListResponse;
import org.jdownloader.myjdownloader.client.json.SuccessfulResponse;

public class MyJDCaptchasClient<GenericType> {
    private final AbstractMyJDClient<GenericType> api;

    public MyJDCaptchasClient(AbstractMyJDClient<GenericType> abstractMyJDClient) {
        this.api = abstractMyJDClient;
    }

    public boolean abort(String ID2) throws MyJDownloaderException {
        return this.remove(ID2, MyCaptchaSolution.RESULT.ABORT);
    }

    public MyCaptchaSolution get(String ID2) throws MyJDownloaderException {
        List<MyCaptchaSolution> ret = this.get(new String[]{ID2});
        if (ret != null && ret.size() == 1) {
            return ret.get(0);
        }
        return null;
    }

    public List<MyCaptchaSolution> get(String[] IDs) throws MyJDownloaderException {
        SessionInfo sessionInfo = this.api.getSessionInfo();
        String url = "/my/captchas/get?sessiontoken=" + this.api.urlencode(sessionInfo.getSessionToken());
        JSonRequest re = new JSonRequest();
        re.setParams(new Object[]{IDs});
        re.setUrl(url);
        List<MyCaptchaSolution> list = this.api.callServer(url, re, sessionInfo, MyCaptchaSolutionsListResponse.class).getList();
        return list;
    }

    public boolean invalidate(String ID2) throws MyJDownloaderException {
        return this.remove(ID2, MyCaptchaSolution.RESULT.WRONG);
    }

    public List<MyCaptchaSolution> list() throws MyJDownloaderException {
        return this.get((String[])null);
    }

    public boolean remove(String ID2, MyCaptchaSolution.RESULT result) throws MyJDownloaderException {
        SessionInfo sessionInfo = this.api.getSessionInfo();
        String url = "/my/captchas/remove?sessiontoken=" + this.api.urlencode(sessionInfo.getSessionToken());
        JSonRequest re = new JSonRequest();
        re.setParams(new Object[]{ID2, result});
        re.setUrl(url);
        return this.api.callServer(url, re, sessionInfo, SuccessfulResponse.class).isSuccessful();
    }

    public boolean isEnabled() throws MyJDownloaderException {
        SessionInfo sessionInfo = this.api.getSessionInfo();
        String url = "/my/captchas/isEnabled?sessiontoken=" + this.api.urlencode(sessionInfo.getSessionToken());
        JSonRequest re = new JSonRequest();
        re.setUrl(url);
        return this.api.callServer(url, re, sessionInfo, SuccessfulResponse.class).isSuccessful();
    }

    public MyCaptchaSolution solve(MyCaptchaChallenge myCaptchaChallenge) throws MyJDownloaderException {
        SessionInfo sessionInfo = this.api.getSessionInfo();
        String url = "/my/captchas/solve?sessiontoken=" + this.api.urlencode(sessionInfo.getSessionToken());
        JSonRequest re = new JSonRequest();
        re.setParams(new Object[]{myCaptchaChallenge});
        re.setUrl(url);
        List<MyCaptchaSolution> list = this.api.callServer(url, re, sessionInfo, MyCaptchaSolutionsListResponse.class).getList();
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    public boolean timeout(String ID2) throws MyJDownloaderException {
        return this.remove(ID2, MyCaptchaSolution.RESULT.TIMEOUT);
    }

    public boolean validate(String ID2) throws MyJDownloaderException {
        return this.remove(ID2, MyCaptchaSolution.RESULT.CORRECT);
    }
}

