/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.myjdownloader.client;

import java.util.Map;
import org.jdownloader.myjdownloader.client.AbstractMyJDClient;
import org.jdownloader.myjdownloader.client.SessionInfo;
import org.jdownloader.myjdownloader.client.exceptions.ExceptionResponse;
import org.jdownloader.myjdownloader.client.exceptions.MyJDownloaderException;
import org.jdownloader.myjdownloader.client.exceptions.UnexpectedIOException;
import org.jdownloader.myjdownloader.client.exceptions.storage.StorageAlreadyExistsException;
import org.jdownloader.myjdownloader.client.exceptions.storage.StorageInvalidIDException;
import org.jdownloader.myjdownloader.client.exceptions.storage.StorageInvalidKeyException;
import org.jdownloader.myjdownloader.client.exceptions.storage.StorageKeyNotFoundException;
import org.jdownloader.myjdownloader.client.exceptions.storage.StorageLimitReachedException;
import org.jdownloader.myjdownloader.client.exceptions.storage.StorageNotFoundException;
import org.jdownloader.myjdownloader.client.json.ErrorResponse;
import org.jdownloader.myjdownloader.client.json.JSonRequest;
import org.jdownloader.myjdownloader.client.json.RequestIDOnly;
import org.jdownloader.myjdownloader.client.json.ServerErrorType;
import org.jdownloader.myjdownloader.client.json.storage.StorageGetValueResponse;
import org.jdownloader.myjdownloader.client.json.storage.StorageListResponse;

public class StorageMyJDClient<GenericType> {
    private final AbstractMyJDClient<GenericType> api;

    public StorageMyJDClient(AbstractMyJDClient<GenericType> abstractMyJDClient) {
        this.api = abstractMyJDClient;
    }

    protected <T> T callServer(String query, JSonRequest jsonRequest, SessionInfo session, Class<T> class1) throws MyJDownloaderException {
        try {
            return this.api.callServer(query, jsonRequest, session, class1);
        }
        catch (UnexpectedIOException e) {
            if (e.getCause() instanceof ExceptionResponse) {
                ErrorResponse error = null;
                try {
                    ExceptionResponse cause = (ExceptionResponse)e.getCause();
                    error = (ErrorResponse)this.api.jsonToObject(cause.getContent(), ErrorResponse.class);
                }
                catch (Throwable cause) {
                    // empty catch block
                }
                if (error != null) {
                    switch (error.getSrc()) {
                        case MYJD: {
                            ServerErrorType type = ServerErrorType.valueOf(error.getType());
                            switch (type) {
                                case STORAGE_ALREADY_EXISTS: {
                                    throw new StorageAlreadyExistsException();
                                }
                                case STORAGE_INVALID_KEY: {
                                    throw new StorageInvalidKeyException();
                                }
                                case STORAGE_INVALID_STORAGEID: {
                                    throw new StorageInvalidIDException();
                                }
                                case STORAGE_NOT_FOUND: {
                                    throw new StorageNotFoundException();
                                }
                                case STORAGE_KEY_NOT_FOUND: {
                                    throw new StorageKeyNotFoundException();
                                }
                                case STORAGE_LIMIT_REACHED: {
                                    throw new StorageLimitReachedException();
                                }
                            }
                        }
                    }
                }
            }
            throw e;
        }
    }

    public void create(String storageID) throws MyJDownloaderException, StorageAlreadyExistsException, StorageInvalidIDException {
        SessionInfo sessionInfo = this.api.getSessionInfo();
        String url = "/storage/createstorage?sessiontoken=" + this.api.urlencode(sessionInfo.getSessionToken());
        JSonRequest re = new JSonRequest();
        re.setParams(new Object[]{storageID});
        re.setUrl(url);
        this.callServer(url, re, sessionInfo, RequestIDOnly.class);
    }

    public void drop(String storageID) throws MyJDownloaderException, StorageNotFoundException, StorageInvalidIDException {
        SessionInfo sessionInfo = this.api.getSessionInfo();
        String url = "/storage/dropstorage?sessiontoken=" + this.api.urlencode(sessionInfo.getSessionToken());
        JSonRequest request = new JSonRequest();
        request.setParams(new Object[]{storageID});
        request.setUrl(url);
        this.callServer(url, request, sessionInfo, RequestIDOnly.class);
    }

    public String getValue(String storageID, String key) throws MyJDownloaderException {
        SessionInfo sessionInfo = this.api.getSessionInfo();
        String url = "/storage/getvalue?sessiontoken=" + this.api.urlencode(sessionInfo.getSessionToken());
        JSonRequest request = new JSonRequest();
        request.setParams(new Object[]{storageID, key});
        request.setUrl(url);
        return this.callServer(url, request, sessionInfo, StorageGetValueResponse.class).getValue();
    }

    public Map<String, Long> list() throws MyJDownloaderException {
        SessionInfo sessionInfo = this.api.getSessionInfo();
        String url = "/storage/liststorages?sessiontoken=" + this.api.urlencode(sessionInfo.getSessionToken());
        return this.callServer(url, null, sessionInfo, StorageListResponse.class).getList();
    }

    public Map<String, Long> listKeys(String storageID) throws MyJDownloaderException {
        SessionInfo sessionInfo = this.api.getSessionInfo();
        String url = "/storage/listkeys?sessiontoken=" + this.api.urlencode(sessionInfo.getSessionToken());
        JSonRequest request = new JSonRequest();
        request.setParams(new Object[]{storageID});
        request.setUrl(url);
        return this.callServer(url, request, sessionInfo, StorageListResponse.class).getList();
    }

    public void putValue(String storageID, String key, String value) throws MyJDownloaderException {
        SessionInfo sessionInfo = this.api.getSessionInfo();
        String url = "/storage/putvalue?sessiontoken=" + this.api.urlencode(sessionInfo.getSessionToken());
        JSonRequest request = new JSonRequest();
        request.setParams(new Object[]{storageID, key, value});
        request.setUrl(url);
        this.callServer(url, request, sessionInfo, RequestIDOnly.class);
    }

    public void removeKey(String storageID, String key) throws MyJDownloaderException {
        SessionInfo sessionInfo = this.api.getSessionInfo();
        String url = "/storage/removekey?sessiontoken=" + this.api.urlencode(sessionInfo.getSessionToken());
        JSonRequest request = new JSonRequest();
        request.setParams(new Object[]{storageID, key});
        request.setUrl(url);
        this.callServer(url, request, sessionInfo, RequestIDOnly.class);
    }
}

