/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.myjdownloader.client.eventsender;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.jdownloader.myjdownloader.client.eventsender.DefaultEvent;

public abstract class Eventsender<ListenerType extends EventListener, EventType extends DefaultEvent> {
    protected volatile transient List<ListenerType> strongListeners = null;
    protected volatile transient List<WeakReference<ListenerType>> weakListener = null;
    private final Object LOCK = new Object();

    public Eventsender() {
        this.strongListeners = new ArrayList<ListenerType>();
        this.weakListener = new ArrayList<WeakReference<ListenerType>>();
    }

    public void addAllListener(List<ListenerType> listener) {
        this.addAllListener(listener, false);
    }

    public void addAllListener(List<ListenerType> listener, boolean weak) {
        for (EventListener l : listener) {
            this.addListener(l, weak);
        }
    }

    public void addListener(ListenerType t) {
        this.addListener(t, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ListenerType t, boolean weak) {
        if (t == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            boolean added = false;
            if (!weak) {
                ArrayList<ListenerType> newStrongListener = new ArrayList<ListenerType>(this.strongListeners);
                if (!newStrongListener.contains(t)) {
                    newStrongListener.add(t);
                }
                this.strongListeners = newStrongListener;
            }
            EventListener l = null;
            ArrayList<WeakReference<ListenerType>> newWeakListener = new ArrayList<WeakReference<ListenerType>>(this.weakListener.size());
            for (WeakReference<ListenerType> listener : this.weakListener) {
                l = (EventListener)listener.get();
                if (l == null) continue;
                if (l == t) {
                    added = true;
                    newWeakListener.add(listener);
                    continue;
                }
                newWeakListener.add(listener);
            }
            if (!added) {
                newWeakListener.add(new WeakReference<ListenerType>(t));
            }
            this.weakListener = newWeakListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<WeakReference<ListenerType>> newWeakListener = new ArrayList<WeakReference<ListenerType>>(this.weakListener.size());
            for (WeakReference<ListenerType> listener : this.weakListener) {
                if (listener.get() == null) continue;
                newWeakListener.add(listener);
            }
            this.weakListener = newWeakListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsListener(ListenerType t) {
        if (t == null) {
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            for (EventListener tmp : this.strongListeners) {
                if (tmp != t) continue;
                return true;
            }
            EventListener l = null;
            for (WeakReference<ListenerType> listener : this.weakListener) {
                l = (EventListener)listener.get();
                if (l == null || l != t) continue;
                return true;
            }
            return false;
        }
    }

    public final void fireEvent(EventType event) {
        if (event == null) {
            return;
        }
        EventListener t = null;
        boolean cleanup = false;
        List<WeakReference<ListenerType>> listeners = this.weakListener;
        for (WeakReference<ListenerType> listener : listeners) {
            t = (EventListener)listener.get();
            if (t == null) {
                cleanup = true;
                continue;
            }
            this.fireEvent(t, event);
        }
        if (cleanup && listeners.size() > 0) {
            this.cleanup();
        }
    }

    public final void fireEvent(int id, Object ... parameters) {
        EventListener t = null;
        boolean cleanup = false;
        List<WeakReference<ListenerType>> listeners = this.weakListener;
        for (WeakReference<ListenerType> listener : listeners) {
            t = (EventListener)listener.get();
            if (t == null) {
                cleanup = true;
                continue;
            }
            this.fireEvent(t, id, parameters);
        }
        if (cleanup && listeners.size() > 0) {
            this.cleanup();
        }
    }

    protected abstract void fireEvent(ListenerType var1, EventType var2);

    protected void fireEvent(ListenerType listener, int id, Object ... parameters) {
        throw new RuntimeException("Not implemented. Overwrite org.appwork.utils.event.Eventsender.fireEvent(T, int, Object...) to use this");
    }

    public List<ListenerType> getListener() {
        List<WeakReference<ListenerType>> listeners = this.weakListener;
        boolean cleanup = true;
        ArrayList<EventListener> ret = new ArrayList<EventListener>(listeners.size());
        EventListener t = null;
        for (WeakReference<ListenerType> listener : listeners) {
            t = (EventListener)listener.get();
            if (t != null) {
                ret.add(t);
                continue;
            }
            cleanup = true;
        }
        if (cleanup && listeners.size() > 0) {
            this.cleanup();
        }
        return ret;
    }

    public boolean hasListener() {
        List<WeakReference<ListenerType>> listeners = this.weakListener;
        for (WeakReference<ListenerType> listener : listeners) {
            if (listener.get() == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ListenerType t) {
        if (t == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            EventListener l = null;
            ArrayList<WeakReference<ListenerType>> newWeakListener = new ArrayList<WeakReference<ListenerType>>(this.weakListener.size());
            ArrayList<ListenerType> newStrongListener = new ArrayList<ListenerType>(this.strongListeners);
            for (WeakReference<ListenerType> listener : this.weakListener) {
                l = (EventListener)listener.get();
                if (l == null || l == t) continue;
                newWeakListener.add(listener);
            }
            newStrongListener.remove(t);
            this.weakListener = newWeakListener;
            this.strongListeners = newStrongListener;
        }
    }
}

