/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.appwork.utils.DebugMode;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SSLSocketStreamInterface;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.IDNUtil;
import org.bouncycastle.jsse.provider.SSLSocketFactoryImpl;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CipherSuite;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsNoCloseNotifyException;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.Strings;
import org.jdownloader.logging.LogController;

public class BCSSLSocketStreamFactory
implements SSLSocketStreamFactory {
    protected static final Provider BC = new BouncyCastleProvider();
    private static final String TLS13_ENABLED = "BC_TLS1.3_ENABLED";
    private static final String TLS10_11_DISABLED = "BC_TLS10_11_DISABLED";
    protected static final String CIPHERS = "CHACHA20:EECDH+AESGCM:EDH+AESGCM:ECDHE-RSA-AES128-GCM-SHA256:AES256+EECDH:DHE-RSA-AES128-GCM-SHA256:AES256+EDH:ECDHE-RSA-AES256-GCM-SHA384:DHE-RSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-SHA384:ECDHE-RSA-AES128-SHA256:ECDHE-RSA-AES256-SHA:ECDHE-RSA-AES128-SHA:DHE-RSA-AES256-SHA256:DHE-RSA-AES128-SHA256:DHE-RSA-AES256-SHA:DHE-RSA-AES128-SHA:ECDHE-RSA-DES-CBC3-SHA:EDH-RSA-DES-CBC3-SHA:AES256-GCM-SHA384:AES128-GCM-SHA256:AES256-SHA256:AES128-SHA256:AES256-SHA:AES128-SHA:DES-CBC3-SHA:HIGH:!anon:!eNULL:!DHE:!SRP:!EXPORT:!DES:!MD5:!PSK:!RC4";
    protected static final HashMap<Integer, String> CIPHERSUITENAMES = new HashMap();
    protected static int[] CIPHERSUITES;

    protected int[] modifyCipherSuites(int[] cipherSuites, SSLSocketStreamOptions options) {
        if (cipherSuites != null && options != null) {
            ArrayList<String> avoided = new ArrayList<String>();
            ArrayList<String> preferred = new ArrayList<String>();
            ArrayList<String> disabled = new ArrayList<String>();
            ArrayList<String> list = new ArrayList<String>();
            for (int cipherSuite : cipherSuites) {
                list.add(BCSSLSocketStreamFactory.getCipherSuiteName(cipherSuite));
            }
            if (options.getDisabledCipherSuites().size() > 0) {
                Object object = options.getDisabledCipherSuites().iterator();
                while (object.hasNext()) {
                    String disabledEntry = (String)object.next();
                    Iterator it = list.iterator();
                    block2: while (it.hasNext()) {
                        String next = (String)it.next();
                        if (!StringUtils.containsIgnoreCase((String)next, (String)disabledEntry)) continue;
                        if (!disabledEntry.endsWith("_")) {
                            for (String enabledEntry : options.getEnabledCipherSuites()) {
                                if (!StringUtils.containsIgnoreCase((String)next, (String)enabledEntry)) continue;
                                continue block2;
                            }
                        }
                        it.remove();
                        disabled.add(next);
                    }
                }
            }
            if (options.getAvoidedCipherSuites().size() > 0) {
                for (String avoidedEntry : options.getAvoidedCipherSuites()) {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        String next = (String)it.next();
                        if (!StringUtils.containsIgnoreCase((String)next, (String)avoidedEntry)) continue;
                        it.remove();
                        avoided.add(next);
                    }
                }
            }
            if (options.getPreferredCipherSuites().size() > 0) {
                for (String preferredEntry : options.getPreferredCipherSuites()) {
                    String next;
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        next = (String)it.next();
                        if (!StringUtils.containsIgnoreCase((String)next, (String)preferredEntry)) continue;
                        it.remove();
                        preferred.add(next);
                    }
                    it = avoided.iterator();
                    while (it.hasNext()) {
                        next = (String)it.next();
                        if (!StringUtils.containsIgnoreCase((String)next, (String)preferredEntry)) continue;
                        it.remove();
                        preferred.add(next);
                    }
                }
            }
            if (disabled.size() > 0 || preferred.size() > 0 || avoided.size() > 0) {
                if (preferred.size() > 0) {
                    list.addAll(0, preferred);
                }
                if (avoided.size() > 0) {
                    list.addAll(avoided);
                }
            }
            String[] sortedCipherSuites = options.sortCipherSuites(list.toArray(new String[0]));
            cipherSuites = new int[sortedCipherSuites.length];
            int index = 0;
            for (String sortedCipherSuite : sortedCipherSuites) {
                cipherSuites[index++] = BCSSLSocketStreamFactory.getCipherSuiteID(sortedCipherSuite);
            }
        }
        return cipherSuites;
    }

    private static int[] INIT_CIPHER_SUITES() {
        String[] cipherRules;
        LinkedHashMap<Integer, String> enabledCipherSuites = new LinkedHashMap<Integer, String>();
        for (String cipherRule : cipherRules = CIPHERS.split(":")) {
            block1: for (Map.Entry<Integer, String> cipherSuite : CIPHERSUITENAMES.entrySet()) {
                String[] rules;
                String cipherSuiteID = cipherSuite.getValue().replaceAll("(AES_(\\d+))", "AES$2").replaceAll("(RC4_(\\d+))", "RC4$2");
                if (cipherRule.startsWith("!")) {
                    Iterator it = enabledCipherSuites.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry next = it.next();
                        if (!((String)next.getValue()).contains("_" + cipherRule.substring(1))) continue;
                        it.remove();
                    }
                    continue;
                }
                if (cipherRule.contains("+")) {
                    for (String rule : rules = cipherRule.replace("EDH", "DHE").replace("AESGCM", "AES+GCM").replace("EECDH", "ECDHE").split("\\+")) {
                        if (!cipherSuiteID.contains("_" + rule)) continue block1;
                    }
                    enabledCipherSuites.put(cipherSuite.getKey(), cipherSuite.getValue());
                    continue;
                }
                for (String rule : rules = cipherRule.split("-")) {
                    if (!cipherSuiteID.contains("_" + rule)) continue block1;
                }
                enabledCipherSuites.put(cipherSuite.getKey(), cipherSuite.getValue());
            }
        }
        int[] ret = new int[enabledCipherSuites.size()];
        int index = 0;
        for (Integer enabledCipherSuite : enabledCipherSuites.keySet()) {
            ret[index++] = enabledCipherSuite;
        }
        return ret;
    }

    protected static String getCipherSuiteName(Integer selectedCipherSuite) {
        if (CIPHERSUITENAMES.containsKey(selectedCipherSuite)) {
            return CIPHERSUITENAMES.get(selectedCipherSuite);
        }
        return selectedCipherSuite.toString();
    }

    protected static int getCipherSuiteID(String cipherSuite) {
        for (Map.Entry<Integer, String> entry : CIPHERSUITENAMES.entrySet()) {
            if (!entry.getValue().equals(cipherSuite)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public SSLSocketStreamInterface create(final SocketStreamInterface socketStream, String hostName, int port, boolean autoclose, final SSLSocketStreamOptions options) throws IOException {
        boolean sniEnabled = !StringUtils.isEmpty((String)hostName) && (options == null || options.isSNIEnabled());
        final TlsClientProtocol protocol = new TlsClientProtocol(socketStream.getInputStream(), socketStream.getOutputStream());
        final BCTLSSocketStreamTlsClient client = new BCTLSSocketStreamTlsClient(hostName, sniEnabled, options);
        protocol.connect((TlsClient)client);
        Integer selectedCipherSuite = client.getSelectedCipherSuite();
        final String selectedCipherSuiteName = BCSSLSocketStreamFactory.getCipherSuiteName(selectedCipherSuite);
        return new BCSSLSocketStreamInterface(){
            final InputStream is = new InputStream(){
                final InputStream is;
                private boolean eof;
                {
                    this.is = protocol.getInputStream();
                    this.eof = false;
                }

                @Override
                public int read() throws IOException {
                    byte[] buf = new byte[1];
                    int ret = this.read(buf, 0, 1);
                    return ret <= 0 ? -1 : buf[0] & 0xFF;
                }

                @Override
                public int read(byte[] buf, int off, int len) throws IOException {
                    if (this.eof) {
                        return -1;
                    }
                    try {
                        return this.is.read(buf, off, len);
                    }
                    catch (TlsNoCloseNotifyException ignore) {
                        LogController.CL().log((Throwable)ignore);
                        this.eof = true;
                        return -1;
                    }
                }

                @Override
                public int available() throws IOException {
                    return this.is.available();
                }

                @Override
                public void close() throws IOException {
                    this.is.close();
                }
            };

            public Socket getSocket() {
                return this.getParentSocketStream().getSocket();
            }

            public SocketStreamInterface getParentSocketStream() {
                return socketStream;
            }

            public OutputStream getOutputStream() throws IOException {
                return protocol.getOutputStream();
            }

            public InputStream getInputStream() throws IOException {
                return this.is;
            }

            public void close() throws IOException {
                try {
                    protocol.close();
                }
                finally {
                    Socket socket = this.getSocket();
                    if (socket != null) {
                        socket.close();
                    }
                }
            }

            public String getCipherSuite() {
                return BCSSLSocketStreamFactory.this.getInfo() + "|" + this.getTlsClient().getCrypto() + "|Protocol:" + this.getTlsClient().getClientVersion() + "|CipherSuite:" + selectedCipherSuiteName;
            }

            public SSLSocketStreamOptions getOptions() {
                return options;
            }

            @Override
            public TlsClientProtocol getTlsClientProtocol() {
                return protocol;
            }

            @Override
            public BCTLSSocketStreamTlsClient getTlsClient() {
                return client;
            }

            public SSLSocketStreamFactory getSSLSocketStreamFactory() {
                return BCSSLSocketStreamFactory.this;
            }
        };
    }

    public String getInfo() {
        return BC.getInfo();
    }

    public String retry(SSLSocketStreamOptions options, Exception e) {
        String jsseRetry;
        String eMessage;
        String string = eMessage = e != null ? e.getMessage() : null;
        if (StringUtils.containsIgnoreCase((String)eMessage, (String)"protocol_version")) {
            if (options.getCustomFactorySettings().add(TLS13_ENABLED)) {
                return options.addRetryReason("(TLS)enable TLS1.3");
            }
            String bcRetry = options.enableNextDisabledCipher("GCM");
            if (bcRetry != null) {
                return options.addRetryReason("(TLS)enable " + bcRetry + " for TLS1.3");
            }
        }
        if (options.isHandshakeException(e)) {
            jsseRetry = options.enableNextDisabledCipher("GCM");
            if (jsseRetry != null) {
                return options.addRetryReason("(Handshake)enable " + jsseRetry + " for TLS1.2/TLS1.3");
            }
            if (options.getCustomFactorySettings().add(TLS10_11_DISABLED)) {
                return options.addRetryReason("(Handshake)disable TLS1.0/TLS1.1");
            }
            if (options.getCustomFactorySettings().add(TLS13_ENABLED)) {
                return options.addRetryReason("(Handshake)enable TLS1.3");
            }
        }
        if (options.isConnectionResetException(e)) {
            jsseRetry = options.enableNextDisabledCipher("GCM");
            if (jsseRetry != null) {
                return options.addRetryReason("(Reset)enable " + jsseRetry + " for TLS1.2/TLS1.3");
            }
            if (options.getCustomFactorySettings().add(TLS10_11_DISABLED)) {
                return options.addRetryReason("(Reset)disable TLS1.0/TLS1.1");
            }
            if (options.getCustomFactorySettings().add(TLS13_ENABLED)) {
                return options.addRetryReason("(Reset)enable TLS1.3");
            }
        }
        if (options.getCustomFactorySettings().add(TLS13_ENABLED)) {
            return options.addRetryReason("(Retry)Enable TLS1.3");
        }
        return null;
    }

    public SSLSocketFactory getSSLSocketFactory(SSLSocketStreamOptions options, String sniHostName) throws IOException {
        try {
            return new SSLSocketFactoryImpl();
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
    }

    static {
        try {
            Field[] fields;
            for (Field field : fields = CipherSuite.class.getFields()) {
                int cipherSuite = field.getInt(null);
                CIPHERSUITENAMES.put(cipherSuite, field.getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        CIPHERSUITES = BCSSLSocketStreamFactory.INIT_CIPHER_SUITES();
    }

    public static interface BCSSLSocketStreamInterface
    extends SSLSocketStreamInterface {
        public TlsClientProtocol getTlsClientProtocol();

        public BCTLSSocketStreamTlsClient getTlsClient();
    }

    private class BCTLSSocketStreamTlsClient
    extends DefaultTlsClient {
        private final String hostName;
        private final int[] enabledCipherSuites;
        private final boolean sniEnabled;
        private final SSLSocketStreamOptions options;
        protected int selectedCipherSuite;
        protected ProtocolVersion protocolVersion;

        private BCTLSSocketStreamTlsClient(String hostName, boolean sniEnabled, SSLSocketStreamOptions options) {
            super((TlsCrypto)new BcTlsCrypto(new SecureRandom()));
            this.selectedCipherSuite = -1;
            this.protocolVersion = null;
            this.hostName = hostName;
            this.enabledCipherSuites = BCSSLSocketStreamFactory.this.modifyCipherSuites(CIPHERSUITES, options);
            this.sniEnabled = sniEnabled;
            this.options = options;
        }

        public ProtocolVersion[] getProtocolVersions() {
            Boolean tls10_11Disabled;
            ProtocolVersion[] ret = super.getProtocolVersions();
            Boolean tls13Enabled = this.options != null ? Boolean.valueOf(this.options.getCustomFactorySettings().contains(BCSSLSocketStreamFactory.TLS13_ENABLED)) : null;
            ArrayList<ProtocolVersion> protocolVersions = new ArrayList<ProtocolVersion>(Arrays.asList(ret));
            if (Boolean.TRUE.equals(tls13Enabled) && !protocolVersions.contains(ProtocolVersion.TLSv13)) {
                protocolVersions.add(0, ProtocolVersion.TLSv13);
            } else if (Boolean.FALSE.equals(tls13Enabled)) {
                protocolVersions.remove(ProtocolVersion.TLSv13);
            }
            Boolean bl = tls10_11Disabled = this.options != null ? Boolean.valueOf(this.options.getCustomFactorySettings().contains(BCSSLSocketStreamFactory.TLS10_11_DISABLED)) : null;
            if (Boolean.TRUE.equals(tls10_11Disabled)) {
                protocolVersions.remove(ProtocolVersion.TLSv10);
                protocolVersions.remove(ProtocolVersion.TLSv11);
            }
            return protocolVersions.toArray(new ProtocolVersion[0]);
        }

        protected int[] getSupportedCipherSuites() {
            return TlsUtils.getSupportedCipherSuites((TlsCrypto)this.getCrypto(), (int[])this.enabledCipherSuites);
        }

        protected Vector<ServerName> getSNIServerNames() {
            if (this.sniEnabled && StringUtils.isNotEmpty((String)this.hostName) && !this.hostName.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$")) {
                ServerName serverName = new ServerName(0, Strings.toByteArray((String)IDNUtil.toASCII((String)this.hostName, (int)IDNUtil.USE_STD3_ASCII_RULES)));
                Vector<ServerName> sni = new Vector<ServerName>();
                sni.add(serverName);
                return sni;
            }
            return null;
        }

        public Hashtable getClientExtensions() throws IOException {
            Hashtable clientExtensions = super.getClientExtensions();
            if (clientExtensions != null) {
                if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE || !Arrays.asList(this.getProtocolVersions()).contains(ProtocolVersion.TLSv13)) {
                    clientExtensions.remove(TlsExtensionsUtils.EXT_encrypt_then_mac);
                }
                clientExtensions.remove(TlsExtensionsUtils.EXT_status_request);
                clientExtensions.remove(TlsExtensionsUtils.EXT_status_request_v2);
            }
            return clientExtensions;
        }

        public void notifySecureRenegotiation(boolean arg0) throws IOException {
        }

        public TlsAuthentication getAuthentication() throws IOException {
            TlsAuthentication auth = new TlsAuthentication(){

                public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                    return null;
                }

                public void notifyServerCertificate(TlsServerCertificate arg0) throws IOException {
                }
            };
            return auth;
        }

        private int getSelectedCipherSuite() {
            return this.selectedCipherSuite;
        }

        public void notifySelectedCipherSuite(int selectedCipherSuite) {
            this.selectedCipherSuite = selectedCipherSuite;
        }

        public void notifyServerVersion(ProtocolVersion protocolVersion) throws IOException {
            this.protocolVersion = protocolVersion;
        }

        public ProtocolVersion getClientVersion() {
            return this.protocolVersion;
        }
    }
}

