/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.osevents;

import java.util.concurrent.atomic.AtomicBoolean;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.Eventsender;
import org.jdownloader.osevents.OperatingSystemEvent;
import org.jdownloader.osevents.OperatingSystemListener;
import org.jdownloader.osevents.multios.SignalEventSource;
import org.jdownloader.updatev2.ForcedShutdown;

public class OperatingSystemEventSender
extends Eventsender<OperatingSystemListener, OperatingSystemEvent>
implements OperatingSystemListener {
    private static final OperatingSystemEventSender INSTANCE = new OperatingSystemEventSender();
    private final SignalEventSource signalEventSource;
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);

    public static OperatingSystemEventSender getInstance() {
        return INSTANCE;
    }

    private OperatingSystemEventSender() {
        SignalEventSource signalEventSource = null;
        try {
            signalEventSource = new SignalEventSource(){

                @Override
                public boolean onSignal(String name, int number) {
                    return OperatingSystemEventSender.this.onSignal(name, number);
                }
            };
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.signalEventSource = signalEventSource;
    }

    protected boolean onSignal(String name, int number) {
        if ("HUP".equals(name)) {
            this.fireEvent((DefaultEvent)new OperatingSystemEvent(OperatingSystemEvent.Type.SIGNAL_HUP, name, number));
            this.onOperatingSystemTerm();
        } else if ("TERM".equals(name) || "INT".equals(name)) {
            this.fireEvent((DefaultEvent)new OperatingSystemEvent(OperatingSystemEvent.Type.SIGNAL_TERM, name, number));
            this.onOperatingSystemTerm();
        } else {
            this.fireEvent((DefaultEvent)new OperatingSystemEvent(OperatingSystemEvent.Type.SIGNAL, name, number));
        }
        return true;
    }

    protected void fireEvent(OperatingSystemListener listener, OperatingSystemEvent event) {
        switch ((OperatingSystemEvent.Type)((Object)event.getType())) {
            case SIGNAL_HUP: 
            case SIGNAL_TERM: {
                System.out.println("Handled Event: " + (Object)((Object)event));
                listener.onOperatingSystemTerm();
                break;
            }
            default: {
                System.out.println("Unhandled Event: " + (Object)((Object)event));
            }
        }
    }

    public boolean isSignalSupported() {
        return this.signalEventSource != null;
    }

    public boolean setIgnoreSignal(String signal, boolean ignore) {
        return this.signalEventSource != null && this.signalEventSource.setIgnore(signal, ignore);
    }

    @Override
    public void onOperatingSystemTerm() {
        if (this.shutdownRequested.compareAndSet(false, true)) {
            ShutdownController.getInstance().requestShutdown((ShutdownRequest)new ForcedShutdown());
        }
    }
}

