/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.osevents.multios;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.logging.LogController;

public abstract class SignalEventSource {
    private final LogSource logger;
    private final HashMap<String, Object> oldHandlers = new HashMap();
    private final HashSet<String> ignoredSignals = new HashSet();
    private final Object signalHandler;

    public SignalEventSource() throws Exception {
        this.logger = LogController.getInstance().getLogger(SignalEventSource.class.getName());
        this.signalHandler = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Class.forName("sun.misc.SignalHandler")}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().endsWith("handle")) {
                    SignalEventSource.this.handle(args[0]);
                    return null;
                }
                return method.invoke((Object)this, args);
            }
        });
        this.init();
    }

    protected void init() throws Exception {
        boolean regFlag = this.reg("INT");
        regFlag |= this.reg("TERM");
        if (!CrossSystem.isWindows()) {
            regFlag |= this.reg("HUP");
        }
        if (!regFlag) {
            throw new Exception("could not register INT,TERM or HUP signal");
        }
    }

    protected LogInterface getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setIgnore(String signalName, boolean ignore) {
        try {
            boolean ret;
            Class<?> signalClass = Class.forName("sun.misc.Signal");
            String sigName = (String)ReflectionUtils.invoke(signalClass, (String)"getName", signalClass.getConstructor(String.class).newInstance(signalName), String.class, (Object[])new Object[0]);
            HashSet<String> hashSet = this.ignoredSignals;
            synchronized (hashSet) {
                ret = ignore ? this.ignoredSignals.add(sigName) : this.ignoredSignals.remove(sigName);
            }
            this.getLogger().info("ignore(" + ignore + " signal: " + signalName + "->" + sigName + "=" + ret);
            return ret;
        }
        catch (Throwable e) {
            this.getLogger().exception("failed to change signal ignore:" + signalName + "|" + ignore, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reg(String signalName) {
        try {
            Class<?> signalClass = Class.forName("sun.misc.Signal");
            Object signal = signalClass.getConstructor(String.class).newInstance(signalName);
            HashMap<String, Object> hashMap = this.oldHandlers;
            synchronized (hashMap) {
                this.oldHandlers.put(signalName, ReflectionUtils.invoke(signalClass, null, (String)"handle", signal, Void.TYPE, (Class[])new Class[]{signalClass, Class.forName("sun.misc.SignalHandler")}, (Object[])new Object[]{signal, this.signalHandler}));
            }
            this.getLogger().info("register signal: " + signalName + "->" + signal);
            return true;
        }
        catch (Throwable e) {
            this.getLogger().exception("failed to register signal" + signalName, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(Object signal) {
        block16: {
            try {
                Object oldHandler;
                HashMap<String, Object> hashMap;
                boolean ignored;
                String sigName = (String)ReflectionUtils.invoke(signal.getClass(), (String)"getName", (Object)signal, String.class, (Object[])new Object[0]);
                Number sigNumber = (Number)ReflectionUtils.invoke(signal.getClass(), (String)"getNumber", (Object)signal, Number.class, (Object[])new Object[0]);
                HashSet<String> hashSet = this.ignoredSignals;
                synchronized (hashSet) {
                    ignored = this.ignoredSignals.contains(sigName);
                }
                if (ignored) {
                    this.getLogger().info("Signal handler ignored for signal:" + sigName + "|" + sigNumber);
                    break block16;
                }
                this.getLogger().info("Signal handler called for signal:" + sigName + "|" + sigNumber);
                boolean invokeOldHandler = true;
                try {
                    invokeOldHandler = this.onSignal(sigName, sigNumber.intValue());
                    hashMap = this.oldHandlers;
                }
                catch (Throwable throwable) {
                    Object oldHandler2;
                    HashMap<String, Object> hashMap2 = this.oldHandlers;
                    synchronized (hashMap2) {
                        oldHandler2 = this.oldHandlers.get(sigName);
                    }
                    Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
                    Object SIG_DFL = ReflectionUtils.getFieldValue(signalHandlerClass, (String)"SIG_DFL", null, signalHandlerClass);
                    Object SIG_IGN = ReflectionUtils.getFieldValue(signalHandlerClass, (String)"SIG_IGN", null, signalHandlerClass);
                    if (invokeOldHandler && oldHandler2 != null && oldHandler2 != SIG_DFL && oldHandler2 != SIG_IGN) {
                        ReflectionUtils.invoke(signalHandlerClass, (String)"handle", (Object)oldHandler2, Void.TYPE, (Object[])new Object[]{signal});
                    }
                    throw throwable;
                }
                synchronized (hashMap) {
                    oldHandler = this.oldHandlers.get(sigName);
                }
                Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
                Object SIG_DFL = ReflectionUtils.getFieldValue(signalHandlerClass, (String)"SIG_DFL", null, signalHandlerClass);
                Object SIG_IGN = ReflectionUtils.getFieldValue(signalHandlerClass, (String)"SIG_IGN", null, signalHandlerClass);
                if (invokeOldHandler && oldHandler != null && oldHandler != SIG_DFL && oldHandler != SIG_IGN) {
                    ReflectionUtils.invoke(signalHandlerClass, (String)"handle", (Object)oldHandler, Void.TYPE, (Object[])new Object[]{signal});
                }
            }
            catch (Exception e) {
                this.getLogger().exception("failed to handle signal:" + signal, (Throwable)e);
            }
        }
    }

    public abstract boolean onSignal(String var1, int var2);
}

