/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.par2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.appwork.utils.formatter.HexFormatter;
import org.jdownloader.par2.Packet;
import org.jdownloader.par2.RawPacket;

public class FileDescriptionPacket
extends Packet {
    public static final byte[] MAGIC = new byte[]{80, 65, 82, 32, 50, 46, 48, 0, 70, 105, 108, 101, 68, 101, 115, 99};
    protected final RawPacket rawPacket;
    protected static final Charset ASCII = Charset.forName("ASCII");

    public ByteBuffer getFileID() {
        return ByteBuffer.wrap(this.getRawPacket().getBody(), 0, 16);
    }

    public ByteBuffer getMD5() {
        return ByteBuffer.wrap(this.getRawPacket().getBody(), 16, 16);
    }

    public ByteBuffer get16kMD5() {
        return ByteBuffer.wrap(this.getRawPacket().getBody(), 32, 16);
    }

    public long getLength() {
        return ByteBuffer.wrap(this.getRawPacket().getBody(), 48, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public String toString() {
        return "FileDescriptionPacket|Name:" + this.getName() + "|Length:" + this.getLength() + "|MD5:" + HexFormatter.byteBufferToHex((ByteBuffer)this.getMD5()) + "|FileID:" + HexFormatter.byteBufferToHex((ByteBuffer)this.getFileID());
    }

    public ByteBuffer getNameAsByteBuffer(boolean ignoreNullTermination) {
        return this.getByteBuffer(56, this.rawPacket.getBody().length - 56, ignoreNullTermination);
    }

    public String getName() {
        return ASCII.decode(this.getNameAsByteBuffer(false)).toString();
    }

    public FileDescriptionPacket(RawPacket rawPacket) {
        this.rawPacket = rawPacket;
    }

    @Override
    public byte[] getType() {
        return MAGIC;
    }

    @Override
    public RawPacket getRawPacket() {
        return this.rawPacket;
    }
}

