/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.par2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Enumeration;
import org.jdownloader.par2.Packet;
import org.jdownloader.par2.RawPacket;

public class MainPacket
extends Packet {
    public static final byte[] MAGIC = new byte[]{80, 65, 82, 32, 50, 46, 48, 0, 77, 97, 105, 110, 0, 0, 0, 0};
    protected final RawPacket rawPacket;

    public MainPacket(RawPacket rawPacket) {
        this.rawPacket = rawPacket;
    }

    public int getNumberOfRecoveryFiles() {
        return ByteBuffer.wrap(this.getRawPacket().getBody(), 8, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public int getNumberOfNonRecoveryFiles() {
        return (this.getRawPacket().getBody().length - 12 - 16 * this.getNumberOfRecoveryFiles()) / 16;
    }

    public long getSliceSize() {
        return ByteBuffer.wrap(this.getRawPacket().getBody(), 0, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public Enumeration<ByteBuffer> getRecoveryFileIDs() {
        return new Enumeration<ByteBuffer>(){
            private int index = 0;
            private final int max = MainPacket.this.getNumberOfRecoveryFiles();

            @Override
            public boolean hasMoreElements() {
                return this.index < this.max;
            }

            @Override
            public ByteBuffer nextElement() {
                if (this.hasMoreElements()) {
                    return ByteBuffer.wrap(MainPacket.this.getRawPacket().getBody(), 12 + this.index++ * 16, 16);
                }
                return null;
            }
        };
    }

    @Override
    public byte[] getType() {
        return MAGIC;
    }

    public String toString() {
        return "MainPacket|SliceSize:" + this.getSliceSize() + "|NumberOfRecoveryFiles:" + this.getNumberOfRecoveryFiles() + "|NumberOfNonRecoveryFiles:" + this.getNumberOfNonRecoveryFiles();
    }

    @Override
    public RawPacket getRawPacket() {
        return this.rawPacket;
    }
}

