/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.par2;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.appwork.utils.formatter.HexFormatter;

public class RawPacket {
    public static final byte[] MAGIC = new byte[]{80, 65, 82, 50, 0, 80, 75, 84};
    protected final byte[] recoverySetId;
    protected final byte[] type;
    protected final byte[] md5;
    protected final byte[] body;

    public byte[] getRecoverySetId() {
        return this.recoverySetId;
    }

    public byte[] getType() {
        return this.type;
    }

    public byte[] getBody() {
        return this.body;
    }

    public boolean verifyMD5() throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(this.getRecoverySetId());
        md5.update(this.getType());
        md5.update(this.getBody());
        byte[] verify = md5.digest();
        return Arrays.equals(this.getMD5(), verify);
    }

    public byte[] getMD5() {
        return this.md5;
    }

    protected RawPacket(byte[] type, byte[] md5, byte[] recoverySetId, byte[] body) {
        this.type = type;
        this.md5 = md5;
        this.recoverySetId = recoverySetId;
        this.body = body;
    }

    public static RawPacket readNext(InputStream is) throws IOException, NoSuchAlgorithmException {
        DataInputStream dis = new DataInputStream(is);
        int read = dis.read();
        if (read == -1) {
            return null;
        }
        byte[] magic = new byte[8];
        magic[0] = (byte)(read & 0xFF);
        dis.readFully(magic, 1, 7);
        if (!Arrays.equals(MAGIC, magic)) {
            throw new IOException("Magic error!(" + HexFormatter.byteArrayToHex((byte[])magic) + ")");
        }
        byte[] length_Bytes = new byte[8];
        dis.readFully(length_Bytes);
        long length = ByteBuffer.wrap(length_Bytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
        if (length % 4L != 0L) {
            throw new IOException("Length must be multiple of 4!(" + length + ")");
        }
        byte[] md5 = new byte[16];
        dis.readFully(md5);
        byte[] recoverySetId = new byte[16];
        dis.readFully(recoverySetId);
        byte[] type = new byte[16];
        dis.readFully(type);
        long bodyLength = length - 64L;
        if (bodyLength > Integer.MAX_VALUE) {
            throw new IOException();
        }
        byte[] body = new byte[(int)bodyLength];
        dis.readFully(body);
        return new RawPacket(type, md5, recoverySetId, body);
    }
}

