/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.par2;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jdownloader.par2.Packet;
import org.jdownloader.par2.RawPacket;

public class UnicodeCommentPacket
extends Packet {
    public static final byte[] MAGIC = new byte[]{80, 65, 82, 32, 50, 46, 48, 0, 67, 111, 109, 109, 85, 110, 105, 0};
    protected final RawPacket rawPacket;
    protected static final Charset UTF16 = Charset.forName("UTF-16");

    public UnicodeCommentPacket(RawPacket rawPacket) {
        this.rawPacket = rawPacket;
    }

    public String toString() {
        return "UnicodeCommentPacket|Comment:" + this.getComment();
    }

    public ByteBuffer getAsciiCommentMD5() {
        return ByteBuffer.wrap(this.getRawPacket().getBody(), 0, 16);
    }

    public ByteBuffer getCommentAsByteBuffer(boolean ignoreNullTermination) {
        return this.getByteBuffer(16, this.rawPacket.getBody().length - 16, ignoreNullTermination);
    }

    public String getComment() {
        return UTF16.decode(this.getCommentAsByteBuffer(false)).toString();
    }

    @Override
    public byte[] getType() {
        return MAGIC;
    }

    @Override
    public RawPacket getRawPacket() {
        return this.rawPacket;
    }
}

