/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import java.awt.Color;
import javax.swing.Icon;
import jd.controlling.downloadcontroller.AccountCache;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.nutils.Formatter;
import jd.plugins.FavitIcon;
import jd.plugins.FilePackageView;
import jd.plugins.PluginProgress;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.Downloadable;
import org.jdownloader.DomainInfo;
import org.jdownloader.api.downloads.ChannelCollector;
import org.jdownloader.api.downloads.DownloadControllerEventPublisher;
import org.jdownloader.api.downloads.v2.DownloadsAPIV2Impl;
import org.jdownloader.api.jdanywhere.api.Helper;
import org.jdownloader.gui.views.downloads.columns.TaskColumn;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.PluginTaskID;
import org.jdownloader.plugins.tasks.PluginProgressTask;
import org.jdownloader.translate._JDT;

public class DownloadPluginProgress
extends PluginProgress {
    private final DownloadInterface downloadInterface;
    private final String unknownFileSize = _JDT.T.gui_download_filesize_unknown() + " \u221e";
    protected final long startTimeStamp;
    private final String normal;
    private final Downloadable downloadable;
    protected FavitIcon downloadMultihosterIcon = null;

    public DownloadPluginProgress(Downloadable downloadable, DownloadInterface downloadInterface, Color color) {
        super(0L, 0L, color);
        this.setProgressSource(downloadInterface);
        this.downloadable = downloadable;
        this.downloadInterface = downloadInterface;
        this.setIcon(new AbstractIcon("download", 16));
        this.startTimeStamp = downloadInterface.getStartTimeStamp();
        this.normal = _JDT.T.download_connection_normal();
    }

    @Override
    public Icon getIcon(Object requestor) {
        DomainInfo pluginDomain;
        SingleDownloadController controller;
        if (requestor instanceof DownloadsAPIV2Impl && this.downloadable instanceof DownloadLinkDownloadable && (controller = ((DownloadLinkDownloadable)this.downloadable).getDownloadLinkController()) != null && AccountCache.ACCOUNTTYPE.MULTI.equals((Object)controller.getDownloadLinkCandidate().getCachedAccount().getType()) && (pluginDomain = controller.getDownloadLinkCandidate().getCachedAccount().getPluginDomainInfo()) != null) {
            return new FavitIcon(new AbstractIcon("download", 16), pluginDomain);
        }
        return super.getIcon(requestor);
    }

    @Override
    public long getCurrent() {
        return this.downloadInterface.getTotalLinkBytesLoadedLive();
    }

    @Override
    public long getTotal() {
        return this.downloadable.getKnownDownloadSize();
    }

    @Override
    public long getETA() {
        long remainingBytes;
        long speed = this.getSpeed();
        if (speed > 0L && (remainingBytes = this.getTotal() - this.getCurrent()) > 0L) {
            long eta = remainingBytes / speed;
            return eta;
        }
        return -1L;
    }

    @Override
    public String getMessage(Object requestor) {
        if (requestor instanceof TaskColumn || requestor == Helper.REQUESTOR || requestor instanceof FilePackageView || requestor instanceof PluginProgressTask || requestor instanceof DownloadsAPIV2Impl || requestor instanceof DownloadControllerEventPublisher || requestor instanceof ChannelCollector) {
            return this.normal;
        }
        long total = this.getTotal();
        if (total < 0L) {
            return this.unknownFileSize;
        }
        long eta = this.getETA();
        if (eta > 0L) {
            return Formatter.formatSeconds((long)eta);
        }
        return null;
    }

    public long getDuration() {
        return System.currentTimeMillis() - this.startTimeStamp;
    }

    public long getSpeed() {
        return this.downloadInterface.getManagedConnetionHandler().getSpeed();
    }

    @Override
    public PluginTaskID getID() {
        return PluginTaskID.DOWNLOAD;
    }
}

