/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import java.awt.Color;
import java.io.File;
import jd.plugins.PluginProgress;
import jd.plugins.download.HashInfo;
import org.appwork.utils.formatter.TimeFormatter;
import org.jdownloader.gui.views.downloads.columns.ETAColumn;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.PluginTaskID;
import org.jdownloader.translate._JDT;

public class HashCheckPluginProgress
extends PluginProgress {
    private final String message;
    private long lastCurrent = -1L;
    private long startTimeStamp = -1L;
    private final HashInfo.TYPE type;

    public HashCheckPluginProgress(File file, Color color, HashInfo.TYPE type) {
        super(0L, file != null ? file.length() : 1L, color);
        this.setIcon(new AbstractIcon("hashsum", 16));
        this.type = type;
        this.message = type != null ? _JDT.T.system_download_doCRC2(type.name()) : _JDT.T.system_download_doCRC2_waiting();
    }

    @Override
    public PluginTaskID getID() {
        return PluginTaskID.HASH;
    }

    @Override
    public String getMessage(Object requestor) {
        if (requestor instanceof ETAColumn) {
            long eta;
            if (this.type != null && (eta = this.getETA()) >= 0L) {
                return TimeFormatter.formatMilliSeconds((long)eta, (int)0);
            }
            return "";
        }
        return this.message;
    }

    @Override
    public void setCurrent(long current) {
        super.setCurrent(current);
        if (this.lastCurrent == -1L || this.lastCurrent > current) {
            this.lastCurrent = current;
            this.startTimeStamp = System.currentTimeMillis();
            this.setETA(-1L);
            return;
        }
        long currentTimeDifference = System.currentTimeMillis() - this.startTimeStamp;
        if (currentTimeDifference <= 0L) {
            return;
        }
        long speed = current * 10000L / currentTimeDifference;
        if (speed == 0L) {
            return;
        }
        long eta = (this.total - current) * 10000L / speed;
        this.setETA(eta);
    }
}

