/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import jd.nutils.Formatter;
import jd.plugins.PluginProgress;
import org.appwork.utils.StringUtils;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.PluginTaskID;
import org.jdownloader.translate._JDT;

public class SleepPluginProgress
extends PluginProgress {
    private final String message;
    private volatile String pluginMessage = null;

    public SleepPluginProgress(long total, String message) {
        super(0L, total, null);
        this.setIcon(new AbstractIcon("wait", 16));
        this.message = StringUtils.isEmpty((String)message) ? null : message;
    }

    @Override
    public PluginTaskID getID() {
        return PluginTaskID.WAIT;
    }

    @Override
    public String getMessage(Object requestor) {
        if (this.message != null) {
            return this.message;
        }
        return this.pluginMessage;
    }

    @Override
    public void setCurrent(long current) {
        this.pluginMessage = current > 0L ? _JDT.T.gui_download_waittime_status2(Formatter.formatSeconds((long)(current / 1000L))) : null;
        super.setCurrent(current);
    }
}

