/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import javax.swing.Icon;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.Account;
import jd.plugins.AccountTrafficView;
import jd.plugins.DownloadLink;
import org.appwork.storage.config.JsonConfig;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.CustomConditionalSkipReasonMessageIcon;
import org.jdownloader.plugins.IgnorableConditionalSkipReason;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.translate._JDT;

public class WaitForAccountTrafficSkipReason
implements ConditionalSkipReason,
IgnorableConditionalSkipReason {
    private static final GraphicalUserInterfaceSettings.SIZEUNIT MAXSIZEUNIT = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMaxSizeUnit();
    private final Account account;
    private final Icon icon;
    private final long trafficRequired;

    public Icon getIcon() {
        return this.icon;
    }

    public long getTrafficRequired() {
        return this.trafficRequired;
    }

    public WaitForAccountTrafficSkipReason(Account account, long trafficRequired) {
        this.account = account;
        this.icon = new AbstractIcon("wait", 16);
        this.trafficRequired = trafficRequired;
    }

    public Account getAccount() {
        return this.account;
    }

    @Override
    public boolean canIgnore() {
        return true;
    }

    private final boolean hasEnoughTraffic() {
        AccountTrafficView accountTrafficView = this.getAccount().getAccountTrafficView();
        if (accountTrafficView == null) {
            return true;
        }
        if (accountTrafficView.isSpecialTraffic() || accountTrafficView.isUnlimitedTraffic() || !accountTrafficView.isTrafficRefill()) {
            return true;
        }
        long trafficLeft = accountTrafficView.getTrafficLeft();
        return trafficLeft > 0L && trafficLeft >= this.getTrafficRequired();
    }

    public String toString() {
        return "WaitForAccountTrafficSkipReason(Account:" + this.getAccount() + "|" + this.getMessage(this, null) + ")";
    }

    @Override
    public boolean isConditionReached() {
        return !this.getAccount().isEnabled() || !this.getAccount().isValid() || this.getAccount().getAccountController() == null || this.hasEnoughTraffic();
    }

    @Override
    public String getMessage(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getMessage(this, node);
        }
        long trafficRequired = this.getTrafficRequired();
        if (trafficRequired < 0L) {
            return _JDT.T.gui_download_waittime_notenoughtraffic2();
        }
        return _JDT.T.gui_download_waittime_notenoughtraffic(GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(MAXSIZEUNIT, trafficRequired));
    }

    @Override
    public Icon getIcon(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getIcon(this, node);
        }
        return this.getIcon();
    }

    @Override
    public void finalize(DownloadLink link) {
    }
}

