/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins;

import javax.swing.Icon;
import jd.controlling.packagecontroller.AbstractNode;
import jd.nutils.Formatter;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.DownloadLink;
import jd.plugins.MultiHostHost;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.CustomConditionalSkipReasonMessageIcon;
import org.jdownloader.plugins.IgnorableConditionalSkipReason;
import org.jdownloader.plugins.TimeOutCondition;
import org.jdownloader.translate._JDT;

public class WaitingSkipReasonMultihostHostUnavailable
implements ConditionalSkipReason,
IgnorableConditionalSkipReason,
TimeOutCondition {
    private final Account account;
    private final String host;
    private final String unavailableReason;
    private final long unavailableTimestamp;
    private final Icon icon;

    public Icon getIcon() {
        return this.icon;
    }

    public WaitingSkipReasonMultihostHostUnavailable(Account account, String host, String unavailableReason, long unavailableTimestamp) {
        this.account = account;
        this.host = host;
        this.unavailableReason = unavailableReason;
        this.unavailableTimestamp = unavailableTimestamp;
        this.icon = new AbstractIcon("wait", 16);
    }

    public Account getAccount() {
        return this.account;
    }

    @Override
    public boolean canIgnore() {
        return false;
    }

    private final boolean isTimeoutGone() {
        AccountInfo ai = this.getAccount().getAccountInfo();
        if (ai == null) {
            return true;
        }
        MultiHostHost mhost = ai.getMultihostSupportedHost(this.host);
        if (mhost == null) {
            return true;
        }
        long unavailableTimestamp = mhost.getUnavailableUntilTimestamp();
        return unavailableTimestamp != this.unavailableTimestamp || !StringUtils.equals((String)mhost.getUnavailableStatusText(), (String)this.unavailableReason);
    }

    public String toString() {
        return "WaitForAccountMultiHostHostTrafficSkipReason(Account:" + this.getAccount() + "|" + this.getMessage(this, null) + ")";
    }

    @Override
    public boolean isConditionReached() {
        return !this.getAccount().isEnabled() || !this.getAccount().isValid() || this.getAccount().getAccountController() == null || this.getTimeOutLeft() == 0L || this.isTimeoutGone();
    }

    @Override
    public String getMessage(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getMessage(this, node);
        }
        return _JDT.T.gui_download_waittime_notenoughtraffic_multihost_host_temporarily_unavailable(this.getAccount().getHoster(), Formatter.formatSeconds((long)(this.getTimeOutLeft() / 1000L)), this.unavailableReason);
    }

    @Override
    public Icon getIcon(Object requestor, AbstractNode node) {
        if (requestor instanceof CustomConditionalSkipReasonMessageIcon) {
            return ((CustomConditionalSkipReasonMessageIcon)requestor).getIcon(this, node);
        }
        return this.getIcon();
    }

    @Override
    public void finalize(DownloadLink link) {
    }

    @Override
    public long getTimeOutTimeStamp() {
        return this.unavailableTimestamp;
    }

    @Override
    public long getTimeOutLeft() {
        return Math.max(0L, this.getTimeOutTimeStamp() - Time.systemIndependentCurrentJVMTimeMillis());
    }
}

