/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import jd.PluginWrapper;
import jd.controlling.AccountController;
import jd.http.Browser;
import jd.http.Cookies;
import jd.http.URLConnectionAdapter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountInvalidException;
import jd.plugins.AccountRequiredException;
import jd.plugins.BrowserAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.components.SiteType;
import org.appwork.utils.DebugMode;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.formatter.TimeFormatter;
import org.jdownloader.plugins.components.antiDDoSForHost;

@HostPlugin(revision="$Revision: 49212 $", interfaceVersion=2, names={}, urls={})
public abstract class FlexShareCore
extends antiDDoSForHost {
    public FlexShareCore(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Override
    public Browser createNewBrowserInstance() {
        Browser br = super.createNewBrowserInstance();
        br.setFollowRedirects(true);
        return br;
    }

    @Override
    public String getAGBLink() {
        return "https://" + this.getHost() + "/help/terms.php";
    }

    @Override
    public String getLinkID(DownloadLink link) {
        String fid = this.getFID(link);
        if (fid != null) {
            return this.getHost() + "://" + fid;
        }
        return super.getLinkID(link);
    }

    private String getFID(DownloadLink link) {
        return new Regex((Object)link.getPluginPatternMatcher(), this.getSupportedLinks()).getMatch(0);
    }

    public static final String getDefaultAnnotationPatternPart() {
        return "/(?:files|get)/([A-Za-z0-9]+)(/([^/]+)\\.html)?";
    }

    public static String[] buildAnnotationUrls(List<String[]> pluginDomains) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String[] domains : pluginDomains) {
            ret.add("https?://(?:[A-Za-z0-9]+\\.)?" + FlexShareCore.buildHostsPatternPart(domains) + FlexShareCore.getDefaultAnnotationPatternPart());
        }
        return ret.toArray(new String[0]);
    }

    private String getContentURL(DownloadLink link) {
        return link.getPluginPatternMatcher().replace("http://", "https://").replaceFirst("/get/", "/files/");
    }

    protected String getAPIKey() {
        return null;
    }

    @Override
    public boolean isResumeable(DownloadLink link, Account account) {
        Account.AccountType type;
        Account.AccountType accountType = type = account != null ? account.getType() : null;
        if (Account.AccountType.FREE.equals((Object)type)) {
            return true;
        }
        if (Account.AccountType.PREMIUM.equals((Object)type) || Account.AccountType.LIFETIME.equals((Object)type)) {
            return true;
        }
        return true;
    }

    public int getMaxChunks(Account account) {
        Account.AccountType type;
        Account.AccountType accountType = type = account != null ? account.getType() : null;
        if (Account.AccountType.FREE.equals((Object)type)) {
            return 1;
        }
        if (Account.AccountType.PREMIUM.equals((Object)type) || Account.AccountType.LIFETIME.equals((Object)type)) {
            return 1;
        }
        return 1;
    }

    @Override
    public int getMaxSimultanFreeDownloadNum() {
        return 1;
    }

    @Override
    public int getMaxSimultanPremiumDownloadNum() {
        return -1;
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink link) throws Exception {
        Account acc = AccountController.getInstance().getValidAccount(this.getHost());
        return this.requestFileInformation(link, acc);
    }

    private DownloadLink.AvailableStatus requestFileInformation(DownloadLink link, Account account) throws Exception {
        if (!link.isNameSet()) {
            String filenameFromURL = new Regex((Object)link.getPluginPatternMatcher(), this.getSupportedLinks()).getMatch(2);
            if (filenameFromURL != null) {
                link.setName(filenameFromURL);
            } else {
                link.setName(this.getFID(link));
            }
        }
        this.setBrowserExclusive();
        if (this.getAPIKey() != null) {
            return this.requestFileInformationAPI(link);
        }
        return this.requestFileInformationWebsite(link, account);
    }

    public DownloadLink.AvailableStatus requestFileInformationAPI(DownloadLink link) throws Exception {
        this.setBrowserExclusive();
        this.getPage(this.getMainPage() + "/api/info.php?api_key=" + this.getAPIKey() + "&file_id=" + this.getFID(link));
        if (this.br.getHttpConnection().getResponseCode() == 404 || this.br.containsHTML("(?i)file does not exist")) {
            throw new PluginException(32);
        }
        String filename = this.br.getRegex("\\[file_name\\] => (.*?)\n").getMatch(0);
        String filesize = this.br.getRegex("\\[file_size\\] => (\\d+)\n").getMatch(0);
        if (filename == null || filesize == null) {
            throw new PluginException(0x400000);
        }
        link.setFinalFileName(Encoding.htmlDecode((String)filename).trim());
        link.setDownloadSize(SizeFormatter.getSize((String)filesize));
        return DownloadLink.AvailableStatus.TRUE;
    }

    public DownloadLink.AvailableStatus requestFileInformationWebsite(DownloadLink link, Account account) throws Exception {
        URLConnectionAdapter con;
        this.setBrowserExclusive();
        if (account != null) {
            this.login(account, null, false);
        }
        if (this.looksLikeDownloadableContent(con = this.br.openGetConnection(this.getContentURL(link)))) {
            link.setFinalFileName(Plugin.getFileNameFromConnection(con));
            if (con.getCompleteContentLength() > 0L) {
                if (con.isContentDecoded()) {
                    link.setDownloadSize(con.getCompleteContentLength());
                } else {
                    link.setVerifiedFileSize(con.getCompleteContentLength());
                }
            }
        } else {
            this.br.followConnection();
            if (this.br.getHttpConnection().getResponseCode() == 404 || this.br.containsHTML("(?i)>\\s*The file you have requested does not exist")) {
                throw new PluginException(32);
            }
            String filename = this.br.getRegex("(?i)<title>\\s*([^<]+)\\s*\\|\\s*ExtMatrix\\s*-\\s*The Premium Cloud Storage\\s*</title>").getMatch(0);
            Regex fileInfo = this.br.getRegex("style=\"text-align:(center|left|right);\">\\s*(Premium Only\\!)?([^\"<>]+) \\(([0-9\\.]+ [A-Za-z]+)(\\))?(,[^<>\"/]+)?</h1>");
            if (filename == null) {
                filename = fileInfo.getMatch(2);
            }
            String filesize = fileInfo.getMatch(3);
            if (filename != null) {
                filename = Encoding.htmlDecode((String)filename).trim();
                filename = filename.replaceFirst("^(?i)Download \\|\\s*", "");
                link.setFinalFileName(filename);
            }
            if (filesize != null) {
                link.setDownloadSize(SizeFormatter.getSize((String)filesize));
            }
        }
        return DownloadLink.AvailableStatus.TRUE;
    }

    @Override
    public void handleFree(DownloadLink link) throws Exception {
        this.handleDownload(link, null);
    }

    protected void handleDownload(DownloadLink link, Account account) throws Exception, PluginException {
        this.requestFileInformationWebsite(link, account);
        this.dl = BrowserAdapter.openDownload(this.br, link, this.getContentURL(link), this.isResumeable(link, account), this.getMaxChunks(account));
        if (!this.looksLikeDownloadableContent(this.dl.getConnection())) {
            this.br.followConnection(true);
            boolean isSpecialJDLink = false;
            String getLink = this.br.getRegex("<a\\s*id\\s*=\\s*'jd_support'\\s*href\\s*=\\s*\"(https?://[^<>\"\\']*?)\"").getMatch(0);
            if (getLink != null) {
                isSpecialJDLink = true;
            } else {
                getLink = this.findFreeGetLink(this.br);
            }
            Form dlform = this.br.getFormbyProperty("name", "pipi");
            if (dlform == null) {
                dlform = this.br.getFormByInputFieldKeyValue("task", "download");
            }
            if (dlform == null && getLink == null) {
                this.handleErrors(link, account);
                this.handleGeneralServerErrors(this.br.getHttpConnection());
                throw new PluginException(0x400000);
            }
            String waitStr = this.br.getRegex("var time\\s*=\\s*(\\d+);").getMatch(0);
            if (waitStr != null) {
                int wait = Integer.parseInt(waitStr);
                if (wait > 240) {
                    throw new PluginException(16, 3600000L);
                }
                boolean bl = true;
            }
            this.dl = dlform != null ? BrowserAdapter.openDownload(this.br, link, dlform, this.isResumeable(link, account), this.getMaxChunks(account)) : (isSpecialJDLink ? BrowserAdapter.openDownload(this.br, link, getLink, this.isResumeable(link, account), this.getMaxChunks(account)) : BrowserAdapter.openDownload(this.br, link, getLink, "task=download", this.isResumeable(link, account), this.getMaxChunks(account)));
            if (!this.looksLikeDownloadableContent(this.dl.getConnection())) {
                this.logger.warning("The final dllink seems not to be a file!");
                this.br.followConnection(true);
                this.handleErrors(link, account);
                this.handleGeneralServerErrors(this.dl.getConnection());
                throw new PluginException(0x400000);
            }
        }
        this.dl.startDownload();
    }

    protected void handleGeneralServerErrors(URLConnectionAdapter con) throws PluginException {
        if (con.getResponseCode() == 403) {
            throw new PluginException(2048, "Server error 403", 300000L);
        }
        if (con.getResponseCode() == 404) {
            throw new PluginException(2048, "Server error 404", 300000L);
        }
        if (con.getResponseCode() == 503) {
            throw new PluginException(2048, "Server error 503", 300000L);
        }
    }

    protected void handleErrors(DownloadLink link, Account account) throws PluginException {
        if (this.br.containsHTML("(?i)(>\\s*Premium Only\\s*\\!|you have requested require a premium account for download\\.\\s*<|you have requested require a premium account for download|>\\s*Only premium accounts are able to download this file)")) {
            throw new AccountRequiredException();
        }
        if (this.br.containsHTML("(?i)<title>\\s*Site Maintenance\\s*</title>")) {
            if (this.dl != null) {
                throw new PluginException(2048, "Server Maintenance", 1800000L);
            }
            throw new PluginException(4096, "Server Maintenance", 1800000L);
        }
        if (this.br.containsHTML("Server is too busy for free users")) {
            throw new PluginException(4096, "No free slots", 600000L);
        }
        if (this.br.containsHTML("(files per hour for free users\\.</div>|>Los usuarios de Cuenta Gratis pueden descargar|hours for free users\\.|var time =)")) {
            throw new PluginException(16, 3603600L);
        }
        if (this.br.containsHTML("(api\\.recaptcha\\.net|google\\.com/recaptcha/api/|\"g-recaptcha\")")) {
            throw new PluginException(8);
        }
        if (this.br.getURL().contains("error_503.html")) {
            throw new PluginException(4096, "Error 503 too many connections", 60000L);
        }
        String unknownError = this.br.getRegex("class\\s*=\\s*\"error\"\\s*>\\s*(.*?)\"").getMatch(0);
        if (unknownError != null) {
            this.logger.warning("Unknown error occured: " + unknownError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void login(Account account, AccountInfo ai, boolean validateCookies) throws Exception {
        Account account2 = account;
        synchronized (account2) {
            try {
                this.br.setCookiesExclusive(false);
                Cookies cookies = account.loadCookies("");
                boolean loggedIN = false;
                if (cookies != null) {
                    this.br.setCookies(this.getHost(), cookies);
                    if (!validateCookies) {
                        return;
                    }
                    this.getPage(this.getMainPage() + "/members/myfiles.php");
                    if (this.isLoggedIN(this.br)) {
                        this.updateAccountType(this.br, account, ai);
                        this.logger.info("Successfully loggedin via cookies");
                        loggedIN = true;
                    } else {
                        this.logger.info("Cookie login failed");
                    }
                }
                if (!loggedIN) {
                    this.br.clearCookies(null);
                    this.logger.info("Performing full login");
                    this.getPage(this.getLoginURL());
                    Form loginform = this.getAndFillLoginForm(account);
                    if (loginform == null) {
                        throw new PluginException(0x400000);
                    }
                    String captchaURL = new Regex(loginform.getHtmlCode(), "(/captcha\\.php[^\"\\']+)").getMatch(0);
                    if (captchaURL != null) {
                        DownloadLink captchaLink;
                        DownloadLink dlinkbefore = this.getDownloadLink();
                        if (dlinkbefore != null) {
                            captchaLink = dlinkbefore;
                        } else {
                            captchaLink = new DownloadLink(this, "Account", this.getHost(), "https://" + account.getHoster(), true);
                            this.setDownloadLink(captchaLink);
                        }
                        try {
                            String code = this.getCaptchaCode(captchaURL, captchaLink);
                            loginform.put("captcha", Encoding.urlEncode((String)code));
                        }
                        finally {
                            if (dlinkbefore != null) {
                                this.setDownloadLink(dlinkbefore);
                            }
                        }
                    }
                    this.submitForm(loginform);
                    if (this.br.getHttpConnection().getResponseCode() == 404) {
                        this.getPage("/members/myfiles.php");
                    }
                    if (!this.isLoggedIN(this.br)) {
                        throw new AccountInvalidException();
                    }
                    this.updateAccountType(this.br, account, ai);
                    this.logger.info("Successfully loggedin:" + (Object)((Object)account.getType()));
                }
                account.saveCookies(this.br.getCookies(this.br.getHost()), "");
            }
            catch (PluginException e) {
                if (e.getLinkStatus() == 256) {
                    account.clearCookies("");
                }
                throw e;
            }
        }
    }

    protected String getLoginURL() {
        return this.getMainPage() + "/login.php";
    }

    protected Form getAndFillLoginForm(Account account) {
        Form loginform = this.br.getFormbyActionRegex(".*login\\.php");
        if (loginform == null) {
            loginform = this.br.getFormByInputFieldKeyValue("task", "dologin");
        }
        if (loginform == null) {
            loginform = this.br.getFormbyKey("user");
        }
        if (loginform == null) {
            return null;
        }
        loginform.put("user", Encoding.urlEncode((String)account.getUser()));
        loginform.put("pass", Encoding.urlEncode((String)account.getPass()));
        return loginform;
    }

    protected boolean isLoggedIN(Browser br) {
        return br.getCookie(br.getHost(), "auth", Cookies.NOTDELETEDPATTERN) != null && br.containsHTML("(?i)/logout\\.php");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAccountType(Browser br, Account account, AccountInfo ai) throws Exception {
        if (br.getURL() == null || !br._getURL().getPath().matches("^/?$")) {
            this.getPage(this.getMainPage());
        }
        Account account2 = account;
        synchronized (account2) {
            if (ai == null && (ai = account.getAccountInfo()) == null) {
                ai = new AccountInfo();
            }
            ai.setUnlimitedTraffic();
            String registeredDateStr = br.getRegex("(?i)Registered\\s*:\\s*</td>\\s+<td>([^<>]*?)</td>").getMatch(0);
            if (registeredDateStr != null) {
                if (registeredDateStr.matches("\\d{2}-\\d{2}-\\d{4}")) {
                    ai.setCreateTime(TimeFormatter.getMilliSeconds((String)registeredDateStr, (String)"dd-MM-yyyy", (Locale)Locale.ENGLISH));
                } else {
                    ai.setCreateTime(TimeFormatter.getMilliSeconds((String)registeredDateStr, (String)"yyyy-MM-dd", (Locale)Locale.ENGLISH));
                }
            }
            String validUntilDateStr = br.getRegex("(?i)Premium End\\s*:\\s*</td>\\s+<td>([^<>]*?)</td>").getMatch(0);
            if (br.containsHTML("(?i)>\\s*Premium Member\\s*<")) {
                account.setType(Account.AccountType.PREMIUM);
                account.setConcurrentUsePossible(true);
                if (validUntilDateStr != null) {
                    if (validUntilDateStr.matches("\\d{2}-\\d{2}-\\d{4}")) {
                        ai.setValidUntil(TimeFormatter.getMilliSeconds((String)validUntilDateStr, (String)"dd-MM-yyyy", (Locale)Locale.ENGLISH));
                    } else {
                        ai.setValidUntil(TimeFormatter.getMilliSeconds((String)validUntilDateStr, (String)"yyyy-MM-dd", (Locale)Locale.ENGLISH));
                    }
                }
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                    if (br.containsHTML("(?i)direct=0")) {
                        ai.setStatus(account.getType().getLabel() + " | Direct Downloads: Enabled");
                    } else {
                        ai.setStatus(account.getType().getLabel() + " | Direct Downloads: Disabled");
                    }
                }
            } else {
                account.setType(Account.AccountType.FREE);
                account.setConcurrentUsePossible(false);
            }
        }
    }

    @Override
    public AccountInfo fetchAccountInfo(Account account) throws Exception {
        AccountInfo ai = new AccountInfo();
        this.login(account, ai, true);
        return ai;
    }

    @Override
    public void handlePremium(DownloadLink link, Account account) throws Exception {
        this.requestFileInformation(link, account);
        this.handleDownload(link, account);
    }

    private String findFreeGetLink(Browser br) {
        String getLink = br.getRegex("disabled\\s*=\\s*\"disabled\"\\s*onclick\\s*=\\s*\"document\\.location\\s*=\\s*'(https?.*?)';\"").getMatch(0);
        if (getLink == null) {
            getLink = br.getRegex("('|\")(https?://(?:www\\.)?([a-z0-9]+\\.)?" + Pattern.quote(br.getHost()) + "/get/[A-Za-z0-9]+/\\d+/[^<>\"/]+)\\1").getMatch(1);
        }
        return getLink;
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetDownloadlink(DownloadLink link) {
    }

    @Override
    public boolean hasCaptcha(DownloadLink link, Account acc) {
        if (acc == null) {
            return true;
        }
        return Account.AccountType.FREE.equals((Object)acc.getType());
    }

    protected boolean supports_https() {
        return true;
    }

    protected boolean requires_WWW() {
        return true;
    }

    protected String getMainPage() {
        String browser_host = this.br != null ? this.br.getHost() : null;
        String[] hosts = this.siteSupportedNames();
        String host = browser_host != null ? browser_host : hosts[0];
        String protocol = this.supports_https() ? "https://" : "http://";
        String mainpage = protocol;
        if (this.requires_WWW()) {
            mainpage = mainpage + "www.";
        }
        mainpage = mainpage + host;
        return mainpage;
    }

    @Override
    public SiteType.SiteTemplate siteTemplateType() {
        return SiteType.SiteTemplate.FlexShare;
    }
}

