/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import jd.PluginWrapper;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.parser.Regex;
import jd.plugins.BrowserAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.HostPlugin;
import jd.plugins.PluginException;
import jd.plugins.components.SiteType;
import org.appwork.utils.StringUtils;
import org.jdownloader.plugins.components.antiDDoSForHost;

@HostPlugin(revision="$Revision: 49212 $", interfaceVersion=2, names={}, urls={})
public class ImgShotCore
extends antiDDoSForHost {
    public static final String PROPERTY_THUMBNAILURL = "thumbnailurl";
    public static final String PROPERTY_DIRECTURL = "directurl";

    public ImgShotCore(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Override
    public String getLinkID(DownloadLink link) {
        String linkid = this.getFID(link);
        if (linkid != null) {
            return this.getHost() + "://" + linkid;
        }
        return super.getLinkID(link);
    }

    private String getFID(DownloadLink link) {
        String fid = new Regex(link.getPluginPatternMatcher(), "dlimg\\.php\\?id=([a-z0-9]+)$").getMatch(0);
        if (fid == null) {
            fid = new Regex(link.getPluginPatternMatcher(), "/img\\-([a-z0-9]+)").getMatch(0);
        }
        return fid;
    }

    @Override
    public void correctDownloadLink(DownloadLink link) {
        String fid_of_official_downloadurl = new Regex(link.getPluginPatternMatcher(), "dlimg\\.php\\?id=([a-z0-9]+)$").getMatch(0);
        if (fid_of_official_downloadurl != null) {
            String urlpart = new Regex(link.getPluginPatternMatcher(), "(https?://[^/]+)/.+").getMatch(0);
            link.setPluginPatternMatcher(urlpart + "/img-" + fid_of_official_downloadurl + ".html");
        }
    }

    public static final String getDefaultAnnotationPatternPart() {
        return "/(?:img\\-[a-z0-9\\-_]+(?:\\.jpe?g)?(?:\\.html)?|dlimg\\.php\\?id=[a-z0-9]+)";
    }

    public static String[] buildAnnotationUrls(List<String[]> pluginDomains) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String[] domains : pluginDomains) {
            ret.add("https?://(?:www\\.)?" + ImgShotCore.buildHostsPatternPart(domains) + ImgShotCore.getDefaultAnnotationPatternPart());
        }
        return ret.toArray(new String[0]);
    }

    @Override
    public String getAGBLink() {
        return "https://" + this.getHost() + "/page-TOS.html";
    }

    protected boolean checkFilesize() {
        return true;
    }

    protected boolean enforceOfficialDownloadURL() {
        return true;
    }

    protected boolean supportsResume() {
        return false;
    }

    protected String getDefaultFileExtension() {
        return ".jpg";
    }

    protected int maxChunks() {
        return 1;
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink link) throws Exception {
        return this.requestFileInformation(link, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadLink.AvailableStatus requestFileInformation(DownloadLink link, boolean isDownload) throws Exception {
        if (!link.isNameSet()) {
            link.setName(this.getFID(link) + this.getDefaultFileExtension());
        }
        this.br.setFollowRedirects(true);
        this.setBrowserExclusive();
        this.getPage(link.getPluginPatternMatcher());
        if (this.isOffline(this.br)) {
            throw new PluginException(32);
        }
        String fid = this.getFID(link);
        String filename = this.regexFilename();
        if (StringUtils.isEmpty((String)filename) || filename.equalsIgnoreCase(this.br.getHost())) {
            filename = fid;
        } else {
            filename = filename.trim();
            filename = fid + "_" + filename;
        }
        if (this.checkFilesize() && !isDownload) {
            String dllink = this.getDllink(link, filename, false);
            if (!StringUtils.isEmpty((String)dllink) && link.getView().getBytesTotal() <= 0L) {
                this.logger.info("Final downloadurl: " + dllink);
                URLConnectionAdapter con = null;
                try {
                    String file_extension_from_server;
                    String final_file_extension;
                    con = this.openAntiDDoSRequestConnection(this.br, (Request)this.br.createHeadRequest(dllink));
                    this.connectionErrorhandling(con);
                    if (!this.looksLikeDownloadableContent(con)) {
                        DownloadLink.AvailableStatus availableStatus = DownloadLink.AvailableStatus.UNCHECKABLE;
                        return availableStatus;
                    }
                    if (con.getCompleteContentLength() > 0L) {
                        link.setVerifiedFileSize(con.getCompleteContentLength());
                    }
                    if (!filename.endsWith(final_file_extension = (file_extension_from_server = ImgShotCore.getFileNameExtensionFromString(ImgShotCore.getFileNameFromConnection(con))) != null ? file_extension_from_server : this.getDefaultFileExtension())) {
                        filename = filename + final_file_extension;
                    }
                    link.setFinalFileName(filename);
                }
                finally {
                    try {
                        con.disconnect();
                    }
                    catch (Throwable throwable) {}
                }
            }
        } else {
            if (!filename.endsWith(this.getDefaultFileExtension())) {
                filename = filename + this.getDefaultFileExtension();
            }
            link.setName(filename);
        }
        return DownloadLink.AvailableStatus.TRUE;
    }

    protected String regexFilename() {
        return this.br.getRegex("<title>([^<>\"]*?) \\|[^<>]+</title>").getMatch(0);
    }

    protected boolean isOffline(Browser br) {
        return br.containsHTML(">Image Removed or Bad Link<|>This image has been removed") || br.getURL().contains("/noimage.php") || br.getHttpConnection().getResponseCode() == 404;
    }

    protected void handleContinueStep(Browser br) throws Exception {
        if (br.containsHTML("imgContinue") || br.containsHTML("continue_to_image")) {
            this.postPage(br, br.getURL(), "imgContinue=Continue+to+image+...+");
        } else if (br.containsHTML("id=\"redirect\\-wait\"")) {
            this.postPage(br, br.getURL(), "cti=1&ref=-&rc=0&bt=0&bw=gecko");
            br.getHeaders().put("Referer", br.getURL());
            this.getPage(br, br.getURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDllink(DownloadLink link, String filename, boolean isDownload) throws IOException, Exception {
        String dllink;
        block25: {
            String fid = this.getFID(this.getDownloadLink());
            dllink = this.br.getRegex("(dlimg\\.php\\?id=" + fid + ")").getMatch(0);
            if (dllink != null) {
                this.logger.info("Found official downloadlink");
            } else if (this.enforceOfficialDownloadURL()) {
                this.logger.info("Failed to find official downloadlink but trying forced official downloadlink");
                dllink = "dlimg.php?id=" + fid;
            }
            if (!StringUtils.isEmpty((String)dllink)) {
                URLConnectionAdapter con = null;
                Browser brc = this.br.cloneBrowser();
                try {
                    String final_file_extension;
                    if (isDownload) {
                        this.dl = BrowserAdapter.openDownload(brc, link, dllink, this.supportsResume(), this.maxChunks());
                        con = this.dl.getConnection();
                    } else {
                        con = this.openAntiDDoSRequestConnection(brc, (Request)this.br.createHeadRequest(dllink));
                    }
                    if (!this.looksLikeDownloadableContent(con)) {
                        dllink = null;
                        this.dl = null;
                        this.logger.info("Official downloadlink does NOT work");
                        break block25;
                    }
                    this.logger.info("Official downloadlink works");
                    if (con.getCompleteContentLength() > 0L) {
                        if (con.isContentDecoded()) {
                            link.setDownloadSize(con.getCompleteContentLength());
                        } else {
                            link.setVerifiedFileSize(con.getCompleteContentLength());
                        }
                    }
                    if (filename != null) {
                        String file_extension_from_server = ImgShotCore.getFileNameExtensionFromString(ImgShotCore.getFileNameFromConnection(con));
                        final_file_extension = file_extension_from_server != null ? file_extension_from_server : this.getDefaultFileExtension();
                        filename = this.applyFilenameExtension(filename, final_file_extension);
                        link.setFinalFileName(filename);
                    }
                    final_file_extension = dllink;
                    return final_file_extension;
                }
                catch (Throwable e) {
                    this.logger.info("Something went wrong during official downloadlink check");
                }
                finally {
                    if (!isDownload) {
                        try {
                            con.disconnect();
                        }
                        catch (Throwable final_file_extension) {}
                    }
                }
            }
        }
        this.handleContinueStep(this.br);
        dllink = this.br.getRegex("(\\'|\")(https?://([\\w\\-]+\\.)?" + Pattern.quote(this.br.getHost()) + "((?:/upload)?/big/|(?:/uploads)?/images/big)[^<>\"\\']*?)\\1").getMatch(1);
        return dllink;
    }

    @Override
    public void handleFree(DownloadLink link) throws Exception {
        this.requestFileInformation(link, true);
        String dllink = this.getDllink(link, null, true);
        if (dllink == null) {
            this.logger.warning("Failed to find final downloadurl");
            throw new PluginException(0x400000);
        }
        if (this.dl == null) {
            this.dl = BrowserAdapter.openDownload(this.br, link, dllink, this.supportsResume(), this.maxChunks());
        }
        this.connectionErrorhandling(this.dl.getConnection());
        if (!this.looksLikeDownloadableContent(this.dl.getConnection())) {
            this.br.followConnection(true);
            this.connectionErrorhandling(this.dl.getConnection());
            throw new PluginException(0x400000);
        }
        this.dl.startDownload();
    }

    private void connectionErrorhandling(URLConnectionAdapter con) throws PluginException {
        if (con.getResponseCode() == 403) {
            throw new PluginException(2048, "Server error 403", 3600000L);
        }
        if (con.getResponseCode() == 404) {
            throw new PluginException(2048, "Server error 404", 3600000L);
        }
        if (con.getURL().toString().contains("/noimage.php")) {
            throw new PluginException(2048, "Download broken", 3600000L);
        }
        if (con.getURL().toString().contains("/randomImage.php")) {
            throw new PluginException(32);
        }
    }

    @Override
    public SiteType.SiteTemplate siteTemplateType() {
        return SiteType.SiteTemplate.ImageHosting_ImgShot;
    }

    @Override
    public int getMaxSimultanFreeDownloadNum() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetDownloadlink(DownloadLink link) {
    }
}

