/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import jd.http.Browser;
import jd.http.Request;

public class RequestHistory {
    protected final Browser br;
    protected final Request request;
    protected final TYPE type;
    protected static final Map<Thread, List<RequestHistory>> MAP = new WeakHashMap<Thread, List<RequestHistory>>();

    public Browser getBrowser() {
        return this.br;
    }

    private RequestHistory(Browser browser, Request request, TYPE type) {
        this.request = request;
        this.type = type;
        this.br = browser;
    }

    public Request getRequest() {
        return this.request;
    }

    public TYPE getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RequestHistory> getCurrentThread(boolean createFlag) {
        List<RequestHistory> list;
        Map<Thread, List<RequestHistory>> map = MAP;
        synchronized (map) {
            list = MAP.get(Thread.currentThread());
            if (list == null && createFlag) {
                list = new ArrayList<RequestHistory>();
                MAP.put(Thread.currentThread(), list);
            }
        }
        return list;
    }

    public static RequestHistory addToCurrentThread(Browser br, Request request, TYPE type) {
        List<RequestHistory> list = RequestHistory.getCurrentThread(true);
        RequestHistory ret = new RequestHistory(br, request, type);
        list.add(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeFromCurrentThread(RequestHistory request) {
        List<RequestHistory> list = RequestHistory.getCurrentThread(false);
        if (list != null && list.remove(request)) {
            if (list.size() == 0) {
                Map<Thread, List<RequestHistory>> map = MAP;
                synchronized (map) {
                    MAP.remove(Thread.currentThread());
                }
            }
            return true;
        }
        return false;
    }

    public static enum TYPE {
        FULL,
        OPEN;

    }
}

