/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.archiveorg;

import java.util.ArrayList;
import java.util.List;
import jd.http.Cookies;
import org.appwork.utils.Time;
import org.jdownloader.plugins.components.archiveorg.BookPage;

public class ArchiveOrgLendingInfo {
    private Cookies cookies = null;
    private Long timestampLoaned = null;
    private final long timestampCreated;
    private final List<BookPage> bookPages = new ArrayList<BookPage>();

    public ArchiveOrgLendingInfo(Cookies cookies) {
        this.cookies = cookies;
        if (cookies != null) {
            this.setCookies(cookies);
        }
        this.timestampCreated = Time.systemIndependentCurrentJVMTimeMillis();
    }

    private void updateLoanTimestamp() {
        this.timestampLoaned = Time.systemIndependentCurrentJVMTimeMillis();
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookies cookies) {
        this.cookies = cookies;
        this.updateLoanTimestamp();
    }

    public synchronized boolean isValid() {
        if (this.isLoanSessionActive()) {
            return true;
        }
        return Time.systemIndependentCurrentJVMTimeMillis() - this.timestampCreated < 36000000L;
    }

    public synchronized boolean isLoanSessionActive() {
        return this.timestampLoaned != null && Time.systemIndependentCurrentJVMTimeMillis() - this.timestampLoaned < 3600000L;
    }

    public synchronized Long getTimeUntilNextLoanAllowed() {
        if (this.timestampLoaned == null) {
            return null;
        }
        long timePassedSinceLastLoan = Time.systemIndependentCurrentJVMTimeMillis() - this.timestampLoaned;
        long maxLoanTimeframeMillis = 300000L;
        if (timePassedSinceLastLoan < 300000L) {
            return 300000L - timePassedSinceLastLoan;
        }
        return null;
    }

    public synchronized boolean hasJustBeenLoaned() {
        return this.getTimeUntilNextLoanAllowed() != null;
    }

    public synchronized void setPageURLs(List<String> urls) {
        this.bookPages.clear();
        for (String url : urls) {
            this.bookPages.add(new BookPage(url));
        }
    }

    public synchronized void updateOrAddBookPages(List<String> urls) {
        if (urls.size() == this.bookPages.size()) {
            int index = 0;
            for (String url : urls) {
                BookPage existingBookPage = this.bookPages.get(index);
                existingBookPage.setUrl(url);
                ++index;
            }
        } else {
            this.setPageURLs(urls);
        }
    }

    public synchronized String getPageURL(int pageIndexNumber) {
        BookPage page = this.getBookPage(pageIndexNumber);
        if (page != null) {
            return page.getUrl();
        }
        return null;
    }

    public synchronized BookPage getBookPage(int pageIndexNumber) {
        if (pageIndexNumber > -1 && pageIndexNumber < this.bookPages.size()) {
            return this.bookPages.get(pageIndexNumber);
        }
        return null;
    }

    public synchronized void setBookPageDownloadStatus(int pageIndexNumber, boolean downloaded) {
        BookPage page = this.getBookPage(pageIndexNumber);
        if (page != null) {
            page.setDownloaded(downloaded);
        }
    }

    public synchronized boolean looksLikeBookDownloadIsComplete() {
        for (BookPage page : this.bookPages) {
            if (page.isDownloaded()) continue;
            return false;
        }
        return true;
    }

    public synchronized int getTotalNumberofPages() {
        if (this.bookPages == null) {
            return 0;
        }
        return this.bookPages.size();
    }

    public synchronized int getNumberOfDownloadedPages() {
        int num = 0;
        for (BookPage page : this.bookPages) {
            if (!page.isDownloaded()) continue;
            ++num;
        }
        return num;
    }
}

