/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.captchasolver;

import java.util.List;
import jd.PluginWrapper;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.DebugMode;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.PluginChallengeSolver;
import org.jdownloader.captcha.v2.challenge.clickcaptcha.ClickCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.cloudflareturnstile.CloudflareTurnstileChallenge;
import org.jdownloader.captcha.v2.challenge.cutcaptcha.CutCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.hcaptcha.HCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaCategoryChallenge;
import org.jdownloader.captcha.v2.challenge.keycaptcha.KeyCaptchaPuzzleChallenge;
import org.jdownloader.captcha.v2.challenge.multiclickcaptcha.MultiClickCaptchaChallenge;
import org.jdownloader.captcha.v2.challenge.recaptcha.v2.RecaptchaV2Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;
import org.jdownloader.captcha.v2.solver.CESSolverJob;
import org.jdownloader.plugins.controller.LazyPlugin;

public abstract class abstractPluginForCaptchaSolver
extends PluginForHost {
    private static final double MIN_BALANCE_THRESHOLD = 1.0;

    public boolean enoughBalanceFor(Challenge<?> c, Account account) throws Exception {
        return true;
    }

    public final boolean canHandle(Challenge<?> c) {
        if (!this.validateBlackWhite(c)) {
            return false;
        }
        List<CAPTCHA_TYPE> supportedTypes = this.getSupportedCaptchaTypes();
        for (CAPTCHA_TYPE supportedType : supportedTypes) {
            if (!supportedType.canHandle(c)) continue;
            return true;
        }
        return false;
    }

    public <T> PluginChallengeSolver<T> getPluginChallengeSolver(Challenge<T> c, Account account) throws Exception {
        if (!this.canHandle(c)) {
            return null;
        }
        abstractPluginForCaptchaSolver plugin = (abstractPluginForCaptchaSolver)this.getNewPluginInstance(this.getLazyP());
        plugin.setBrowser(plugin.createNewBrowserInstance());
        return new PluginChallengeSolver(plugin, account);
    }

    public abstractPluginForCaptchaSolver(PluginWrapper wrapper) {
        super(wrapper);
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            this.enablePremium(this.getBuyPremiumUrl());
        }
    }

    @Override
    public LazyPlugin.FEATURE[] getFeatures() {
        return new LazyPlugin.FEATURE[]{LazyPlugin.FEATURE.CAPTCHA_SOLVER, LazyPlugin.FEATURE.BUBBLE_NOTIFICATION};
    }

    @Override
    public abstract String getBuyPremiumUrl();

    public abstract boolean setInvalid(AbstractResponse<?> var1, Account var2) throws Exception;

    public abstract boolean setValid(AbstractResponse<?> var1, Account var2) throws Exception;

    public boolean setUnused(AbstractResponse<?> response, Account account) throws Exception {
        return false;
    }

    public abstract List<CAPTCHA_TYPE> getSupportedCaptchaTypes();

    public boolean notifyOnLowBalance() {
        return true;
    }

    @Override
    public abstract AccountInfo fetchAccountInfo(Account var1) throws Exception;

    public abstract void solve(CESSolverJob<?> var1, Account var2) throws Exception;

    public boolean validateBlackWhite(Challenge<?> c) {
        return true;
    }

    protected static void checkInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public DownloadLink.AvailableStatus requestFileInformation(DownloadLink parameter) throws Exception {
        throw new WTFException();
    }

    @Override
    public void handleFree(DownloadLink link) throws Exception {
        throw new WTFException();
    }

    public static enum CAPTCHA_TYPE {
        IMAGE{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof ImageCaptchaChallenge;
            }
        }
        ,
        RECAPTCHA_V2_INVISIBLE{

            @Override
            public boolean canHandle(Challenge<?> c) {
                if (!(c instanceof RecaptchaV2Challenge)) {
                    return false;
                }
                RecaptchaV2Challenge cl = (RecaptchaV2Challenge)c;
                return cl.isInvisible();
            }
        }
        ,
        RECAPTCHA_V2_ENTERPRISE{

            @Override
            public boolean canHandle(Challenge<?> c) {
                if (!(c instanceof RecaptchaV2Challenge)) {
                    return false;
                }
                RecaptchaV2Challenge cl = (RecaptchaV2Challenge)c;
                return cl.isEnterprise();
            }
        }
        ,
        RECAPTCHA_V2{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof RecaptchaV2Challenge;
            }
        }
        ,
        HCAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof HCaptchaChallenge;
            }
        }
        ,
        CUTCAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof CutCaptchaChallenge;
            }
        }
        ,
        SINGLE_CLICK_CAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof ClickCaptchaChallenge;
            }
        }
        ,
        MULTI_CLICK_CAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof MultiClickCaptchaChallenge;
            }
        }
        ,
        GEETEST_V1{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return false;
            }
        }
        ,
        GEETEST_V4{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return false;
            }
        }
        ,
        KEY_CAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof KeyCaptchaPuzzleChallenge || c instanceof KeyCaptchaCategoryChallenge;
            }
        }
        ,
        CLOUDFLARE_TURNSTILE{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return c instanceof CloudflareTurnstileChallenge;
            }
        }
        ,
        MT_CAPTCHA{

            @Override
            public boolean canHandle(Challenge<?> c) {
                return false;
            }
        };


        public abstract boolean canHandle(Challenge<?> var1);

        public static CAPTCHA_TYPE getCaptchaTypeForChallenge(Challenge<?> c) {
            if (c == null) {
                return null;
            }
            for (CAPTCHA_TYPE type : CAPTCHA_TYPE.values()) {
                if (!type.canHandle(c)) continue;
                return type;
            }
            return null;
        }
    }
}

