/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="civitai.com", type=Type.CRAWLER)
public interface CivitaiComConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @SpinnerValidator(min=10L, max=200L, step=1L)
    @DefaultIntValue(value=50)
    @DescriptionForConfigEntry(value="Internal value to limit max number of items per page. Lower value = More requests needed to crawl a profile. See: https://github.com/civitai/civitai/wiki/REST-API-Reference#get-apiv1images")
    @DefaultOnNull
    @Order(value=10)
    public int getProfileCrawlerMaxPaginationItems();

    public void setProfileCrawlerMaxPaginationItems(int var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=20000L, step=1000L)
    @DefaultIntValue(value=1000)
    @DescriptionForConfigEntry(value="Wait time between pagination requests.")
    @DefaultOnNull
    @Order(value=20)
    public int getProfileCrawlerPaginationSleepMillis();

    public void setProfileCrawlerPaginationSleepMillis(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Use IndexID (/images/XXXXX) for image filename?")
    @Order(value=30)
    public boolean isUseIndexIDForImageFilename();

    public void setUseIndexIDForImageFilename(boolean var1);

    public static class TRANSLATION {
        public String getProfileCrawlerMaxPaginationItems_label() {
            return "Profile crawler: Pagination size";
        }

        public String getProfileCrawlerPaginationSleepMillis_label() {
            return "Profile crawler: Wait time between pagination requests";
        }
    }
}

