/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.TakeValueFromSubconfig;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="filestore.to", type=Type.HOSTER)
public interface FilestoreToConfig
extends PluginConfigInterface {
    public static final String TEXT_GlobalNoFreeSlotsBlockModeEnabled = "Block all links of this host on error 'No free slots available'?";
    public static final String TEXT_WaittimeOnNoFreeSlotsMinutes = "Wait minutes on error 'no free slots available'";
    public static final String TEXT_StartFreeDownloadsSequentially = "Start free downloads sequentially and not at the same time?";
    public static final String TEXT_WaittimeBetweenDownloadStartsSeconds = "Wait seconds between download-starts";
    public static final String TEXT_UserAgent = "Enter User-Agent which will be used for all website http(s) requests:";
    public static final String TEXT_ModifyFinalDownloadurls = "Modify final downloadurls in free mode: Replace '/free' with '/premium'?";
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @Order(value=5)
    @DescriptionForConfigEntry(value="Block all links of this host on error 'No free slots available'?")
    public boolean isGlobalNoFreeSlotsBlockModeEnabled();

    public void setGlobalNoFreeSlotsBlockModeEnabled(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=10)
    @TakeValueFromSubconfig(value="WAIT_MINUTES_ON_NO_FREE_SLOTS")
    @SpinnerValidator(min=1L, max=600L, step=1L)
    @Order(value=10)
    @DescriptionForConfigEntry(value="Wait minutes on error 'no free slots available'")
    public int getWaittimeOnNoFreeSlotsMinutes();

    public void setWaittimeOnNoFreeSlotsMinutes(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @Order(value=15)
    @DescriptionForConfigEntry(value="Start free downloads sequentially and not at the same time?")
    public boolean isStartFreeDownloadsSequentially();

    public void setStartFreeDownloadsSequentially(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=10)
    @SpinnerValidator(min=0L, max=30L, step=1L)
    @Order(value=20)
    @DescriptionForConfigEntry(value="Wait seconds between download-starts")
    public int getWaittimeBetweenDownloadStartsSeconds();

    public void setWaittimeBetweenDownloadStartsSeconds(int var1);

    @AboutConfig
    @DefaultStringValue(value="JDDEFAULT")
    @DescriptionForConfigEntry(value="Enter User-Agent which will be used for all website http(s) requests:")
    @Order(value=30)
    public String getUserAgent();

    public void setUserAgent(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @Order(value=35)
    @DescriptionForConfigEntry(value="Modify final downloadurls in free mode: Replace '/free' with '/premium'?")
    public boolean isModifyFinalDownloadurls();

    public void setModifyFinalDownloadurls(boolean var1);

    public static class TRANSLATION {
        public String getGlobalNoFreeSlotsBlockModeEnabled_label() {
            return FilestoreToConfig.TEXT_GlobalNoFreeSlotsBlockModeEnabled;
        }

        public String getWaittimeOnNoFreeSlotsMinutes_label() {
            return FilestoreToConfig.TEXT_WaittimeOnNoFreeSlotsMinutes;
        }

        public String getStartFreeDownloadsSequentially_label() {
            return FilestoreToConfig.TEXT_StartFreeDownloadsSequentially;
        }

        public String getWaittimeBetweenDownloadStartsSeconds_label() {
            return FilestoreToConfig.TEXT_WaittimeBetweenDownloadStartsSeconds;
        }

        public String getUserAgent_label() {
            return FilestoreToConfig.TEXT_UserAgent;
        }

        public String getModifyFinalDownloadurls_label() {
            return FilestoreToConfig.TEXT_ModifyFinalDownloadurls;
        }
    }
}

