/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="m3u8", type=Type.CRAWLER)
public interface GenericM3u8DecrypterConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();
    public static final String text_CrawlSpeedMode = "Crawl mode";
    public static final String text_AddBandwidthValueToFilenames = "Add bandwidth value to filenames?";
    public static final String text_GroupByResolution = "Group by resolution?";

    @AboutConfig
    @DefaultEnumValue(value="AUTOMATIC_SUPERFAST")
    @Order(value=10)
    @DescriptionForConfigEntry(value="Crawl mode")
    public CrawlSpeedMode getCrawlSpeedMode();

    public void setCrawlSpeedMode(CrawlSpeedMode var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Add bandwidth value to filenames?")
    @Order(value=20)
    public boolean isAddBandwidthValueToFilenames();

    public void setAddBandwidthValueToFilenames(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Group by resolution?")
    @Order(value=30)
    public boolean isGroupByResolution();

    public void setGroupByResolution(boolean var1);

    public static enum CrawlSpeedMode implements LabelInterface
    {
        SLOW{

            public String getLabel() {
                return "Slow: Check individual streams in host plugin. Host Plugin probes for additional information like resolution, codec and more.";
            }
        }
        ,
        FAST{

            public String getLabel() {
                return "Fast: Trust crawler and obtain estimated filesizes. Additional information, like resolution, might not yet be available/known.";
            }
        }
        ,
        SUPERFAST{

            public String getLabel() {
                return "Super fast: Trust crawler and do not obtain estimated filesize. Additional information, like resolution, might not yet be available/known.";
            }
        }
        ,
        AUTOMATIC_FAST{

            public String getLabel() {
                return "Automatic: Prefer FAST if non video or resolution is available/known, else fall back to SLOW";
            }
        }
        ,
        AUTOMATIC_SUPERFAST{

            public String getLabel() {
                return "Automatic: Prefer SUPERFAST if non video or resolution is available/known, else fall back to SLOW";
            }
        };

    }

    public static class TRANSLATION {
        public String getCrawlSpeedMode_label() {
            return GenericM3u8DecrypterConfig.text_CrawlSpeedMode;
        }

        public String getAddBandwidthValueToFilenames_label() {
            return GenericM3u8DecrypterConfig.text_AddBandwidthValueToFilenames;
        }

        public String getGroupByResolution_label() {
            return GenericM3u8DecrypterConfig.text_GroupByResolution;
        }
    }
}

