/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.TakeValueFromSubconfig;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="instagram.com", type=Type.HOSTER)
public interface InstagramConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @Order(value=1)
    public boolean isPostCrawlerAddPostDescriptionAsTextfile();

    public void setPostCrawlerAddPostDescriptionAsTextfile(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="UPLOADER")
    @Order(value=2)
    public SinglePostPackagenameSchemeType getPostCrawlerPackagenameSchemeType();

    public void setPostCrawlerPackagenameSchemeType(SinglePostPackagenameSchemeType var1);

    @AboutConfig
    @DefaultStringValue(value="*date*_*uploader* - *main_content_id*")
    @Order(value=3)
    public String getPostCrawlerPackagenameScheme();

    public void setPostCrawlerPackagenameScheme(String var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT_1")
    @Order(value=4)
    public StoryPackagenameSchemeType getStoryPackagenameSchemeType();

    public void setStoryPackagenameSchemeType(StoryPackagenameSchemeType var1);

    @AboutConfig
    @DefaultStringValue(value="*date*_*uploader*")
    @Order(value=5)
    public String getStoryPackagenameScheme();

    public void setStoryPackagenameScheme(String var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT_1")
    @Order(value=6)
    public StoriesHighlightsPackagenameSchemeType getStoriesHighlightsPackagenameSchemeType();

    public void setStoriesHighlightsPackagenameSchemeType(StoriesHighlightsPackagenameSchemeType var1);

    @AboutConfig
    @DefaultStringValue(value="*date*_*uploader* - *title*")
    @Order(value=7)
    public String getStoriesHighlightsPackagenameScheme();

    public void setStoriesHighlightsPackagenameScheme(String var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @Order(value=10)
    public FilenameType getFilenameType();

    public void setFilenameType(FilenameType var1);

    @AboutConfig
    @DefaultStringValue(value="*date*_*uploader* - *main_content_id* *orderid*_of_*orderid_max* - *shortcode**ext*")
    @Order(value=15)
    public String getFilenameScheme();

    public void setFilenameScheme(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @TakeValueFromSubconfig(value="ADD_DATE_TO_FILENAMES")
    @Order(value=20)
    public boolean isAddDateToFilenames();

    public void setAddDateToFilenames(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @TakeValueFromSubconfig(value="ADD_ORDERID_TO_FILENAMES")
    @Order(value=30)
    public boolean isAddOrderidToFilenames();

    public void setAddOrderidToFilenames(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @TakeValueFromSubconfig(value="ADD_SHORTCODE_TO_FILENAMES")
    @Order(value=40)
    public boolean isAddShortcodeToFilenames();

    public void setAddShortcodeToFilenames(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT_QUALITY")
    @Order(value=50)
    @DefaultOnNull
    public MediaQualityDownloadMode getMediaQualityDownloadMode();

    public void setMediaQualityDownloadMode(MediaQualityDownloadMode var1);

    @AboutConfig
    @SpinnerValidator(min=-1L, max=1024L, step=1L)
    @DefaultIntValue(value=-1)
    @Order(value=70)
    public int getProfileCrawlerMaxItemsLimit();

    public void setProfileCrawlerMaxItemsLimit(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @Order(value=71)
    public boolean isProfileCrawlerCrawlStory();

    public void setProfileCrawlerCrawlStory(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @Order(value=72)
    public boolean isProfileCrawlerCrawlStoryHighlights();

    public void setProfileCrawlerCrawlStoryHighlights(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @Order(value=73)
    public boolean isProfileCrawlerCrawlProfilePicture();

    public void setProfileCrawlerCrawlProfilePicture(boolean var1);

    @AboutConfig
    @SpinnerValidator(min=1L, max=100L, step=1L)
    @DefaultIntValue(value=12)
    @Order(value=85)
    public int getProfileCrawlerReelsPaginationMaxItemsPerPage();

    public void setProfileCrawlerReelsPaginationMaxItemsPerPage(int var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=10000L, step=25L)
    @DefaultIntValue(value=25)
    @Order(value=85)
    public int getProfileTaggedCrawledMaxItemsLimit();

    public void setProfileTaggedCrawledMaxItemsLimit(int var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=10000L, step=25L)
    @DefaultIntValue(value=25)
    @TakeValueFromSubconfig(value="ONLY_GRAB_X_ITEMS_HASHTAG_CRAWLER_NUMBER")
    @Order(value=90)
    public int getHashtagCrawlerMaxItemsLimit();

    public void setHashtagCrawlerMaxItemsLimit(int var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=10000L, step=25L)
    @DefaultIntValue(value=25)
    @Order(value=91)
    public int getSearchCrawlerMaxItemsLimit();

    public void setSearchCrawlerMaxItemsLimit(int var1);

    @AboutConfig
    @DefaultEnumValue(value="CONTINUE")
    @Order(value=500)
    @DefaultOnNull
    public ActionOnRateLimitReached getActionOnRateLimitReached();

    public void setActionOnRateLimitReached(ActionOnRateLimitReached var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=60000L, step=100L)
    @DefaultIntValue(value=400)
    @Order(value=510)
    public int getGlobalRequestIntervalLimitMilliseconds();

    public void setGlobalRequestIntervalLimitMilliseconds(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @Order(value=600)
    public boolean isEnforceLoginIfAccountIsAvailable();

    public void setEnforceLoginIfAccountIsAvailable(boolean var1);

    public static enum ActionOnRateLimitReached implements LabelInterface
    {
        CONTINUE{

            public String getLabel() {
                return "Wait and try again";
            }
        }
        ,
        ABORT{

            public String getLabel() {
                return "Abort crawl process";
            }
        };

    }

    public static enum MediaQualityDownloadMode implements LabelInterface
    {
        DEFAULT_QUALITY{

            public String getLabel() {
                return "Default Instagram quality";
            }
        }
        ,
        PREFER_ORIGINAL_QUALITY{

            public String getLabel() {
                return "Prefer original quality (account required, on failure = fallback to default quality)";
            }
        }
        ,
        ENFORCE_ORIGINAL_QUALITY{

            public String getLabel() {
                return "Enforce original quality (account required, on failure = display error message)";
            }
        };

    }

    public static enum FilenameType implements LabelInterface
    {
        DEFAULT{

            public String getLabel() {
                return "Default";
            }
        }
        ,
        SERVER{

            public String getLabel() {
                return "Server filenames";
            }
        }
        ,
        CUSTOM{

            public String getLabel() {
                return "Custom";
            }
        };

    }

    public static enum StoriesHighlightsPackagenameSchemeType implements LabelInterface
    {
        DEFAULT_1{

            public String getLabel() {
                return "story highlights - *uploader* - *title*";
            }
        }
        ,
        CUSTOM{

            public String getLabel() {
                return "Custom";
            }
        };

    }

    public static enum StoryPackagenameSchemeType implements LabelInterface
    {
        DEFAULT_1{

            public String getLabel() {
                return "story - *uploader*";
            }
        }
        ,
        CUSTOM{

            public String getLabel() {
                return "Custom";
            }
        };

    }

    public static enum SinglePostPackagenameSchemeType implements LabelInterface
    {
        UPLOADER{

            public String getLabel() {
                return "*uploader*";
            }
        }
        ,
        UPLOADER_MAIN_CONTENT_ID{

            public String getLabel() {
                return "*uploader* - *main_content_id*";
            }
        }
        ,
        CUSTOM{

            public String getLabel() {
                return "Custom";
            }
        };

    }

    public static class TRANSLATION {
        public String getPostCrawlerAddPostDescriptionAsTextfile_label() {
            return "Post crawler: Add post description as textfile?";
        }

        public String getPostCrawlerPackagenameSchemeType_label() {
            return "Post crawler: Package name scheme type for /p/<id>";
        }

        public String getPostCrawlerPackagenameScheme_label() {
            return "Post crawler: Custom package name scheme for /p/<id>";
        }

        public String getStoryPackagenameSchemeType_label() {
            return "Story crawler: Package name scheme type for /stories/username/<storyID>/ URLs";
        }

        public String getStoryPackagenameScheme_label() {
            return "Story crawler: Custom package name scheme for /stories/username/<storyID>/";
        }

        public String getStoriesHighlightsPackagenameSchemeType_label() {
            return "Story highlights crawler: Package name scheme type for /stories/highlights/<storyID>/";
        }

        public String getStoriesHighlightsPackagenameScheme_label() {
            return "Story highlights crawler: Custom package name scheme for /stories/highlights/<storyID>/";
        }

        public String getFilenameType_label() {
            return "File name type for all crawled media items";
        }

        public String getFilenameScheme_label() {
            return "Custom filenames: Filename scheme";
        }

        public String getAddDateToFilenames_label() {
            return "Default file names: Include date (yyyy-MM-dd) in filenames?";
        }

        public String getAddOrderidToFilenames_label() {
            return "Default file names: Include 'order-ID' in file names if an album contains more than one element?";
        }

        public String getAddShortcodeToFilenames_label() {
            return "Default file names: Include 'shortcode' in file names if it is available?";
        }

        public String getMediaQualityDownloadMode_label() {
            return "Media quality download mode.\r\nOriginal quality = bigger filesize, without image-effects, works only when an account is available.";
        }

        public String getProfileCrawlerMaxItemsLimit_label() {
            return "Profile crawler: Only grab X latest posts? [0 = disable, -1 = crawl all]";
        }

        public String getProfileCrawlerCrawlStory_label() {
            return "Profile crawler: Crawl story?";
        }

        public String getProfileCrawlerCrawlStoryHighlights_label() {
            return "Profile crawler: Crawl story highlights?";
        }

        public String getProfileCrawlerCrawlProfilePicture_label() {
            return "Profile crawler: Crawl profile picture?";
        }

        public String getProfileCrawlerReelsPaginationMaxItemsPerPage_label() {
            return "Profile reels crawler: Max items per pagination (higher value = faster crawl process, can result in account ban!)";
        }

        public String getProfileTaggedCrawledMaxItemsLimit_label() {
            return "Tagged profile crawler: How many items shall be grabbed for /profile/tagged/? [0 = disable tagged profile crawler]";
        }

        public String getHashtagCrawlerMaxItemsLimit_label() {
            return "Hashtag crawler: How many items shall be grabbed for /explore/tags/<tagName>? [0 = disable]";
        }

        public String getSearchCrawlerMaxItemsLimit_label() {
            return "Search crawler: How many items shall be grabbed for /explore/search/keyword/?q=<searchTerm>? [0 = disable]";
        }

        public String getActionOnRateLimitReached_label() {
            return "Crawler: Action on rate limit reached";
        }

        public String getGlobalRequestIntervalLimitMilliseconds_label() {
            return "Global request limit for domains 'instagram.com' and 'cdninstagram.com' in milliseconds [0 = no limit]";
        }

        public String getEnforceLoginIfAccountIsAvailable_label() {
            return "Debug: Enforce login if account is available?";
        }
    }
}

