/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.TakeValueFromSubconfig;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="k2s.cc", type=Type.HOSTER)
public interface Keep2shareConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();
    public static final FileLinkAddMode defaultFileLinkAddMode = FileLinkAddMode.HOSTER_PLUGIN_LINKCHECK;
    public static final LinkcheckMode defaultFileLinkcheckMode = LinkcheckMode.MASS_LINKCHECK;

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @Order(value=10)
    @TakeValueFromSubconfig(value="EXPERIMENTALHANDLING")
    @DescriptionForConfigEntry(value="This may avoid unnecessary captchas when an IP limit is reached in free download mode.")
    public boolean isEnableReconnectWorkaround();

    public void setEnableReconnectWorkaround(boolean var1);

    @AboutConfig
    @Order(value=20)
    @TakeValueFromSubconfig(value="CUSTOM_REFERER")
    @DescriptionForConfigEntry(value="Custom referer value to be used.")
    public String getReferer();

    public void setReferer(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @Order(value=25)
    @DescriptionForConfigEntry(value="Always use custom referer even if added URL contains another referer.")
    public boolean isForceCustomReferer();

    public void setForceCustomReferer(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=1)
    @SpinnerValidator(min=1L, max=20L, step=1L)
    @Order(value=40)
    public int getMaxSimultaneousFreeDownloads();

    public void setMaxSimultaneousFreeDownloads(int var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @Order(value=50)
    @DescriptionForConfigEntry(value="Configure how '/file/' links are processed when they are initially added.")
    public FileLinkAddMode getFileLinkAddMode();

    public void setFileLinkAddMode(FileLinkAddMode var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @Order(value=51)
    @DescriptionForConfigEntry(value="Configure how '/file/' links are checked.")
    public LinkcheckMode getFileLinkcheckMode();

    public void setFileLinkcheckMode(LinkcheckMode var1);

    @AboutConfig
    @DefaultEnumValue(value="GLOBAL_SETTING")
    @Order(value=60)
    @DescriptionForConfigEntry(value="Define what should happen when a captcha runs into a timeout.")
    public CaptchaTimeoutBehavior getCaptchaTimeoutBehavior();

    public void setCaptchaTimeoutBehavior(CaptchaTimeoutBehavior var1);

    public static enum CaptchaTimeoutBehavior implements LabelInterface
    {
        GLOBAL_SETTING{

            public String getLabel() {
                return "Use global (default) behavior";
            }
        }
        ,
        SKIP_HOSTER{

            public String getLabel() {
                return "Skip all items of this hoster";
            }
        };

    }

    public static enum LinkcheckMode implements LabelInterface
    {
        MASS_LINKCHECK{

            public String getLabel() {
                return "Mass linkcheck: Checks up to 100 items with a single request via API '/api/v2/getfilesinfo'";
            }
        }
        ,
        SINGLE_LINKCHECK{

            public String getLabel() {
                return "Single linkcheck: Check links one by one via '/api/v2/getfilestatus'";
            }
        }
        ,
        AUTO{

            public String getLabel() {
                return "Auto: Use single linkcheck if premium account is available, else mass-linkcheck";
            }
        }
        ,
        DEFAULT{

            public String getLabel() {
                return "Default: " + defaultFileLinkcheckMode.getLabel();
            }
        };

    }

    public static enum FileLinkAddMode implements LabelInterface
    {
        HOSTER_PLUGIN_LINKCHECK{

            public String getLabel() {
                return "Pass to hoster plugin for file linkcheck";
            }
        }
        ,
        CRAWLER_PLUGIN_VIA_API_GETFILESTATUS{

            public String getLabel() {
                return "Check for folder: Use this if you plan to add single file links that are folders";
            }
        }
        ,
        DEFAULT{

            public String getLabel() {
                return "Default: " + defaultFileLinkAddMode.getLabel();
            }
        };

    }

    public static class TRANSLATION {
        public String getEnableReconnectWorkaround_label() {
            return "Enable reconnect workaround for free mode?";
        }

        public String getReferer_label() {
            return "Custom referer e.g. 'refererexamplewebsite.tld'";
        }

        public String getForceCustomReferer_label() {
            return "Force custom referer even if referer is given in URL via '?site=refererexamplewebsite.tld'?";
        }

        public String getEnableSSL_label() {
            return "Use Secure Communication over SSL (HTTPS://)";
        }

        public String getMaxSimultaneousFreeDownloads_label() {
            return "Max. number of simultaneous downloads in free mode";
        }

        public String getFileLinkAddMode_label() {
            return "File link add mode";
        }

        public String getFileLinkcheckMode_label() {
            return "File linkcheck mode";
        }

        public String getCaptchaTimeoutBehavior_label() {
            return "What to do on captcha timeout?";
        }
    }
}

