/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.TakeValueFromSubconfig;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="mega.nz", type=Type.HOSTER)
public interface MegaNzConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @TakeValueFromSubconfig(value="CHECK_RESERVED_V2")
    @DescriptionForConfigEntry(value="Check reserved traffic?")
    @Order(value=10)
    public boolean isCheckReserverTraffic();

    public void setCheckReserverTraffic(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @TakeValueFromSubconfig(value="USE_SSL_V3")
    @DescriptionForConfigEntry(value="Use SSL?")
    @Order(value=20)
    public boolean isUseSSL();

    public void setUseSSL(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @TakeValueFromSubconfig(value="USE_TMP_V2")
    @DescriptionForConfigEntry(value="Use tmp decrypting file?")
    @Order(value=30)
    public boolean isUseTmpDecryptingFile();

    public void setUseTmpDecryptingFile(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @TakeValueFromSubconfig(value="HIDE_APP_V2")
    @DescriptionForConfigEntry(value="Use minimal set of http headers?")
    @Order(value=40)
    public boolean isHideApplication();

    public void setHideApplication(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @TakeValueFromSubconfig(value="USE_GLOBAL_CDN")
    @DescriptionForConfigEntry(value="Use global CDN?")
    @Order(value=50)
    public boolean isUseGlobalCDN();

    public void setUseGlobalCDN(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @TakeValueFromSubconfig(value="ALLOW_CONCURRENT_DECRYPTION")
    @DescriptionForConfigEntry(value="Allow concurrent decryption?")
    @Order(value=60)
    public boolean isAllowConcurrentDecryption();

    public void setAllowConcurrentDecryption(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="PER_FILE")
    @DescriptionForConfigEntry(value="Set preferred limit mode")
    @Order(value=70)
    public LimitMode getLimitMode();

    public void setLimitMode(LimitMode var1);

    @AboutConfig
    @SpinnerValidator(min=10L, max=360L, step=1L)
    @DefaultIntValue(value=10)
    @TakeValueFromSubconfig(value="MAX_LIMIT_WAITTIME")
    @DescriptionForConfigEntry(value="Max. wait time minutes on limit reached")
    @Order(value=80)
    public int getMaxWaittimeOnLimitReachedMinutes();

    public void setMaxWaittimeOnLimitReachedMinutes(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Avoid trying to download files larger than 5Gb in free mode as they will most likely fail, see board.jdownloader.org/showthread.php?t=75268")
    @Order(value=85)
    public boolean is5GBFreeLimitEnabled();

    public void set5GBFreeLimitEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @TakeValueFromSubconfig(value="ALLOW_MULTIHOST_USAGE")
    @DescriptionForConfigEntry(value="Allow multihoster usage?")
    @Order(value=90)
    public boolean isAllowMultihostUsage();

    public void setAllowMultihostUsage(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @TakeValueFromSubconfig(value="ALLOW_START_FROM_ZERO_IF_DOWNLOAD_WAS_STARTED_VIA_MULTIHOSTER")
    @DescriptionForConfigEntry(value="You cannot resume partially downloaded multihoster MEGA downloads via MEGA directly. Multihosters are delivering the files decrypted but when JDownloader is downloading straight from MEGA, it is downloading the encrypted file and decrypts it later.")
    @Order(value=100)
    public boolean isAllowStartFromZeroIfDownloadWasStartedViaMultihosterBefore();

    public void setAllowStartFromZeroIfDownloadWasStartedViaMultihosterBefore(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="DEFAULT")
    @DefaultOnNull
    @DescriptionForConfigEntry(value="MEGA links by default contain a key which is needed to decrypt the file- and file information. If you are adding a lot of links without key or key, JDownloader may ask you to enter it which may be annoying for you. This setting allows you to customize how JDownloader should treat such links.")
    @Order(value=130)
    public InvalidOrMissingDecryptionKeyAction getInvalidOrMissingDecryptionKeyAction();

    public void setInvalidOrMissingDecryptionKeyAction(InvalidOrMissingDecryptionKeyAction var1);

    public static enum InvalidOrMissingDecryptionKeyAction implements LabelInterface
    {
        ASK{

            public String getLabel() {
                return "Ask";
            }
        }
        ,
        DONT_ASK{

            public String getLabel() {
                return "Don't ask";
            }
        }
        ,
        DEFAULT{

            public String getLabel() {
                return "Default: " + DEFAULT_ACTION.getLabel();
            }

            @Override
            public InvalidOrMissingDecryptionKeyAction getAction() {
                return DEFAULT_ACTION.getAction();
            }
        };

        private static final InvalidOrMissingDecryptionKeyAction DEFAULT_ACTION;

        public InvalidOrMissingDecryptionKeyAction getAction() {
            return this;
        }

        static {
            DEFAULT_ACTION = ASK;
        }
    }

    public static enum LimitMode implements LabelInterface
    {
        GLOBAL_RECONNECT{

            public String getLabel() {
                return "Global: Wait or get new IP";
            }
        }
        ,
        GLOBAL_WAIT{

            public String getLabel() {
                return "Global: Wait";
            }
        }
        ,
        PER_FILE{

            public String getLabel() {
                return "Per file: Wait";
            }
        };

    }

    public static class TRANSLATION {
        public String getCheckReserverTraffic_label() {
            return "Check reserved traffic?";
        }

        public String getUseSSL_label() {
            return "Use SSL?";
        }

        public String getUseTmpDecryptingFile_label() {
            return "Use tmp decrypting file?";
        }

        public String getHideApplication_label() {
            return "Use minimal set of http headers?";
        }

        public String getUseGlobalCDN_label() {
            return "Use global CDN?";
        }

        public String getAllowConcurrentDecryption_label() {
            return "Allow concurrent decryption?";
        }

        public String getAllowMultihostUsage_label() {
            return "Allow multihoster usage?";
        }

        public String getLimitMode_label() {
            return "Set preferred limit mode";
        }

        public String getMaxWaittimeOnLimitReachedMinutes_label() {
            return "Max. wait time minutes on limit reached";
        }

        public String get5GBFreeLimitEnabled_label() {
            return "Avoid trying to download files larger than 5Gb in free mode?";
        }

        public String getAllowStartFromZeroIfDownloadWasStartedViaMultihosterBefore_label() {
            return "Start from scratch if file was previously partially downloaded via multihoster?";
        }

        public String getInvalidOrMissingDecryptionKeyAction_label() {
            return "How to handle links with invalid or missing decryption keys?";
        }
    }
}

