/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.TakeValueFromSubconfig;
import org.jdownloader.plugins.config.Type;
import org.jdownloader.translate._JDT;

@PluginHost(host="1fichier.com", type=Type.HOSTER)
public interface OneFichierConfigInterface
extends PluginConfigInterface {
    public static final OneFichierConfigInterfaceTranslation TRANSLATION = new OneFichierConfigInterfaceTranslation();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @TakeValueFromSubconfig(value="PREFER_RECONNECT")
    @Order(value=10)
    public boolean isPreferReconnectEnabled();

    public void setPreferReconnectEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @TakeValueFromSubconfig(value="PREFER_SSL")
    @Order(value=20)
    public boolean isPreferSSLEnabled();

    public void setPreferSSLEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @Order(value=30)
    public boolean isUsePremiumAPIEnabled();

    public void setUsePremiumAPIEnabled(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="AUTO")
    @Order(value=35)
    @DescriptionForConfigEntry(value="1fichier does not provide the file information for password protected links via their mass linkcheck API. If you own a 1fichier account, and set the correct download password in beforehand, this setting can allow JDownloader to find the file information for single password protected items.")
    public LinkcheckMode getLinkcheckMode();

    public void setLinkcheckMode(LinkcheckMode var1);

    @AboutConfig
    @DefaultIntValue(value=10)
    @SpinnerValidator(min=0L, max=60L)
    @Order(value=40)
    public int getSmallFilesWaitInterval();

    public void setSmallFilesWaitInterval(int var1);

    @AboutConfig
    @DefaultIntValue(value=3)
    @Order(value=50)
    @SpinnerValidator(min=0L, max=20L, step=1L)
    public int getMaxPremiumChunks();

    public void setMaxPremiumChunks(int var1);

    @AboutConfig
    @SpinnerValidator(min=2500L, max=30000L, step=500L)
    @DefaultIntValue(value=2500)
    @DescriptionForConfigEntry(value="Define global request limit for 1fichier.com milliseconds")
    @Order(value=60)
    public int getGlobalRequestIntervalLimit1fichierComMilliseconds();

    public void setGlobalRequestIntervalLimit1fichierComMilliseconds(int var1);

    @AboutConfig
    @SpinnerValidator(min=2500L, max=30000L, step=500L)
    @DefaultIntValue(value=2500)
    @DescriptionForConfigEntry(value="Define global request limit for api.1fichier.com milliseconds")
    @Order(value=70)
    public int getGlobalRequestIntervalLimitAPI1fichierComMilliseconds();

    public void setGlobalRequestIntervalLimitAPI1fichierComMilliseconds(int var1);

    public static enum LinkcheckMode implements LabelInterface
    {
        AUTO{

            public String getLabel() {
                return "Auto";
            }
        }
        ,
        PREFER_SINGLE_LINKCHECK{

            public String getLabel() {
                return "Single linkcheck for single links via API if possible";
            }
        }
        ,
        MASS_LINKCHECK{

            public String getLabel() {
                return "Mass linkcheck";
            }
        };

    }

    public static class OneFichierConfigInterfaceTranslation {
        public String getPreferReconnectEnabled_label() {
            return "Free download and IP related download limits: Prefer reconnect?";
        }

        public String getPreferSSLEnabled_label() {
            return _JDT.T.lit_prefer_ssl();
        }

        public String getSmallFilesWaitInterval_label() {
            return "Wait x seconds for small files (smaller than 50 MB) to prevent IP block";
        }

        public String getUsePremiumAPIEnabled_label() {
            return "Use premium API[recommended]? If you want to use a 1fichier free account, disable this.";
        }

        public String getLinkcheckMode_label() {
            return "Linkcheck mode for password protected links";
        }

        public String getMaxPremiumChunks_label() {
            return "Max number of chunks for premium downloads (See 1fichier.com/hlp.html#dllent)";
        }

        public String getGlobalRequestIntervalLimit1fichierComMilliseconds_label() {
            return "Global request limit for 1fichier.com milliseconds";
        }

        public String getGlobalRequestIntervalLimitAPI1fichierComMilliseconds_label() {
            return "Global request limit for api.1fichier.com milliseconds";
        }
    }
}

