/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.TakeValueFromSubconfig;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="rapidgator.net", type=Type.HOSTER)
public interface RapidGatorConfig
extends PluginConfigInterface {
    public static final String text_ActivateExperimentalWaittimeHandling = "Activate experimental waittime handling to prevent 24-hours IP ban from rapidgator?";
    public static final String text_EnableAPIPremium = "Enable API for premium downloads [recommended] (disabled = use website for premium downloads)?";
    public static final String text_ExperimentalEnforceSSL = "Activate experimental forced SSL for downloads?";
    public static final String text_Referer = "Define custom referer";
    public static final String text_ReadTimeout = "Define custom browser read-timeout (seconds)";
    public static final String text_WaitSecondsOnErrorYouCantDownloadMoreThanOneFile = "Wait time on error 'You can't download more than one file at the same time' (seconds)";
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @TakeValueFromSubconfig(value="EXPERIMENTALHANDLING")
    @DescriptionForConfigEntry(value="Activate experimental waittime handling to prevent 24-hours IP ban from rapidgator?")
    @DefaultOnNull
    @Order(value=10)
    public boolean isActivateExperimentalWaittimeHandling();

    public void setActivateExperimentalWaittimeHandling(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Enable API for premium downloads [recommended] (disabled = use website for premium downloads)?")
    @DefaultOnNull
    @Order(value=20)
    public boolean isEnableAPIPremium();

    public void setEnableAPIPremium(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DefaultOnNull
    @Order(value=21)
    public boolean isEnableResumeFree();

    public void setEnableResumeFree(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="This may save some time for free- and free account downloads.")
    @DefaultOnNull
    @Order(value=22)
    public boolean isEnableFreeDownloadModeCaptchaDuringPreDownloadWait();

    public void setEnableFreeDownloadModeCaptchaDuringPreDownloadWait(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @TakeValueFromSubconfig(value="EXPERIMENTAL_ENFORCE_SSL")
    @DescriptionForConfigEntry(value="Activate experimental forced SSL for downloads?")
    @DefaultOnNull
    @Order(value=30)
    public boolean isExperimentalEnforceSSL();

    public void setExperimentalEnforceSSL(boolean var1);

    @AboutConfig
    @TakeValueFromSubconfig(value="CUSTOM_REFERER")
    @DescriptionForConfigEntry(value="Define custom referer")
    @DefaultOnNull
    @Order(value=40)
    public String getReferer();

    public void setReferer(String var1);

    @AboutConfig
    @DefaultIntValue(value=120)
    @SpinnerValidator(min=1L, max=300L, step=1L)
    @DefaultOnNull
    @Order(value=50)
    @DescriptionForConfigEntry(value="Define custom browser read-timeout (seconds)")
    public int getReadTimeout();

    public void setReadTimeout(int var1);

    @AboutConfig
    @DefaultIntValue(value=300)
    @SpinnerValidator(min=15L, max=900L, step=1L)
    @DefaultOnNull
    @Order(value=60)
    @DescriptionForConfigEntry(value="Wait time on error 'You can't download more than one file at the same time' (seconds)")
    public int getWaitSecondsOnErrorYouCantDownloadMoreThanOneFile();

    public void setWaitSecondsOnErrorYouCantDownloadMoreThanOneFile(int var1);

    @AboutConfig
    @DefaultEnumValue(value="SKIP")
    @DefaultOnNull
    @Order(value=70)
    @DescriptionForConfigEntry(value="What to do when a file needs a separate (additional) subscription but is also downloadable for free users?")
    public PremiumDownloadBehaviorForSubscriberOnlyFiles getPremiumDownloadBehaviorForSubscriberOnlyFiles();

    public void setPremiumDownloadBehaviorForSubscriberOnlyFiles(PremiumDownloadBehaviorForSubscriberOnlyFiles var1);

    public static enum PremiumDownloadBehaviorForSubscriberOnlyFiles implements LabelInterface
    {
        SKIP{

            public String getLabel() {
                return "Skip file";
            }
        }
        ,
        DOWNLOAD_AS_FREE_USER{

            public String getLabel() {
                return "Download file as free user";
            }
        };

    }

    public static class TRANSLATION {
        public String getActivateExperimentalWaittimeHandling_label() {
            return RapidGatorConfig.text_ActivateExperimentalWaittimeHandling;
        }

        public String getEnableAPIPremium_label() {
            return RapidGatorConfig.text_EnableAPIPremium;
        }

        public String getEnableResumeFree_label() {
            return "Attempt to resume stopped downloads in free (& free-account) mode? Rapidgator sometimes allows resume in free mode for some files and sometimes doesn't.";
        }

        public String getEnableFreeDownloadModeCaptchaDuringPreDownloadWait_label() {
            return "Free downloads: Handle captcha during pre download wait time?";
        }

        public String getExperimentalEnforceSSL_label() {
            return RapidGatorConfig.text_ExperimentalEnforceSSL;
        }

        public String getReferer_label() {
            return RapidGatorConfig.text_Referer;
        }

        public String getReadTimeout_label() {
            return RapidGatorConfig.text_ReadTimeout;
        }

        public String getWaitSecondsOnErrorYouCantDownloadMoreThanOneFile_label() {
            return RapidGatorConfig.text_WaitSecondsOnErrorYouCantDownloadMoreThanOneFile;
        }

        public String getPremiumDownloadBehaviorForSubscriberOnlyFiles_label() {
            return "Premium account download: What to do when an additional subscription is required to download a file?";
        }
    }
}

