/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultOnNull;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="rumble.com", type=Type.CRAWLER)
public interface RumbleComConfig
extends PluginConfigInterface {
    @AboutConfig
    @DefaultEnumValue(value="ALL")
    @DefaultOnNull
    @DescriptionForConfigEntry(value="Define how this plugin should pick your desired qualities")
    @Order(value=10)
    public QualitySelectionMode getQualitySelectionMode();

    public void setQualitySelectionMode(QualitySelectionMode var1);

    @AboutConfig
    @DefaultEnumValue(value="Q1080")
    @DefaultOnNull
    @Order(value=20)
    @DescriptionForConfigEntry(value="Best will be used if selected preferred quality does not exist")
    public Quality getPreferredQuality();

    public void setPreferredQuality(Quality var1);

    @AboutConfig
    @DefaultEnumValue(value="MP4")
    @DefaultOnNull
    @Order(value=30)
    @DescriptionForConfigEntry(value="Best will be used if selected preferred format does not exist")
    public Format getPreferredFormat();

    public void setPreferredFormat(Format var1);

    public static enum Quality implements LabelInterface
    {
        Q2160{

            public String getLabel() {
                return "2160p (4k)";
            }
        }
        ,
        Q1440{

            public String getLabel() {
                return "1440p (2k)";
            }
        }
        ,
        Q1080{

            public String getLabel() {
                return "1080p (FHD)";
            }
        }
        ,
        Q720{

            public String getLabel() {
                return "720p (HD)";
            }
        }
        ,
        Q480{

            public String getLabel() {
                return "480p";
            }
        }
        ,
        Q360{

            public String getLabel() {
                return "360p";
            }
        }
        ,
        Q240{

            public String getLabel() {
                return "240p";
            }
        };

    }

    public static enum Format {
        MP4,
        HLS,
        WEBM,
        TAR,
        ALL;

    }

    public static enum QualitySelectionMode implements LabelInterface
    {
        BEST{

            public String getLabel() {
                return "Best quality";
            }
        }
        ,
        WORST{

            public String getLabel() {
                return "Worst quality";
            }
        }
        ,
        SELECTED_ONLY{

            public String getLabel() {
                return "Selected quality only (fallback = all)";
            }
        }
        ,
        ALL{

            public String getLabel() {
                return "All available qualities";
            }
        };

    }
}

