/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="x.com", type=Type.HOSTER)
public interface TwitterConfigInterface
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();
    public static final String text_RegexWhitelistForCrawledUrlsInTweetText = "RegEx whitelist for crawled URLs in tweet text e.g. '(?i).*(site\\.tld|site2\\.tld).*' [Empty = Allow all URLs]";
    public static final String text_CrawlVideoThumbnail = "Crawl video thumbnail?";
    public static final String text_GlobalRequestIntervalLimitApiTwitterComMilliseconds = "Define global request limit for api.x.com in milliseconds (0 = no limit)";
    public static final String text_GlobalRequestIntervalLimitTwimgComMilliseconds = "Define global request limit for twimg.com in milliseconds (0 = no limit)";
    public static final String text_ProfileCrawlerWaittimeBetweenPaginationMilliseconds = "Profile crawler: Wait time between pagination requests in milliseconds";

    @AboutConfig
    @DefaultEnumValue(value="AUTO")
    @Order(value=20)
    @DescriptionForConfigEntry(value="Define how filenames of twitter items should look like.")
    public FilenameScheme getFilenameScheme();

    public void setFilenameScheme(FilenameScheme var1);

    @DefaultBooleanValue(value=false)
    @AboutConfig
    @Order(value=25)
    public boolean isMarkTweetRepliesViaFilename();

    public void setMarkTweetRepliesViaFilename(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="AUTO")
    @Order(value=30)
    @DescriptionForConfigEntry(value="Select if and when text of a tweet should be crawled.")
    public SingleTweetCrawlerTextCrawlMode getSingleTweetCrawlerTextCrawlMode();

    public void setSingleTweetCrawlerTextCrawlMode(SingleTweetCrawlerTextCrawlMode var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @Order(value=35)
    public boolean isCrawlRetweetsV2();

    public void setCrawlRetweetsV2(boolean var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    @Order(value=36)
    public boolean isProfileCrawlerCrawlQuotedTweets();

    public void setProfileCrawlerCrawlQuotedTweets(boolean var1);

    @DefaultBooleanValue(value=false)
    @AboutConfig
    @DescriptionForConfigEntry(value="Crawl video thumbnail?")
    @Order(value=37)
    public boolean isCrawlVideoThumbnail();

    public void setCrawlVideoThumbnail(boolean var1);

    @DefaultBooleanValue(value=false)
    @AboutConfig
    @Order(value=40)
    public boolean isCrawlURLsInsideTweetText();

    public void setCrawlURLsInsideTweetText(boolean var1);

    @AboutConfig
    @DefaultStringValue(value="")
    @DescriptionForConfigEntry(value="RegEx whitelist for crawled URLs in tweet text e.g. '(?i).*(site\\.tld|site2\\.tld).*' [Empty = Allow all URLs]")
    @Order(value=45)
    public String getRegexWhitelistForCrawledUrlsInTweetText();

    public void setRegexWhitelistForCrawledUrlsInTweetText(String var1);

    @DefaultBooleanValue(value=false)
    @AboutConfig
    @DescriptionForConfigEntry(value="Warning: videos may have no audio!")
    @Order(value=50)
    public boolean isPreferHLSVideoDownload();

    public void setPreferHLSVideoDownload(boolean var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=60000L, step=100L)
    @DefaultIntValue(value=500)
    @DescriptionForConfigEntry(value="Define global request limit for api.x.com in milliseconds (0 = no limit)")
    @Order(value=60)
    public int getGlobalRequestIntervalLimitApiTwitterComMilliseconds();

    public void setGlobalRequestIntervalLimitApiTwitterComMilliseconds(int var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=60000L, step=100L)
    @DefaultIntValue(value=500)
    @DescriptionForConfigEntry(value="Define global request limit for twimg.com in milliseconds (0 = no limit)")
    @Order(value=70)
    public int getGlobalRequestIntervalLimitTwimgComMilliseconds();

    public void setGlobalRequestIntervalLimitTwimgComMilliseconds(int var1);

    @AboutConfig
    @SpinnerValidator(min=0L, max=30000L, step=100L)
    @DefaultIntValue(value=3000)
    @DescriptionForConfigEntry(value="Profile crawler: Wait time between pagination requests in milliseconds")
    @Order(value=80)
    public int getProfileCrawlerWaittimeBetweenPaginationMilliseconds();

    public void setProfileCrawlerWaittimeBetweenPaginationMilliseconds(int var1);

    public static enum SingleTweetCrawlerMode implements LabelInterface
    {
        AUTO{

            public String getLabel() {
                return "Auto";
            }
        }
        ,
        OLD_API{

            public String getLabel() {
                return "Old API";
            }
        }
        ,
        NEW_API{

            public String getLabel() {
                return "New API";
            }
        };

    }

    public static enum SingleTweetCrawlerTextCrawlMode implements LabelInterface
    {
        AUTO{

            public String getLabel() {
                return "Auto";
            }
        }
        ,
        ALWAYS{

            public String getLabel() {
                return "Always";
            }
        }
        ,
        ONLY_IF_NO_MEDIA_IS_AVAILABLE{

            public String getLabel() {
                return "Only if no media is available";
            }
        }
        ,
        DISABLED{

            public String getLabel() {
                return "Never (disabled)";
            }
        };

    }

    public static enum FilenameScheme implements LabelInterface
    {
        AUTO{

            public String getLabel() {
                return "Auto";
            }
        }
        ,
        ORIGINAL{

            public String getLabel() {
                return "Original";
            }
        }
        ,
        ORIGINAL_WITH_TWEET_ID{

            public String getLabel() {
                return "Original with tweetID: <tweet_id>[opt:_<originalFilenameWithoutExt>].<ext>";
            }
        }
        ,
        ORIGINAL_PLUS{

            public String getLabel() {
                return "Original+: <date>_<tweet_id>[opt:_<originalFilenameWithoutExt>].<ext>";
            }
        }
        ,
        ORIGINAL_PLUS_2{

            public String getLabel() {
                return "Original+2: <date>_<username>_<tweet_id>[opt:_<originalFilenameWithoutExt>].<ext>";
            }
        }
        ,
        PLUGIN{

            public String getLabel() {
                return "Plugin: <date>_<username>_<tweet_id>[opt:_<reply>][opt:_<mediaIndex>].<ext>";
            }
        };

    }

    public static class TRANSLATION {
        public String getFilenameScheme_label() {
            return "Filename scheme";
        }

        public String getMarkTweetRepliesViaFilename_label() {
            return "Append '_reply' to filenames of tweets that are replies to other tweets?";
        }

        public String getSingleTweetCrawlerTextCrawlMode_label() {
            return "Single Tweet crawler: Text crawl mode";
        }

        public String getCrawlURLsInsideTweetText_label() {
            return "Crawl URLs inside post text?\r\nWarning: This may result in endless crawling activity!";
        }

        public String getRegexWhitelistForCrawledUrlsInTweetText_label() {
            return TwitterConfigInterface.text_RegexWhitelistForCrawledUrlsInTweetText;
        }

        public String getCrawlRetweetsV2_label() {
            return "Profile crawler: Crawl Retweets?";
        }

        public String getProfileCrawlerCrawlQuotedTweets_label() {
            return "Profile crawler: Crawl quoted Tweets?";
        }

        public String getCrawlVideoThumbnail_label() {
            return TwitterConfigInterface.text_CrawlVideoThumbnail;
        }

        public String getPreferHLSVideoDownload_label() {
            return "Videos: Prefer HLS over progressive download?\r\nWarning: Videos have no sound!";
        }

        public String getGlobalRequestIntervalLimitApiTwitterComMilliseconds_label() {
            return TwitterConfigInterface.text_GlobalRequestIntervalLimitApiTwitterComMilliseconds;
        }

        public String getGlobalRequestIntervalLimitTwimgComMilliseconds_label() {
            return TwitterConfigInterface.text_GlobalRequestIntervalLimitTwimgComMilliseconds;
        }

        public String getProfileCrawlerWaittimeBetweenPaginationMilliseconds_label() {
            return TwitterConfigInterface.text_ProfileCrawlerWaittimeBetweenPaginationMilliseconds;
        }
    }
}

