/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.config;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.plugins.config.PluginConfigInterface;
import org.jdownloader.plugins.config.PluginHost;
import org.jdownloader.plugins.config.Type;

@PluginHost(host="webshare.cz", type=Type.HOSTER)
public interface WebshareCzConfig
extends PluginConfigInterface {
    public static final TRANSLATION TRANSLATION = new TRANSLATION();

    @AboutConfig
    @DefaultIntValue(value=5)
    @SpinnerValidator(min=1L, max=20L, step=1L)
    @Order(value=10)
    @DescriptionForConfigEntry(value="How many max simultaneous downloads should be possible in free- and free-account mode?")
    public int getMaxSimultaneousFreeOrFreeAccountDownloads();

    public void setMaxSimultaneousFreeOrFreeAccountDownloads(int var1);

    @AboutConfig
    @DefaultIntValue(value=0)
    @SpinnerValidator(min=0L, max=100L, step=1L)
    @Order(value=20)
    @DescriptionForConfigEntry(value="How many times should JDownloader retry when error 'File temporarily unavailable' happens?")
    public int getMaxRetriesOnErrorTemporarilyUnavailable();

    public void setMaxRetriesOnErrorTemporarilyUnavailable(int var1);

    public static class TRANSLATION {
        public String getMaxSimultaneousFreeOrFreeAccountDownloads_label() {
            return "Max simultaneous for free- and free-account downloads";
        }

        public String getMaxRetriesOnErrorTemporarilyUnavailable_label() {
            return "Max retries on error 'File temporarily unavailable' (0 = unlimited)";
        }
    }
}

