/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.firefile;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.appwork.utils.Exceptions;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.io.CipherIOException;
import org.bouncycastle.crypto.io.InvalidCipherTextIOException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;

public class FirefileCipherOutputStream
extends FilterOutputStream {
    private BufferedBlockCipher bufferedBlockCipher = null;
    private StreamCipher streamCipher = null;
    private AEADBlockCipher aeadBlockCipher = null;
    private final byte[] oneByte = new byte[1];
    private byte[] buf;

    public FirefileCipherOutputStream(OutputStream os) {
        super(os);
    }

    public FirefileCipherOutputStream(OutputStream os, BufferedBlockCipher cipher) {
        super(os);
        this.bufferedBlockCipher = cipher;
    }

    public FirefileCipherOutputStream(OutputStream os, StreamCipher cipher) {
        super(os);
        this.streamCipher = cipher;
    }

    public FirefileCipherOutputStream(OutputStream os, AEADBlockCipher cipher) {
        super(os);
        this.aeadBlockCipher = cipher;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.streamCipher != null) {
            this.out.write(this.streamCipher.returnByte((byte)b));
        } else {
            this.oneByte[0] = (byte)b;
            this.write(this.oneByte, 0, 1);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bufferedBlockCipher != null) {
            this.ensureCapacity(len, false);
            int outLen = this.bufferedBlockCipher.processBytes(b, off, len, this.buf, 0);
            if (outLen != 0) {
                this.out.write(this.buf, 0, outLen);
            }
        } else if (this.aeadBlockCipher != null) {
            this.ensureCapacity(len, false);
            int outLen = this.aeadBlockCipher.processBytes(b, off, len, this.buf, 0);
            if (outLen != 0) {
                this.out.write(this.buf, 0, outLen);
            }
        } else if (this.streamCipher != null) {
            this.ensureCapacity(len, false);
            int outLen = this.streamCipher.processBytes(b, off, len, this.buf, 0);
            if (outLen != 0) {
                this.out.write(this.buf, 0, outLen);
            }
        } else {
            this.out.write(b, off, len);
        }
    }

    private void ensureCapacity(int updateSize, boolean finalOutput) {
        int bufLen = updateSize;
        if (finalOutput) {
            if (this.bufferedBlockCipher != null) {
                bufLen = this.bufferedBlockCipher.getOutputSize(updateSize);
            } else if (this.aeadBlockCipher != null) {
                bufLen = this.aeadBlockCipher.getOutputSize(updateSize);
            }
        } else if (this.bufferedBlockCipher != null) {
            bufLen = this.bufferedBlockCipher.getUpdateOutputSize(updateSize);
        } else if (this.aeadBlockCipher != null) {
            bufLen = this.aeadBlockCipher.getUpdateOutputSize(updateSize);
        }
        if (this.buf == null || this.buf.length < bufLen) {
            this.buf = new byte[bufLen];
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        Object error = null;
        try {
            int outLen;
            if (this.bufferedBlockCipher != null) {
                this.ensureCapacity(0, true);
                outLen = this.bufferedBlockCipher.doFinal(this.buf, 0);
                if (outLen != 0) {
                    this.out.write(this.buf, 0, outLen);
                }
            } else if (this.aeadBlockCipher != null) {
                this.ensureCapacity(0, true);
                outLen = this.aeadBlockCipher.doFinal(this.buf, 0);
                if (outLen != 0) {
                    this.out.write(this.buf, 0, outLen);
                }
            } else if (this.streamCipher != null) {
                this.streamCipher.reset();
            }
        }
        catch (InvalidCipherTextException e) {
            error = new InvalidCipherTextIOException("Error finalising cipher data: ", (Throwable)e);
        }
        catch (Exception e) {
            error = new CipherIOException("Error closing stream: ", (Throwable)e);
        }
        try {
            try {
                this.flush();
            }
            finally {
                this.out.close();
            }
        }
        catch (IOException e) {
            error = error == null ? e : (IOException)Exceptions.addSuppressed((Throwable)error, (Throwable)e);
        }
        if (error != null) {
            throw error;
        }
    }

    public void setCipher(BufferedBlockCipher c) {
        this.bufferedBlockCipher = c;
    }
}

