/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.usenet;

import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.FileIsLockedException;
import jd.controlling.downloadcontroller.ManagedThrottledConnectionHandler;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import jd.plugins.PluginProgress;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.Downloadable;
import jd.plugins.download.HashInfo;
import jd.plugins.download.HashResult;
import jd.plugins.download.SparseFile;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.NullInputStream;
import org.appwork.utils.net.socketconnection.SocketConnection;
import org.appwork.utils.net.throttledconnection.MeteredThrottledInputStream;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.usenet.SimpleUseNet;
import org.appwork.utils.net.usenet.YEncInputStream;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.speedmeter.AverageSpeedMeter;
import org.appwork.utils.speedmeter.SpeedMeterInterface;
import org.jdownloader.jna.windows.FileSystemHelper;
import org.jdownloader.plugins.DownloadPluginProgress;
import org.jdownloader.plugins.HashCheckPluginProgress;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.plugins.components.usenet.UsenetFile;
import org.jdownloader.plugins.components.usenet.UsenetFileSegment;
import org.jdownloader.translate._JDT;

public class SimpleUseNetDownloadInterface
extends DownloadInterface {
    private final Downloadable downloadable;
    private final ManagedThrottledConnectionHandler connectionHandler;
    private final LogInterface logger;
    private final AtomicBoolean abort = new AtomicBoolean(false);
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private File outputCompleteFile;
    private File outputFinalCompleteFile;
    private File outputPartFile;
    protected final AtomicLong totalLinkBytesLoaded = new AtomicLong(0L);
    private long startTimeStamp = -1L;
    private boolean resumed = false;
    private final SimpleUseNet client;
    private final UsenetFile usenetFile;
    private final DownloadLink downloadLink;

    public SimpleUseNetDownloadInterface(SimpleUseNet client, DownloadLink downloadLink, final UsenetFile usenetFile) {
        this.connectionHandler = new ManagedThrottledConnectionHandler();
        this.usenetFile = usenetFile;
        final boolean resumable = usenetFile.getNumSegments() > 1 || usenetFile.getSegments().size() > 1;
        final String host = SocketConnection.getHostName((SocketAddress)client.getSocket().getRemoteSocketAddress());
        this.downloadLink = downloadLink;
        this.downloadable = new DownloadLinkDownloadable(downloadLink){

            @Override
            public boolean isResumable() {
                return resumable;
            }

            @Override
            public String getHost() {
                return host;
            }

            @Override
            public HashInfo getHashInfo() {
                HashInfo ret = super.getHashInfo();
                if (ret == null) {
                    return usenetFile._getHashInfo();
                }
                return ret;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HashResult getHashResult(HashInfo hashInfo, File outputPartFile) {
                block16: {
                    if (hashInfo != null) {
                        return super.getHashResult(hashInfo, outputPartFile);
                    }
                    HashInfo.TYPE type = null;
                    for (UsenetFileSegment segment : usenetFile.getSegments()) {
                        HashInfo segmentHashInfo;
                        if (segment.getHash() == null || (segmentHashInfo = segment._getHashInfo()) == null) continue;
                        if (type == null) {
                            type = segmentHashInfo.getType();
                            continue;
                        }
                        if (type == segmentHashInfo.getType()) continue;
                        type = null;
                        break;
                    }
                    if (type == null) break block16;
                    HashCheckPluginProgress hashProgress = new HashCheckPluginProgress(outputPartFile, Color.YELLOW.darker(), type);
                    hashProgress.setProgressSource(this);
                    try {
                        HashInfo fileHashInfo;
                        this.addPluginProgress(hashProgress);
                        switch (type) {
                            case CRC32: {
                                long checksum;
                                FileInputStream fis = new FileInputStream(outputPartFile);
                                try {
                                    byte[] b = new byte[131072];
                                    int read = 0;
                                    long cur = 0L;
                                    CheckedInputStream cis = new CheckedInputStream(fis, new CRC32());
                                    while ((read = cis.read(b)) >= 0) {
                                        ((PluginProgress)hashProgress).setCurrent(cur += (long)read);
                                    }
                                    checksum = cis.getChecksum().getValue();
                                    cis.close();
                                }
                                finally {
                                    fis.close();
                                }
                                fileHashInfo = new HashInfo(HexFormatter.byteArrayToHex((byte[])new byte[]{(byte)(checksum >>> 24), (byte)(checksum >>> 16), (byte)(checksum >>> 8), (byte)checksum}), HashInfo.TYPE.CRC32);
                                break;
                            }
                            default: {
                                fileHashInfo = null;
                            }
                        }
                        if (fileHashInfo != null) {
                            HashResult hashResult = new HashResult(fileHashInfo, fileHashInfo.getHash());
                            return hashResult;
                        }
                    }
                    catch (Throwable e) {
                        this.getLogger().log(e);
                    }
                    finally {
                        this.removePluginProgress(hashProgress);
                    }
                }
                return null;
            }

            @Override
            public void setResumeable(boolean value) {
                super.setResumeable(resumable && value);
            }

            @Override
            public void updateFinalFileName() {
            }
        };
        if (resumable) {
            this.downloadable.setResumeable(true);
        } else {
            this.downloadable.setResumeable(false);
        }
        this.logger = this.downloadable.getLogger();
        this.downloadable.setDownloadInterface(this);
        this.client = client;
    }

    @Override
    public ManagedThrottledConnectionHandler getManagedConnetionHandler() {
        return this.connectionHandler;
    }

    private void createOutputFiles() throws SkipReasonException {
        try {
            String fileOutput = this.downloadable.getFileOutput();
            this.logger.info("createOutputChannel for " + fileOutput);
            String finalFileOutput = this.downloadable.getFinalFileOutput();
            this.outputFinalCompleteFile = this.outputCompleteFile = new File(fileOutput);
            if (!fileOutput.equals(finalFileOutput)) {
                this.outputFinalCompleteFile = new File(finalFileOutput);
            }
            this.outputPartFile = new File(this.downloadable.getFileOutputPart());
            try {
                if (Application.getJavaVersion() >= Application.JAVA17) {
                    SparseFile.createSparseFile(this.outputPartFile);
                }
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            LogSource.exception((LogInterface)this.logger, (Throwable)e);
            throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
        }
    }

    @Override
    public URLConnectionAdapter connect(Browser br) throws Exception {
        throw new WTFException("Not needed for SimpleFTPDownloadInterface");
    }

    @Override
    public long getTotalLinkBytesLoadedLive() {
        return this.getTotalLinkBytesLoaded();
    }

    private long getTotalLinkBytesLoaded() {
        return this.totalLinkBytesLoaded.get();
    }

    private void drainInputStream(InputStream is) throws IOException {
        byte[] drainBuffer = new byte[1024];
        while (is.read(drainBuffer) != -1) {
        }
    }

    protected void download() throws Exception {
        RandomAccessFile raf;
        try {
            raf = IO.open((File)this.outputPartFile, (String)"rw");
        }
        catch (IOException e) {
            throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
        }
        boolean localIO = false;
        this.totalLinkBytesLoaded.set(0L);
        MeteredThrottledInputStream meteredThrottledInputStream = new MeteredThrottledInputStream((InputStream)new NullInputStream(), (SpeedMeterInterface)new AverageSpeedMeter(10));
        boolean writeUsenetFile = false;
        try {
            LinkedList<UsenetFileSegment> segments = new LinkedList<UsenetFileSegment>(this.usenetFile.getSegments());
            if (this.downloadable.isResumable() && raf.length() > 0L) {
                UsenetFileSegment next;
                long partFileSize = raf.length();
                Iterator it = segments.iterator();
                long resumePosition = 0L;
                while (it.hasNext() && (next = (UsenetFileSegment)it.next()).getPartBegin() > 0L && next.getPartEnd() > 0L && partFileSize > next.getPartEnd()) {
                    resumePosition = next.getPartEnd();
                    it.remove();
                }
                if (resumePosition > 0L) {
                    this.resumed = true;
                }
            }
            this.connectionHandler.addThrottledConnection((ThrottledConnection)meteredThrottledInputStream);
            byte[] buffer = new byte[262144];
            HashMap<String, AtomicInteger> retryMap = new HashMap<String, AtomicInteger>();
            while (true) {
                UsenetFileSegment segment = segments.poll();
                if (this.abort.get()) break;
                if (segment == null) {
                    break;
                }
                try {
                    InputStream bodyInputStream = this.client.requestMessageBodyAsInputStream(segment.getMessageID());
                    if (bodyInputStream instanceof YEncInputStream) {
                        YEncInputStream yEnc = (YEncInputStream)bodyInputStream;
                        if (yEnc.isMultiPart() && yEnc.getPartIndex() != segment.getIndex()) {
                            YEncInputStream yEncInputStream = yEnc;
                            yEncInputStream.getClass();
                            throw new YEncInputStream.YEncIndexException(yEncInputStream, yEnc.getPartIndex());
                        }
                        long partSize = yEnc.getPartSize();
                        if (partSize >= 0L) {
                            segment.setPartBegin(yEnc.getPartBegin());
                            segment.setPartEnd(yEnc.getPartEnd());
                            long writePosition = yEnc.getPartBegin() - 1L;
                            raf.seek(writePosition);
                            this.totalLinkBytesLoaded.set(writePosition);
                            writeUsenetFile = true;
                        }
                        meteredThrottledInputStream.setInputStream((InputStream)new CheckedInputStream(bodyInputStream, new CRC32()));
                    } else {
                        meteredThrottledInputStream.setInputStream(bodyInputStream);
                    }
                    while (true) {
                        int bytesRead = meteredThrottledInputStream.read(buffer);
                        if (this.abort.get() || bytesRead == -1) break;
                        if (bytesRead <= 0) continue;
                        localIO = true;
                        raf.write(buffer, 0, bytesRead);
                        localIO = false;
                        this.totalLinkBytesLoaded.addAndGet(bytesRead);
                    }
                    if (this.logger instanceof LogSource) {
                        ((LogSource)this.logger).clear();
                    }
                    if (this.abort.get()) {
                        this.drainInputStream(bodyInputStream);
                        break;
                    }
                    if (!(bodyInputStream instanceof YEncInputStream)) continue;
                    YEncInputStream yEnc = (YEncInputStream)bodyInputStream;
                    if (yEnc.getPartCRC32() != null && meteredThrottledInputStream.getInputStream() instanceof CheckedInputStream) {
                        long checksum;
                        HashInfo hashInfo = new HashInfo(yEnc.getPartCRC32(), HashInfo.TYPE.CRC32);
                        if (!new HashResult(hashInfo, HexFormatter.byteArrayToHex((byte[])new byte[]{(byte)((checksum = ((CheckedInputStream)meteredThrottledInputStream.getInputStream()).getChecksum().getValue()) >>> 24), (byte)(checksum >>> 16), (byte)(checksum >>> 8), (byte)checksum})).match()) {
                            throw new PluginException(16384, _JDT.T.system_download_doCRC2_failed((Object)HashInfo.TYPE.CRC32));
                        }
                        segment._setHashInfo(hashInfo);
                        writeUsenetFile = true;
                    }
                    if (this.usenetFile.getHash() != null || yEnc.getFileCRC32() == null) continue;
                    this.usenetFile._setHashInfo(new HashInfo(yEnc.getFileCRC32(), HashInfo.TYPE.CRC32, true));
                    writeUsenetFile = true;
                    continue;
                }
                catch (YEncInputStream.YEncDecodedSizeException e) {
                    AtomicInteger retryCount = (AtomicInteger)retryMap.get(segment.getMessageID());
                    if (retryCount == null) {
                        retryCount = new AtomicInteger(0);
                        retryMap.put(segment.getMessageID(), retryCount);
                    }
                    if (retryCount.incrementAndGet() == 1) {
                        this.logger.log((Throwable)e);
                        segments.offerFirst(segment);
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        catch (IOException e) {
            if (localIO) {
                throw new SkipReasonException(SkipReason.DISK_FULL, e);
            }
            throw e;
        }
        finally {
            this.close(raf);
            this.cleanupDownladInterface();
            if (writeUsenetFile) {
                this.usenetFile._write(this.downloadLink);
            }
            this.downloadable.setDownloadBytesLoaded(this.getTotalLinkBytesLoaded());
            if (meteredThrottledInputStream != null) {
                this.connectionHandler.removeThrottledConnection((ThrottledConnection)meteredThrottledInputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startDownload() throws Exception {
        block22: {
            boolean bl;
            try {
                this.downloadable.setConnectionHandler(this.getManagedConnetionHandler());
                final DiskSpaceReservation reservation = this.downloadable.createDiskSpaceReservation();
                DownloadPluginProgress downloadPluginProgress = null;
                try {
                    if (!this.downloadable.checkIfWeCanWrite(new ExceptionRunnable(){

                        @Override
                        public void run() throws Exception {
                            SimpleUseNetDownloadInterface.this.downloadable.checkAndReserve(reservation);
                            SimpleUseNetDownloadInterface.this.createOutputFiles();
                            try {
                                SimpleUseNetDownloadInterface.this.downloadable.lockFiles(SimpleUseNetDownloadInterface.this.outputCompleteFile, SimpleUseNetDownloadInterface.this.outputFinalCompleteFile, SimpleUseNetDownloadInterface.this.outputPartFile);
                            }
                            catch (FileIsLockedException e) {
                                SimpleUseNetDownloadInterface.this.downloadable.unlockFiles(SimpleUseNetDownloadInterface.this.outputCompleteFile, SimpleUseNetDownloadInterface.this.outputFinalCompleteFile, SimpleUseNetDownloadInterface.this.outputPartFile);
                                throw new PluginException(8192, null, e);
                            }
                        }
                    }, null)) {
                        throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                    }
                    this.startTimeStamp = System.currentTimeMillis();
                    downloadPluginProgress = new DownloadPluginProgress(this.downloadable, this, Color.GREEN.darker());
                    this.downloadable.addPluginProgress(downloadPluginProgress);
                    this.downloadable.setAvailable(DownloadLink.AvailableStatus.TRUE);
                    this.download();
                }
                catch (Throwable throwable) {
                    try {
                        this.downloadable.free(reservation);
                    }
                    catch (Throwable e) {
                        LogSource.exception((LogInterface)this.logger, (Throwable)e);
                    }
                    try {
                        long startTimeStamp = this.getStartTimeStamp();
                        if (startTimeStamp > 0L) {
                            this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    this.downloadable.removePluginProgress(downloadPluginProgress);
                    throw throwable;
                }
                try {
                    this.downloadable.free(reservation);
                }
                catch (Throwable e) {
                    LogSource.exception((LogInterface)this.logger, (Throwable)e);
                }
                try {
                    long startTimeStamp = this.getStartTimeStamp();
                    if (startTimeStamp > 0L) {
                        this.downloadable.addDownloadTime(System.currentTimeMillis() - this.getStartTimeStamp());
                    }
                }
                catch (Throwable startTimeStamp) {
                    // empty catch block
                }
                this.downloadable.removePluginProgress(downloadPluginProgress);
                if (!this.isDownloadComplete()) break block22;
                this.logger.info("Download is complete");
                HashResult hashResult = this.getHashResult(this.downloadable, this.outputPartFile);
                if (hashResult != null) {
                    this.logger.info(hashResult.toString());
                    this.downloadable.setHashResult(hashResult);
                }
                if (hashResult == null || hashResult.match()) {
                    this.downloadable.setVerifiedFileSize(this.outputPartFile.length());
                } else if (hashResult.getHashInfo().isTrustworthy()) {
                    throw new PluginException(16384, _JDT.T.system_download_doCRC2_failed((Object)hashResult.getHashInfo().getType()));
                }
                this.finalizeDownload(this.outputPartFile, this.outputCompleteFile);
                this.downloadable.setLinkStatus(2);
                bl = true;
            }
            catch (Throwable throwable) {
                this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
                this.cleanupDownladInterface();
                throw throwable;
            }
            this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
            this.cleanupDownladInterface();
            return bl;
        }
        if (!this.externalDownloadStop()) {
            throw new PluginException(512, _JDT.T.download_error_message_incomplete());
        }
        boolean bl = false;
        this.downloadable.unlockFiles(this.outputCompleteFile, this.outputFinalCompleteFile, this.outputPartFile);
        this.cleanupDownladInterface();
        return bl;
    }

    private void close(Closeable closable) {
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isTerminated() {
        return this.terminated.get();
    }

    private boolean isDownloadComplete() {
        long verifiedFileSize = this.downloadable.getVerifiedFileSize();
        if (verifiedFileSize >= 0L) {
            return this.getTotalLinkBytesLoaded() == verifiedFileSize;
        }
        return !this.externalDownloadStop() && !this.isTerminated();
    }

    private void finalizeDownload(File outputPartFile, File outputCompleteFile) throws Exception {
        if (this.downloadable.rename(outputPartFile, outputCompleteFile)) {
            try {
                outputCompleteFile.setLastModified(System.currentTimeMillis());
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
            try {
                if (CrossSystem.isWindows()) {
                    this.logger.info("Removed SparseFlag:" + outputCompleteFile + "|" + FileSystemHelper.FSCTL_SET_SPARSE(outputCompleteFile, false));
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        } else {
            throw new PluginException(16384, _JDT.T.system_download_errors_couldnotrename(), 2L);
        }
    }

    private void cleanupDownladInterface() {
        try {
            this.downloadable.removeConnectionHandler(this.getManagedConnetionHandler());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.client.quit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected long getFileSize() {
        return this.downloadable.getVerifiedFileSize();
    }

    @Override
    public URLConnectionAdapter getConnection() {
        throw new WTFException("SimpleUseNetDownloadInterface");
    }

    @Override
    public void stopDownload() {
        if (!this.abort.getAndSet(true)) {
            this.logger.info("externalStop recieved");
            this.terminate();
        }
    }

    protected void terminate() {
        if (!this.terminated.getAndSet(true) && !this.externalDownloadStop()) {
            this.logger.severe("A critical Downloaderror occured. Terminate...");
        }
    }

    @Override
    public boolean externalDownloadStop() {
        return this.abort.get();
    }

    @Override
    public long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    @Override
    public void close() {
    }

    @Override
    public Downloadable getDownloadable() {
        return this.downloadable;
    }

    @Override
    public boolean isResumedDownload() {
        return this.resumed;
    }
}

