/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.usenet;

import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.AbstractCustomValueGetter;
import org.appwork.storage.config.annotations.CustomValueGetter;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.KeyHandler;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.config.AccountConfigInterface;
import org.jdownloader.plugins.config.Order;
import org.jdownloader.translate._JDT;

public interface UsenetAccountConfigInterface
extends AccountConfigInterface {
    public static final Translation TRANSLATION = new Translation();

    @AboutConfig
    @Order(value=10)
    @DescriptionForConfigEntry(value="Usenet Server address NOTE: host port and ssl must be a valid combination")
    public String getHost();

    public void setHost(String var1);

    @DescriptionForConfigEntry(value="Usenet Server port NOTE: host port and ssl must be a valid combination")
    @AboutConfig
    @Order(value=20)
    @CustomValueGetter(value=MyPortGetter.class)
    public void setPort(int var1);

    public int getPort();

    @DescriptionForConfigEntry(value="Usenet SSL enabled NOTE: host port and ssl must be a valid combination")
    @DefaultBooleanValue(value=true)
    @AboutConfig
    @Order(value=30)
    public void setSSLEnabled(boolean var1);

    public boolean isSSLEnabled();

    @DescriptionForConfigEntry(value="Max connections: Enter the (max) connections allowed by your Usenet provider")
    @AboutConfig
    @SpinnerValidator(min=1L, max=1000L, step=1L)
    @DefaultIntValue(value=1)
    @Order(value=40)
    public int getConnections();

    public void setConnections(int var1);

    public static class MyPortGetter
    extends AbstractCustomValueGetter<Integer> {
        public Integer getValue(KeyHandler<Integer> keyHandler, Integer value) {
            Integer port = value;
            if (port == null || port <= 0) {
                boolean ssl = ((BooleanKeyHandler)keyHandler.getStorageHandler().getKeyHandler("SSLEnabled", BooleanKeyHandler.class)).isEnabled();
                return ssl ? 563 : 119;
            }
            return port;
        }
    }

    public static class Translation {
        public String getPort_description() {
            return "";
        }

        public String getHost_description() {
            return "";
        }

        public String getSSLEnabled_description() {
            return "";
        }

        public String getPort_label() {
            return _JDT.T.lit_port();
        }

        public String getHost_label() {
            return _JDT.T.lit_host();
        }

        public String getSSLEnabled_label() {
            return _JDT.T.lit_ssl_enabled();
        }

        public String getConnections_label() {
            return _GUI.T.PackagizerFilterRuleDialog_layoutDialogContent_chunks();
        }
    }
}

