/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube;

import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.jdownloader.plugins.components.youtube.YoutubeClipData;
import org.jdownloader.plugins.components.youtube.YoutubeStreamData;
import org.jdownloader.plugins.components.youtube.itag.YoutubeITAG;

public class YoutubeFinalLinkResource
implements Storable {
    public static final TypeRef<YoutubeFinalLinkResource> TYPE_REF = new TypeRef<YoutubeFinalLinkResource>(){};
    private YoutubeITAG itag;
    private String videoID;
    private String[] segments;
    private String baseUrl;
    private int height;
    private int width;
    private String fps;
    private long estimatedContentLength = -1L;
    private int throttle = -1;
    private String lngId = null;
    private boolean drc = false;
    private long contentLength = -1L;

    public YoutubeITAG getItag() {
        return this.itag;
    }

    public void setItag(YoutubeITAG itag) {
        this.itag = itag;
    }

    public String getVideoID() {
        return this.videoID;
    }

    public void setVideoID(String videoID) {
        this.videoID = videoID;
    }

    public String[] getSegments() {
        return this.segments;
    }

    public void setSegments(String[] segments) {
        this.segments = segments;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getLngId() {
        return this.lngId;
    }

    public void setLngId(String lngId) {
        this.lngId = lngId;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public void setThrottle(int throttle) {
        this.throttle = throttle;
    }

    public void setEstimatedContentLength(long estimatedContentLength) {
        this.estimatedContentLength = Math.max(-1L, estimatedContentLength);
    }

    public long getEstimatedContentLength() {
        return this.estimatedContentLength;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = Math.max(-1L, contentLength);
    }

    public YoutubeFinalLinkResource() {
    }

    public YoutubeFinalLinkResource(YoutubeStreamData si) {
        this.itag = si.getItag();
        this.videoID = si.getClip().videoID;
        this.segments = si.getSegments();
        this.baseUrl = si.getUrl();
        this.height = si.getHeight();
        this.width = si.getWidth();
        this.fps = si.getFps();
        this.setContentLength(si.getContentLength());
        this.setEstimatedContentLength(si.getEstimatedContentLength());
        this.setThrottle(si.getThrottle());
        this.setLngId(si.getLngId());
        this.setDrc(si.isDrc());
    }

    public String getFps() {
        return this.fps;
    }

    public void setFps(String fps) {
        this.fps = fps;
    }

    public YoutubeStreamData toStreamDataObject() {
        YoutubeStreamData ret = new YoutubeStreamData(null, new YoutubeClipData(this.getVideoID()), this.getBaseUrl(), this.getItag(), null);
        ret.setHeight(this.getHeight());
        ret.setWidth(this.getWidth());
        ret.setSegments(this.getSegments());
        ret.setContentLength(this.getContentLength());
        ret.setEstimatedContentLength(this.getEstimatedContentLength());
        ret.setThrottle(this.getThrottle());
        ret.setLngId(this.getLngId());
        ret.setDrc(ret.isDrc());
        return ret;
    }

    public boolean isDrc() {
        return this.drc;
    }

    public void setDrc(boolean drc) {
        this.drc = drc;
    }
}

