/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jd.controlling.AccountController;
import jd.controlling.accountchecker.AccountCheckerThread;
import jd.http.Browser;
import jd.http.ProxySelectorInterface;
import jd.http.Request;
import jd.http.StaticProxySelector;
import jd.http.URLConnectionAdapter;
import jd.http.requests.GetRequest;
import jd.http.requests.PostRequest;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.PluginException;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.simplejson.MinimalMemoryMap;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.utils.Application;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Hash;
import org.appwork.utils.StringUtils;
import org.appwork.utils.XML;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.Log;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.parser.UrlQuery;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.controlling.ffmpeg.AbstractFFmpegBinary;
import org.jdownloader.controlling.ffmpeg.FFMpegInstallProgress;
import org.jdownloader.controlling.ffmpeg.FFMpegInstallThread;
import org.jdownloader.controlling.ffmpeg.FFmpeg;
import org.jdownloader.controlling.ffmpeg.FFmpegProvider;
import org.jdownloader.controlling.ffmpeg.FFmpegSetup;
import org.jdownloader.controlling.ffmpeg.FFprobe;
import org.jdownloader.controlling.ffmpeg.json.Stream;
import org.jdownloader.controlling.ffmpeg.json.StreamInfo;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.plugins.components.google.GoogleHelper;
import org.jdownloader.plugins.components.hls.HlsContainer;
import org.jdownloader.plugins.components.youtube.StreamCollection;
import org.jdownloader.plugins.components.youtube.VariantIDStorable;
import org.jdownloader.plugins.components.youtube.YoutubeClipData;
import org.jdownloader.plugins.components.youtube.YoutubeConfig;
import org.jdownloader.plugins.components.youtube.YoutubeReplacer;
import org.jdownloader.plugins.components.youtube.YoutubeStreamData;
import org.jdownloader.plugins.components.youtube.itag.AudioType;
import org.jdownloader.plugins.components.youtube.itag.StreamContainer;
import org.jdownloader.plugins.components.youtube.itag.VideoCodec;
import org.jdownloader.plugins.components.youtube.itag.VideoResolution;
import org.jdownloader.plugins.components.youtube.itag.YoutubeITAG;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.plugins.components.youtube.variants.AudioInterface;
import org.jdownloader.plugins.components.youtube.variants.SubtitleVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantGroup;
import org.jdownloader.plugins.components.youtube.variants.VariantInfo;
import org.jdownloader.plugins.components.youtube.variants.VideoInterface;
import org.jdownloader.plugins.components.youtube.variants.VideoVariant;
import org.jdownloader.plugins.components.youtube.variants.YoutubeSubtitleStorable;
import org.jdownloader.plugins.components.youtube.variants.generics.GenericAudioInfo;
import org.jdownloader.plugins.config.PluginJsonConfig;
import org.jdownloader.scripting.JSRhinoPermissionRestricter;
import org.jdownloader.scripting.JSShutterDelegate;
import org.jdownloader.scripting.JavaScriptEngineFactory;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;
import org.jdownloader.updatev2.UpdateController;
import org.jdownloader.updatev2.UpdateHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class YoutubeHelper {
    private static final String REGEX_DASHMPD_FROM_JSPLAYER_SETUP = "\"dashmpd\"\\s*:\\s*(\".*?\")";
    private static final String REGEX_ADAPTIVE_FMTS_FROM_JSPLAYER_SETUP = "\"adaptive_fmts\"\\s*:\\s*(\".*?\")";
    private static final String REGEX_FMT_MAP_FROM_JSPLAYER_SETUP = "\"url_encoded_fmt_stream_map\"\\s*:\\s*(\".*?\")";
    public static final String PAID_VIDEO = "Paid Video:";
    public static final String YT_CHANNEL_ID = "YT_CHANNEL_ID";
    public static final String YT_ATID = "YT_@ID";
    public static final String YT_CHANNEL_SIZE = "YT_CHANNEL_SIZE";
    public static final String YT_DURATION = "YT_DURATION";
    public static final String YT_DATE_UPLOAD = "YT_DATE_UPDATE";
    public static final String YT_DATE_LIVESTREAM_START = "YT_DATE_LIVESTREAM_START";
    public static final String YT_DATE_LIVESTREAM_END = "YT_DATE_LIVESTREAM_END";
    public static final String YT_GOOGLE_PLUS_ID = "YT_GOOGLE_PLUS_ID";
    public static final String YT_VIEWS = "YT_VIEWS";
    private Browser br;
    private String channelPlaylistCrawlerContainerUrlOverride = null;
    private final YoutubeConfig cfg;
    private final LogInterface logger;
    private String base;
    private static final Map<String, YoutubeReplacer> REPLACER_MAP;
    public static final List<YoutubeReplacer> REPLACER;
    public static final String YT_TITLE = "YT_TITLE";
    public static final String YT_TITLE_ALTERNATIVE = "YT_TITLE_ALTERNATIVE";
    public static final String YT_CATEGORY = "YT_CATEGORY";
    public static final String YT_ID = "YT_ID";
    public static final String YT_CHAPTERS = "YT_CHAPTERS";
    public static final String YT_CHANNEL_TITLE = "YT_CHANNEL";
    public static final String YT_CHANNEL_TITLE_ALTERNATIVE = "YT_CHANNEL_ALTERNATIVE";
    public static final String YT_DATE = "YT_DATE";
    public static final String YT_VARIANTS = "YT_VARIANTS";
    public static final String YT_VARIANT = "YT_VARIANT";
    public static final String YT_STREAMURL_VIDEO = "YT_STREAMURL_VIDEO";
    public static final String YT_STREAMURL_AUDIO = "YT_STREAMURL_AUDIO";
    public static final String YT_STREAMURL_VIDEO_SEGMENTS = "YT_STREAMURL_VIDEO_SEGMENTS";
    public static final String YT_STREAMURL_AUDIO_SEGMENTS = "YT_STREAMURL_AUDIO_SEGMENTS";
    private static final String REGEX_HLSMPD_FROM_JSPLAYER_SETUP = "\"hlsvp\"\\s*:\\s*(\".*?\")";
    private Map<String, Object> jsCache = new HashMap<String, Object>();
    private HashSet<String> subtitleUrls;
    private HashSet<StreamMap> fmtMaps;
    private LinkedHashSet<StreamMap> mpdUrls;
    private Account account;
    private final boolean hlsEnabled = true;
    private final boolean dashMpdEnabled = true;
    private final boolean adaptiveFmtsEnabled = true;
    private final boolean fmtMapEnabled = true;
    private String html5PlayerJs;
    private YoutubeClipData vid;
    private String playlistID = null;
    private Map<String, Object> ytInitialData;
    private Map<String, Object> ytInitialPlayerResponse = null;
    private Map<String, Object> ytPlayerConfig;
    private Map<String, Object> ytCfgSet;
    private List<YoutubeStreamData> playlistThumbnails = null;
    private static Boolean enablePlaylistSpecialDupeCheck;
    private static final Map<String, String> PLAYERJS_CACHE;
    private static volatile boolean CONSENT_COOKIE_REQUIRED;
    protected Map<String, List<YoutubeStreamData>> streamDataCache = new HashMap<String, List<YoutubeStreamData>>();
    private static boolean API_TV_ENABLED;
    public static final String YT_LENGTH_SECONDS = "YT_LENGTH_SECONDS";
    public static final String YT_STREAMURL_DATA = "YT_STREAMURL_DATA";
    @Deprecated
    public static final String YT_SUBTITLE_CODE = "YT_SUBTITLE_CODE";
    @Deprecated
    public static final String YT_SUBTITLE_CODE_LIST = "YT_SUBTITLE_CODE_LIST";
    public static final String YT_BEST_VIDEO = "YT_BEST_VIDEO";
    public static final String YT_BEST_VIDEO_HEIGHT = "YT_BEST_VIDEO_HEIGHT";
    public static final String YT_DESCRIPTION = "YT_DESCRIPTION";
    public static final String YT_DESCRIPTION_ALTERNATIVE = "YT_DESCRIPTION_ALTERNATIVE";
    public static final String YT_STREAM_DATA_VIDEO = "YT_STREAM_DATA_VIDEO";
    public static final String YT_STREAM_DATA_AUDIO = "YT_STREAM_DATA_AUDIO";
    public static final String YT_STREAM_DATA_DATA = "YT_STREAM_DATA_DATA";
    public static final String YT_3D = "YT_3D";
    public static final String YT_COLLECTION = "YT_COLLECTION";
    public static final String YT_PLAYLIST_CREATOR = "YT_PLAYLIST_CREATOR";
    public static final String YT_PLAYLIST_TITLE = "YT_PLAYLIST_TITLE";
    public static final String YT_PLAYLIST_ID = "YT_PLAYLIST_ID";
    public static final String YT_PLAYLIST_SIZE = "YT_PLAYLIST_SIZE";
    public static final String YT_PLAYLIST_POSITION = "YT_PLAYLIST_INT";
    public static final String YT_PLAYLIST_DESCRIPTION = "YT_PLAYLIST_DESCRIPTION";
    public static final String YT_USER_ID = "YT_USER_ID";
    public static final String YT_USER_NAME = "YT_USER_NAME";
    public static final String YT_USER_NAME_ALTERNATIVE = "YT_USER_NAME_ALTERNATIVE";
    private static Set<AbstractFFmpegBinary.FLAG> FFMPEG_SUPPORTED_FLAGS;
    private static final Object FFMPEG_LOCK;

    public Browser getBr() {
        return this.br;
    }

    public void setBr(Browser br) {
        this.br = this.prepareBrowser(br);
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    public static String applyReplacer(String name, YoutubeHelper helper, DownloadLink link) {
        Matcher tagMatcher = Pattern.compile("(?i)([A-Z0-9\\_]+)(\\[[^\\]]*\\])?").matcher("");
        String matchOn = name;
        Matcher tagsMatcher = Pattern.compile("\\*([^\\*]*)\\*").matcher(matchOn);
        if (!tagsMatcher.find()) {
            return matchOn;
        }
        StringBuffer sb = new StringBuffer();
        do {
            String quotedReplacement;
            String tagSection = tagsMatcher.group(1);
            String replacement = null;
            tagMatcher.reset(tagSection);
            int index = tagsMatcher.end();
            while (tagMatcher.find()) {
                String tagID = tagMatcher.group(1);
                YoutubeReplacer replacer = REPLACER_MAP.get(tagID);
                if (replacer == null) {
                    replacer = REPLACER_MAP.get(tagID.toUpperCase(Locale.ENGLISH));
                }
                if (replacer == null) continue;
                String completeTag = tagMatcher.group(0);
                String replaced = replacer.replace("*" + completeTag + "*", helper, link);
                if (StringUtils.isNotEmpty((String)replaced)) {
                    replacement = tagSection.replace(completeTag, replaced);
                    break;
                }
                replacement = "";
                break;
            }
            if (replacement == null) {
                String fixOdd = matchOn.substring(index - 1);
                if (tagsMatcher.pattern().matcher(fixOdd).find()) {
                    String fixReplacement = tagsMatcher.group(0);
                    fixReplacement = fixReplacement.substring(0, fixReplacement.length() - 1);
                    quotedReplacement = Matcher.quoteReplacement(fixReplacement);
                    tagsMatcher.appendReplacement(sb, quotedReplacement);
                    matchOn = fixOdd;
                    tagsMatcher.reset(matchOn);
                    continue;
                }
                quotedReplacement = Matcher.quoteReplacement(tagsMatcher.group(0));
                tagsMatcher.appendReplacement(sb, quotedReplacement);
                continue;
            }
            quotedReplacement = Matcher.quoteReplacement(replacement);
            tagsMatcher.appendReplacement(sb, quotedReplacement);
        } while (tagsMatcher.find());
        tagsMatcher.appendTail(sb);
        return sb.toString().trim();
    }

    public YoutubeHelper(Browser br, LogInterface logger) {
        this.setBr(br);
        this.logger = logger;
        this.cfg = CFG_YOUTUBE.CFG;
        this.base = "https://www.youtube.com";
    }

    protected Browser prepareBrowser(Browser br) {
        br.setCookie("youtube.com", "PREF", "f1=50000000&hl=en");
        br.setCookie("youtube.com", "hideBrowserUpgradeBox", "true");
        return br;
    }

    public final Map<String, Object> getYtInitialData() {
        return this.ytInitialData;
    }

    public final Map<String, Object> getYtInitialPlayerResponse() {
        return this.ytInitialPlayerResponse;
    }

    public final Map<String, Object> getYtPlayerConfig() {
        return this.ytPlayerConfig;
    }

    public final Map<String, Object> getYtCfgSet() {
        return this.ytCfgSet;
    }

    public final Account getAccountLoggedIn() {
        return this.account;
    }

    String descrambleSignature(String sig) throws IOException, PluginException {
        if (sig == null) {
            return null;
        }
        String ret = this.descrambleSignatureNew(sig);
        if (StringUtils.isNotEmpty((String)ret)) {
            return ret;
        }
        throw new PluginException(0x400000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String descrambleThrottle(String value) throws IOException, PluginException {
        String cachedResult;
        String input;
        if (value == null) {
            return null;
        }
        String output = input = value;
        String playerID = this.getPlayerID(this.html5PlayerJs);
        String resultCacheKey = value + "/" + playerID;
        String functionCacheKey = "descrambleThrottle/" + playerID;
        String function = null;
        Map<String, Object> map = this.jsCache;
        synchronized (map) {
            cachedResult = (String)this.jsCache.get(resultCacheKey);
        }
        if (cachedResult == null) {
            map = this.jsCache;
            synchronized (map) {
                function = (String)this.jsCache.get(functionCacheKey);
                if (function == null && (function = new org.appwork.utils.Regex(this.ensurePlayerSource(), "(?s)[;\n](?:function\\s+|(?:var\\s+)?)([a-zA-Z0-9_$]+)\\s*(?:|=\\s*function\\s*)\\(([a-zA-Z0-9_$]+)\\)\\s*\\{(?:(?![a-zA-Z0-9_$]+=function).)+\\}\\s*catch\\(\\s*[a-zA-Z0-9_$]+\\s*\\)\\s*\\{\\s*return\\s+[a-zA-Z0-9_$]+\\[\\d+\\]\\s*\\+\\s*\\2\\s*\\}\\s*return\\s+[^\\}]+\\}[;\n]").getMatch(-1)) == null && (function = new org.appwork.utils.Regex(this.ensurePlayerSource(), "(?s)[;\n](?:function\\s+|(?:var\\s+)?)([a-zA-Z0-9_$]+)\\s*(?:|=\\s*function\\s*)\\(([a-zA-Z0-9_$]+)\\)\\s*\\{(?:(?!\\}[;\n]).)+\\}\\s*catch\\(\\s*[a-zA-Z0-9_$]+\\s*\\)\\s*\\{\\s*return\\s+[a-zA-Z0-9_$]+\\[\\d+\\]\\s*\\+\\s*\\2\\s*\\}\\s*return\\s+[^}]+\\}[;\n]").getMatch(-1)) == null && (function = new org.appwork.utils.Regex(this.ensurePlayerSource(), "(=function\\((\\w+)\\)\\{var \\w+\\s*=\\s*\\2\\.split\\(\\2\\.slice\\(0,0\\)\\),\\w+\\s*=\\s*\\[.*?\\};)\n").getMatch(0)) == null && (function = new org.appwork.utils.Regex(this.ensurePlayerSource(), "(=function\\(a\\)\\{var b=a\\.split\\(a\\.slice\\(0,0\\)\\),c=\\[.*?\\};)\n").getMatch(0)) == null && (function = new org.appwork.utils.Regex(this.ensurePlayerSource(), "(=function\\(a\\)\\{var b=String\\.prototype\\.split\\.call\\(a,\\(\"\"\\,\"\"\\)\\),c=\\[.*?\\};)\n").getMatch(0)) == null && (function = new org.appwork.utils.Regex(this.ensurePlayerSource(), "(=function\\(a\\)\\{var b=String\\.prototype\\.split\\.call\\(a,\"\"\\),c=\\[.*?\\};)\n").getMatch(0)) == null && (function = new org.appwork.utils.Regex(this.ensurePlayerSource(), "(=function\\(a\\)\\{var b=a\\.split\\(\"\"\\),c=\\[.*?\\};)\n").getMatch(0)) == null) {
                    throw new PluginException(0x400000);
                }
                String varName = new org.appwork.utils.Regex(function, "=function\\((\\w+)\\)").getMatch(0);
                function = function.replaceAll("if\\s*\\(typeof\\s*[^=]*+\\s*===\\s*(?:\\\"undefined\\\"|[^\\[\\(\\) ]+\\[\\d+\\])\\)\\s*return\\s*" + Pattern.quote(varName) + "\\s*;", "");
                this.jsCache.put(functionCacheKey, function);
            }
        }
        if (cachedResult != null) {
            output = cachedResult;
        } else if (function != null) {
            JSShutterDelegate jsShutter = new JSShutterDelegate(){

                @Override
                public boolean isClassVisibleToScript(boolean trusted, String className) {
                    if ("org.mozilla.javascript.JavaScriptException".equals(className)) {
                        return true;
                    }
                    return trusted;
                }
            };
            HashMap<String, String> additionalMap = new HashMap<String, String>();
            Map<String, Object> map2 = this.jsCache;
            synchronized (map2) {
                Map cachedAdditionalMap = (Map)this.jsCache.get(functionCacheKey + "_additional");
                if (cachedAdditionalMap != null) {
                    additionalMap.putAll(cachedAdditionalMap);
                }
            }
            while (true) {
                try {
                    JSRhinoPermissionRestricter.THREAD_JSSHUTTER.put(Thread.currentThread(), jsShutter);
                    ScriptEngineManager manager = JavaScriptEngineFactory.getScriptEngineManager(this);
                    ScriptEngine engine = manager.getEngineByName("javascript");
                    for (String additional : additionalMap.values()) {
                        engine.eval(additional);
                    }
                    boolean hasFunctionName = !function.matches("^[^\n]*=\\s*function");
                    String js = "var calculate" + (hasFunctionName ? "=" : "") + function + " var result=calculate(\"" + input + "\")";
                    engine.eval(js);
                    String result = StringUtils.valueOfOrNull((Object)engine.get("result"));
                    if (result != null) {
                        output = result;
                        if (result.equals(value)) {
                            throw new Exception("Invalid result(unchanged):" + result);
                        }
                        if (result.startsWith("org.mozilla.javascript")) {
                            throw new ScriptException(result);
                        }
                        if (result.startsWith("enhanced_except")) {
                            throw new Exception("Invalid result:" + result);
                        }
                        Map<String, Object> map3 = this.jsCache;
                        synchronized (map3) {
                            this.jsCache.put(functionCacheKey + "_additional", new HashMap(additionalMap));
                            this.jsCache.put(resultCacheKey, output);
                            break;
                        }
                    }
                    try {
                        throw new Exception();
                    }
                    catch (Exception e) {
                        String undefined = new org.appwork.utils.Regex(e.getMessage(), "ReferenceError\\s*:\\s*\"(.*?)\"\\s*(is not defined|n'est pas d\u00e9fini|\u672a\u5b9a\u4e49)?").getMatch(0);
                        if (undefined != null && !additionalMap.containsKey(undefined)) {
                            String split;
                            String reference = new org.appwork.utils.Regex(this.ensurePlayerSource(), "(var\\s*" + Pattern.quote(undefined) + ".*?;)[\\s\r\n]*\\w+\\s*=\\s*function", 32).getMatch(0);
                            if (reference != null && (split = new org.appwork.utils.Regex(reference, "(.+\\.split\\(\";\"\\))\\s*,").getMatch(0)) != null) {
                                reference = split + ";";
                            }
                            if (reference != null) {
                                additionalMap.put(undefined, reference);
                                continue;
                            }
                        }
                        throw new PluginException(0x400000, null, e);
                    }
                }
                finally {
                    JSRhinoPermissionRestricter.THREAD_JSSHUTTER.remove(Thread.currentThread());
                    continue;
                }
                break;
            }
        }
        this.logger.info("nsig(" + this.vid.videoID + "," + playerID + "):" + input + "->" + output + "(cached:" + (cachedResult != null) + ")");
        return output;
    }

    public static boolean enablePlaylistSpecialDupeCheck() {
        Boolean ret = enablePlaylistSpecialDupeCheck;
        if (ret != null) {
            return ret;
        }
        YoutubeConfig.PlaylistDupeDetectionMode mode = PluginJsonConfig.get(YoutubeConfig.class).getPlaylistDupeDetectionMode();
        switch (mode) {
            case AUTO: 
            case ALLOW_PLAYLIST_AND_SINGLE_VIDEO: {
                enablePlaylistSpecialDupeCheck = true;
                return enablePlaylistSpecialDupeCheck;
            }
        }
        enablePlaylistSpecialDupeCheck = false;
        return enablePlaylistSpecialDupeCheck;
    }

    private String getPlayerID(String playerJS) {
        String ret = new org.appwork.utils.Regex(playerJS, "/player/([^/]+)/(?:tv-)?player(?:_|-)").getMatch(0);
        if (ret != null) {
            return ret;
        }
        return playerJS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String descrambleSignatureNew(String sig) throws IOException, PluginException {
        if (sig == null) {
            return null;
        }
        String playerID = this.getPlayerID(this.html5PlayerJs);
        String resultCacheKey = "descrambleSignatureNew/" + playerID + "/";
        String all = null;
        String descrambler = null;
        Map<String, Object> map = this.jsCache;
        synchronized (map) {
            all = (String)this.jsCache.get(resultCacheKey + "all");
            descrambler = (String)this.jsCache.get(resultCacheKey + "descrambler");
            if (descrambler == null) {
                descrambler = new org.appwork.utils.Regex(this.ensurePlayerSource(), "([a-zA-Z0-9_$]+)&&\\(\\1\\s*=\\s*([a-zA-Z0-9_$]{2,})\\(decodeURIComponent\\(\\1\\)\\)").getMatch(1);
                if (descrambler == null && (descrambler = new org.appwork.utils.Regex(this.ensurePlayerSource(), "\"signature\"\\s*,\\s*([\\$\\w]+)\\([\\$\\w\\.]+\\s*\\)\\s*\\)(\\s*\\)\\s*){0,};").getMatch(0)) == null && (descrambler = new org.appwork.utils.Regex(this.ensurePlayerSource(), "(?:^|[^a-zA-Z0-9_$])([a-zA-Z0-9_$]{2})\\s*=\\s*function\\((\\w+)\\)\\{\\s*\\2=\\s*\\2\\.split\\(\"\"\\)").getMatch(0)) == null && (descrambler = new org.appwork.utils.Regex(this.ensurePlayerSource(), "([a-zA-Z0-9_$]+)\\s*=\\s*function\\((\\w+)\\)\\{\\s*\\2=\\s*\\2\\.split\\(\"\"\\)").getMatch(0)) == null && (descrambler = new org.appwork.utils.Regex(this.ensurePlayerSource(), "([a-zA-Z0-9_$]+)\\s*=\\s*function\\((\\w+)\\)\\{\\s*\\2=\\s*\\2\\.split\\((\"\"|\\w+\\[\\d+\\])\\)").getMatch(0)) == null && (descrambler = new org.appwork.utils.Regex(this.ensurePlayerSource(), "([a-zA-Z0-9_$]+)\\s*=\\s*function\\((\\w+)\\)\\{[^=]+=\\s*\\2\\.split\\((\"\"|\\w+\\[\\d+\\]|\\2\\.)").getMatch(0)) == null) {
                    throw new PluginException(0x400000);
                }
                this.logger.info("FunctionName:" + descrambler);
                String func = "(?<!\\.)" + Pattern.quote(descrambler) + "\\s*=\\s*function\\(([^)]+)\\)\\{(.+?return.*?)\\};";
                String des = new org.appwork.utils.Regex(this.ensurePlayerSource(), Pattern.compile(func, 32)).getMatch(1);
                all = new org.appwork.utils.Regex(this.ensurePlayerSource(), Pattern.compile(func, 32)).getMatch(-1);
                this.logger.info("Function:" + all);
                if (all == null) {
                    throw new PluginException(0x400000);
                }
                String requiredObjectName = new org.appwork.utils.Regex(des, "([\\w\\d\\$]+)\\.([\\w\\d]{2})\\(").getMatch(0);
                if (requiredObjectName != null) {
                    String requiredObject = new org.appwork.utils.Regex(this.ensurePlayerSource(), Pattern.compile("var " + Pattern.quote(requiredObjectName) + "=\\{.*?\\}\\};", 32)).getMatch(-1);
                    if (requiredObject == null) {
                        throw new PluginException(0x400000, "Missing object:" + requiredObject);
                    }
                    all = all + requiredObject;
                }
                all = all + ";";
                this.logger.info("Complete Function:" + all);
                this.jsCache.put(resultCacheKey + "all", all);
                this.jsCache.put(resultCacheKey + "descrambler", descrambler);
            }
        }
        while (true) {
            JSShutterDelegate jsShutter = new JSShutterDelegate(){

                @Override
                public boolean isClassVisibleToScript(boolean trusted, String className) {
                    if ("org.mozilla.javascript.JavaScriptException".equals(className)) {
                        return true;
                    }
                    return trusted;
                }
            };
            try {
                JSRhinoPermissionRestricter.THREAD_JSSHUTTER.put(Thread.currentThread(), jsShutter);
                ScriptEngineManager manager = JavaScriptEngineFactory.getScriptEngineManager(this);
                ScriptEngine engine = manager.getEngineByName("javascript");
                String debugJS = all + " " + descrambler + "(\"" + sig + "\")";
                String result = StringUtils.valueOfOrNull((Object)engine.eval(debugJS));
                if (result == null) break;
                if (result.startsWith("org.mozilla.javascript")) {
                    throw new ScriptException(result);
                }
                if (result.equals(sig)) {
                    throw new Exception("Invalid result(unchanged):" + result);
                }
                Object object = this.jsCache;
                synchronized (object) {
                    this.jsCache.put(resultCacheKey + "all", all);
                }
                this.logger.info("sig1(" + this.vid.videoID + "," + playerID + "):" + sig + "->" + result);
                object = result;
                return object;
            }
            catch (Throwable e) {
                if (e.getMessage() != null) {
                    String ee = new org.appwork.utils.Regex(e.getMessage(), "ReferenceError\\s*:\\s*\"(.*?)\"\\s*(is not defined|n'est pas d\u00e9fini|\u672a\u5b9a\u4e49)?").getMatch(0);
                    if (ee != null) {
                        String split;
                        String html5PlayerSource = this.ensurePlayerSource();
                        String ref = new org.appwork.utils.Regex(html5PlayerSource, "var\\s+" + Pattern.quote(ee) + "\\s*=\\s*\\{.*?\\};", 32).getMatch(-1);
                        if (ref == null) {
                            ref = new org.appwork.utils.Regex(html5PlayerSource, "(var\\s*" + Pattern.quote(ee) + ".*?;)[\\s\r\n]*\\w+\\s*=\\s*function", 32).getMatch(0);
                        }
                        if (ref != null && (split = new org.appwork.utils.Regex(ref, "(.+\\.split\\(\";\"\\))\\s*,").getMatch(0)) != null) {
                            ref = split + ";";
                        }
                        if (ref != null) {
                            all = ref + "\r\n" + all;
                            continue;
                        }
                        this.logger.warning("Could not find missing var/function");
                    } else {
                        this.logger.warning("Could not find reference Error");
                    }
                }
                this.logger.log(e);
            }
            finally {
                JSRhinoPermissionRestricter.THREAD_JSSHUTTER.remove(Thread.currentThread());
                continue;
            }
            break;
        }
        throw new PluginException(0x400000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ensurePlayerSource() throws IOException {
        String html5PlayerJs = this.html5PlayerJs;
        if (html5PlayerJs == null) {
            throw new IOException("no html5 player js");
        }
        String key = this.getPlayerID(html5PlayerJs);
        Map<String, String> map = PLAYERJS_CACHE;
        synchronized (map) {
            String ret = PLAYERJS_CACHE.get(key);
            if (ret == null) {
                ret = this.br.cloneBrowser().getPage(html5PlayerJs);
                PLAYERJS_CACHE.put(key, ret);
            }
            return ret;
        }
    }

    protected YoutubeClipData extractData(YoutubeClipData vid) {
        this.parseTitle(vid);
        this.parseDescription(vid);
        this.parsePublishedDate(vid);
        this.parseUploadedDate(vid);
        this.parseLivestreamInformation(vid);
        this.parseChannelID(vid);
        this.parseDuration(vid);
        this.parseChapters(vid);
        this.parseChannelTitle(vid);
        this.parseUser(vid);
        this.parseAtID(vid);
        this.parseViews(vid);
        this.parseCategory(vid);
        return vid;
    }

    protected String parseViews(YoutubeClipData vid) {
        if (StringUtils.isEmpty((String)vid.views)) {
            vid.views = this.parseViewsFromMaps(vid);
        }
        return vid.views;
    }

    protected String parseTitle(YoutubeClipData vid) {
        if (StringUtils.isEmpty((String)vid.title)) {
            String match;
            String[] titles = this.getVidTitleFromMaps();
            if (titles != null && titles.length > 0) {
                vid.title = titles[0];
                if (titles.length > 1) {
                    vid.title_alternative = titles[1];
                }
            }
            if (StringUtils.isEmpty((String)vid.title) && StringUtils.isNotEmpty((String)(match = this.br.getRegex("document\\.title\\s*=\\s*\"(.*?) - YouTube\"").getMatch(0)))) {
                vid.title = Encoding.htmlDecode((String)match.replaceAll("\\+", " ").trim());
            }
        }
        return vid.title;
    }

    protected String parseDescription(YoutubeClipData vid) {
        String[] descriptions;
        if (StringUtils.isEmpty((String)vid.description) && (descriptions = this.getVidDescriptionFromMaps()) != null && descriptions.length > 0) {
            vid.description = descriptions[0];
            if (descriptions.length > 1) {
                vid.description_alternative = descriptions[1];
            }
        }
        return vid.description;
    }

    protected long parsePublishedDate(YoutubeClipData vid) {
        if (vid.datePublished <= 0L) {
            vid.datePublished = this.getPublishedDateFromMaps();
        }
        return vid.datePublished;
    }

    protected long parseUploadedDate(YoutubeClipData vid) {
        if (vid.dateUploaded <= 0L) {
            vid.dateUploaded = this.getUploadedDateFromMaps();
        }
        return vid.dateUploaded;
    }

    protected void parseLivestreamInformation(YoutubeClipData vid) {
        Map liveBroadcastDetails;
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        if (map != null && (liveBroadcastDetails = (Map)JavaScriptEngineFactory.walkJson(map, "microformat/playerMicroformatRenderer/liveBroadcastDetails")) != null) {
            String endTimestampStr;
            vid.isLiveNow = (Boolean)liveBroadcastDetails.get("isLiveNow");
            String startTimestampStr = (String)liveBroadcastDetails.get("startTimestamp");
            if (startTimestampStr != null) {
                vid.dateLivestreamStart = TimeFormatter.getMilliSeconds((String)startTimestampStr, (String)"yyyy-MM-dd'T'HH:mm:ssXXX", (Locale)Locale.US);
            }
            if ((endTimestampStr = (String)liveBroadcastDetails.get("endTimestamp")) != null) {
                vid.dateLivestreamEnd = TimeFormatter.getMilliSeconds((String)endTimestampStr, (String)"yyyy-MM-dd'T'HH:mm:ssXXX", (Locale)Locale.US);
            }
        }
        if (vid.dateUploaded <= 0L) {
            vid.dateUploaded = this.getUploadedDateFromMaps();
        }
    }

    protected String parseChannelID(YoutubeClipData vid) {
        if (StringUtils.isEmpty((String)vid.channelID)) {
            vid.channelID = this.getChannelIdFromMaps();
        }
        return vid.channelID;
    }

    protected int parseDuration(YoutubeClipData vid) {
        if (vid.duration <= 0) {
            String match;
            vid.duration = this.getVidDurationFromMaps();
            if (vid.duration <= 0 && StringUtils.isNotEmpty((String)(match = this.br.getRegex("\"length_seconds\"\\s*:\\s*(\\d+)").getMatch(0)))) {
                vid.duration = Integer.parseInt(match);
            }
        }
        return vid.duration;
    }

    protected String parseUser(YoutubeClipData vid) {
        if (StringUtils.isEmpty((String)vid.user)) {
            String[] users = this.getUserFromMaps();
            if (users != null && users.length > 0) {
                vid.user = users[0];
                if (users.length > 1) {
                    vid.user_alternative = users[1];
                }
            }
            if (StringUtils.isEmpty((String)vid.user)) {
                String match = this.br.getRegex("temprop=\"url\" href=\"https?://(www\\.)?youtube\\.com/(?:user/|@)([^<>\"\\?]+)\"").getMatch(1);
                String vidWorkAround = this.br.getRegex("&author=(.*?)&").getMatch(0);
                if (StringUtils.isNotEmpty((String)match)) {
                    vid.user = Encoding.htmlDecode((String)match.trim());
                } else if (vid.channelTitle != null) {
                    vid.user = vid.channelTitle;
                } else if (StringUtils.isNotEmpty((String)vidWorkAround)) {
                    vid.user = vidWorkAround;
                }
            }
        }
        return vid.user;
    }

    protected String parseAtID(YoutubeClipData vid) {
        Map<String, Object> map;
        if (StringUtils.isEmpty((String)vid.atID) && (map = this.getYtInitialPlayerResponse()) != null) {
            String ownerProfileUrl = (String)JavaScriptEngineFactory.walkJson(map, "microformat/playerMicroformatRenderer/ownerProfileUrl");
            vid.atID = new org.appwork.utils.Regex(ownerProfileUrl, "youtube.com/@([^\\?/]+)").getMatch(0);
        }
        return vid.atID;
    }

    protected String parseCategory(YoutubeClipData vid) {
        if (StringUtils.isEmpty((String)vid.category)) {
            vid.category = this.getCategoryFromMaps();
        }
        return vid.category;
    }

    protected String parseChannelTitle(YoutubeClipData vid) {
        if (StringUtils.isEmpty((String)vid.channelTitle)) {
            String[] titles = this.getChannelTitleFromMaps();
            if (titles != null && titles.length > 0) {
                vid.channelTitle = titles[0];
                if (titles.length > 1) {
                    vid.channelTitle_alternative = titles[1];
                }
            }
            if (StringUtils.isEmpty((String)vid.channelTitle)) {
                String match = this.br.getRegex("<div class=\"yt-user-info\"><a [^>]*data-name[^>]*>(.*?)</a>").getMatch(0);
                if (StringUtils.isEmpty((String)match) && StringUtils.isNotEmpty((String)vid.channelID)) {
                    match = this.br.getRegex("<div class=\"yt-user-info\">\\s*<a [^>]+ data-ytid=\"" + Pattern.quote(vid.channelID) + "\"[^>]*>(.*?)</a>").getMatch(0);
                }
                if (StringUtils.isNotEmpty((String)match)) {
                    vid.channelTitle = Encoding.htmlDecode((String)match.trim());
                }
            }
        }
        return vid.channelTitle;
    }

    public String parseViewsFromMaps(YoutubeClipData vid) {
        Object viewCount;
        String result = null;
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        if (StringUtils.isEmpty(result) && map != null && (viewCount = JavaScriptEngineFactory.walkJson(map, "microformat/playerMicroformatRenderer/viewCount")) != null) {
            result = viewCount.toString();
        }
        map = this.getYtInitialData();
        if (StringUtils.isEmpty(result) && map != null) {
            result = (String)JavaScriptEngineFactory.walkJson(map, "contents/twoColumnWatchNextResults/results/results/contents/{}/videoPrimaryInfoRenderer/viewCount/videoViewCountRenderer/shortViewCount/simpleText");
        }
        return result;
    }

    public String[] getVidDescriptionFromMaps() {
        List tmp;
        String shortDescription;
        ArrayList<String> ret = new ArrayList<String>();
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        if (map != null && (shortDescription = (String)JavaScriptEngineFactory.walkJson(map, "videoDetails/shortDescription")) != null) {
            ret.add(shortDescription);
        }
        if ((map = this.getYtInitialData()) != null && (tmp = (List)JavaScriptEngineFactory.walkJson(map, "contents/twoColumnWatchNextResults/results/results/contents/{}/videoSecondaryInfoRenderer/description/runs")) != null) {
            String description;
            StringBuilder sb = new StringBuilder();
            for (Object t : tmp) {
                Map o = (Map)t;
                String url = (String)JavaScriptEngineFactory.walkJson((Object)o, "navigationEndpoint/urlEndpoint/url");
                String text = (String)o.get("text");
                if (text == null) continue;
                if (url != null) {
                    try {
                        sb.append(this.br.getURL(url).toString());
                    }
                    catch (IOException e) {
                        sb.append(url);
                    }
                    continue;
                }
                sb.append(text);
            }
            if (sb.length() > 0 && (description = sb.toString()) != null && !ret.contains(description)) {
                ret.add(description);
            }
        }
        return ret.toArray(new String[0]);
    }

    public int getVidDurationFromMaps() {
        String tmp;
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        if (map != null && (tmp = (String)JavaScriptEngineFactory.walkJson(map, "videoDetails/lengthSeconds")) != null) {
            return Integer.parseInt(tmp);
        }
        return -1;
    }

    protected String parseChapters(YoutubeClipData vid) {
        if (vid.chapters == null) {
            vid.chapters = this.getChaptersFromMaps();
        }
        return vid.chapters;
    }

    public String getChaptersFromMaps() {
        Map<String, Object> map = this.getYtInitialData();
        if (map == null) {
            return null;
        }
        List chapters = (List)JavaScriptEngineFactory.walkJson(map, "playerOverlays", "playerOverlayRenderer", "decoratedPlayerBarRenderer", "decoratedPlayerBarRenderer", "playerBar", "multiMarkersPlayerBarRenderer", "markersMap", "{}", "value", "chapters");
        if (chapters == null || chapters.size() == 0) {
            return null;
        }
        ArrayList<MinimalMemoryMap> chapterList = new ArrayList<MinimalMemoryMap>();
        for (Map chapter : chapters) {
            MinimalMemoryMap chapterEntry = new MinimalMemoryMap();
            String title = (String)JavaScriptEngineFactory.walkJson((Object)chapter, "chapterRenderer", "title", "simpleText");
            Number timeRangeStartMillis = (Number)JavaScriptEngineFactory.walkJson((Object)chapter, "chapterRenderer", "timeRangeStartMillis");
            chapterEntry.put((Object)"title", (Object)title);
            chapterEntry.put((Object)"timeRangeStartMillis", (Object)timeRangeStartMillis);
            chapterList.add(chapterEntry);
        }
        if (chapterList.size() == 0) {
            return null;
        }
        MinimalMemoryMap ret = new MinimalMemoryMap();
        ret.put("chapters", chapterList);
        String json = new SimpleMapper().setPrettyPrintEnabled(false).objectToString((Object)ret);
        return json;
    }

    public String[] getChannelTitleFromMaps() {
        String title;
        ArrayList<String> ret = new ArrayList<String>();
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        if (map != null) {
            title = (String)JavaScriptEngineFactory.walkJson(map, "microformat/playerMicroformatRenderer/ownerChannelName");
            if (StringUtils.isNotEmpty((String)title) && !ret.contains(title)) {
                ret.add(title);
            }
            if (StringUtils.isNotEmpty((String)(title = (String)JavaScriptEngineFactory.walkJson(map, "videoDetails/author"))) && !ret.contains(title)) {
                ret.add(title);
            }
        }
        if ((map = this.getYtInitialData()) != null) {
            title = "";
            List titleRuns = (List)JavaScriptEngineFactory.walkJson(map, "contents/twoColumnWatchNextResults/results/results/contents/{}/videoSecondaryInfoRenderer/owner/videoOwnerRenderer/title/runs/");
            if (titleRuns != null) {
                for (Map titleRun : titleRuns) {
                    String text = (String)titleRun.get("text");
                    if (!StringUtils.isNotEmpty((String)text)) continue;
                    title = title + text;
                }
            }
            if (StringUtils.isNotEmpty((String)title) && !ret.contains(title)) {
                ret.add(title);
            }
        }
        if ((map = this.getYtPlayerConfig()) != null && StringUtils.isNotEmpty((String)(title = (String)JavaScriptEngineFactory.walkJson(map, "args/author"))) && !ret.contains(title)) {
            ret.add(title);
        }
        return ret.toArray(new String[0]);
    }

    public String getCategoryFromMaps() {
        String category = null;
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        if (StringUtils.isEmpty(category) && map != null) {
            category = (String)JavaScriptEngineFactory.walkJson(map, "microformat/playerMicroformatRenderer/category");
        }
        return category;
    }

    public long getPublishedDateFromMaps() {
        String publishedDate = null;
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        if (StringUtils.isEmpty(publishedDate) && map != null) {
            publishedDate = (String)JavaScriptEngineFactory.walkJson(map, "microformat/playerMicroformatRenderer/publishDate");
        }
        return this.parseDate(publishedDate);
    }

    public long getUploadedDateFromMaps() {
        String uploadedDate = null;
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        if (map != null) {
            uploadedDate = (String)JavaScriptEngineFactory.walkJson(map, "microformat/playerMicroformatRenderer/uploadDate");
        }
        map = this.getYtInitialData();
        if (StringUtils.isEmpty((String)uploadedDate) && map != null && StringUtils.isEmpty((String)(uploadedDate = (String)JavaScriptEngineFactory.walkJson(map, "contents/twoColumnWatchNextResults/results/results/contents/{}/videoPrimaryInfoRenderer/dateText/simpleText")))) {
            uploadedDate = (String)JavaScriptEngineFactory.walkJson(map, "contents/twoColumnWatchNextResults/results/results/contents/{}/videoSecondaryInfoRenderer/dateText/simpleText");
        }
        return this.parseDate(uploadedDate);
    }

    private long parseDate(String dateString) {
        if (dateString != null) {
            Date parsedDate = TimeFormatter.parseDateString((String)dateString);
            if (parsedDate != null) {
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(parsedDate.getTime());
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
                long result = c.getTimeInMillis();
                this.logger.info("Date(" + dateString + ") result " + result + " " + new Date(result));
                return result;
            }
            String date = new org.appwork.utils.Regex(dateString, "([A-Za-z]+ \\d+, \\d{4})").getMatch(0);
            if (date != null) {
                SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy", Locale.ENGLISH);
                try {
                    long result = formatter.parse(date).getTime();
                    this.logger.info("Date(" + dateString + ") result " + result + " " + new Date(result));
                    return result;
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                }
            } else if (new org.appwork.utils.Regex(dateString, "\\d{4}-\\d{2}-\\d{2}").matches()) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy'-'MM'-'dd", Locale.ENGLISH);
                try {
                    long result = formatter.parse(dateString).getTime();
                    this.logger.info("Date(" + dateString + ") result " + result + " " + new Date(result));
                    return result;
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                }
            } else {
                if (new org.appwork.utils.Regex(dateString, "\\d+\\s*(?:days?|hours?|minutes?|seconds?)").matches()) {
                    String tmpdays = new org.appwork.utils.Regex(dateString, "(\\d+)\\s+days?").getMatch(0);
                    String tmphrs = new org.appwork.utils.Regex(dateString, "(\\d+)\\s+hours?").getMatch(0);
                    String tmpmin = new org.appwork.utils.Regex(dateString, "(\\d+)\\s+minutes?").getMatch(0);
                    String tmpsec = new org.appwork.utils.Regex(dateString, "(\\d+)\\s+seconds?").getMatch(0);
                    long days = 0L;
                    long hours = 0L;
                    long minutes = 0L;
                    long seconds = 0L;
                    if (StringUtils.isNotEmpty((String)tmpdays)) {
                        days = Integer.parseInt(tmpdays);
                    }
                    if (StringUtils.isNotEmpty((String)tmphrs)) {
                        hours = Integer.parseInt(tmphrs);
                    }
                    if (StringUtils.isNotEmpty((String)tmpmin)) {
                        minutes = Integer.parseInt(tmpmin);
                    }
                    if (StringUtils.isNotEmpty((String)tmpsec)) {
                        seconds = Integer.parseInt(tmpsec);
                    }
                    long time = System.currentTimeMillis() - (days * 86400000L + hours * 3600000L + minutes * 60000L + seconds * 1000L);
                    Calendar c = Calendar.getInstance();
                    c.setTimeInMillis(time);
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    long result = c.getTimeInMillis();
                    this.logger.info("Date(" + dateString + ") result " + result + " " + new Date(result));
                    return result;
                }
                this.logger.info("Unknown date format:" + dateString);
            }
        }
        return -1L;
    }

    public String[] getVidTitleFromMaps() {
        String title;
        ArrayList<String> titles = new ArrayList<String>();
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        if (map != null && StringUtils.isNotEmpty((String)(title = (String)JavaScriptEngineFactory.walkJson(map, "videoDetails/title")))) {
            titles.add(title);
        }
        if ((map = this.getYtInitialData()) != null) {
            List titleRuns;
            title = (String)JavaScriptEngineFactory.walkJson(map, "contents/twoColumnWatchNextResults/results/results/contents/{}/videoPrimaryInfoRenderer/title/simpleText");
            if (StringUtils.isNotEmpty((String)title) && !titles.contains(title)) {
                titles.add(title);
            }
            if ((titleRuns = (List)JavaScriptEngineFactory.walkJson(map, "contents/twoColumnWatchNextResults/results/results/contents/{}/videoPrimaryInfoRenderer/title/runs/")) != null) {
                title = "";
                for (Map titleRun : titleRuns) {
                    String text = (String)titleRun.get("text");
                    if (!StringUtils.isNotEmpty((String)text)) continue;
                    title = title + text;
                }
            }
            if (StringUtils.isNotEmpty((String)title) && !titles.contains(title)) {
                titles.add(title);
            }
        }
        if ((map = this.getYtPlayerConfig()) != null && StringUtils.isNotEmpty((String)(title = (String)JavaScriptEngineFactory.walkJson(map, "args/title"))) && !titles.contains(title)) {
            titles.add(title);
        }
        return titles.toArray(new String[0]);
    }

    public String[] getUserFromMaps() {
        String author;
        ArrayList<String> ret = new ArrayList<String>();
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        if (map != null && StringUtils.isNotEmpty((String)(author = (String)JavaScriptEngineFactory.walkJson(map, "videoDetails/author"))) && !ret.contains(author)) {
            ret.add(author);
        }
        if ((map = this.getYtInitialData()) != null) {
            author = "";
            List titleRuns = (List)JavaScriptEngineFactory.walkJson(map, "contents/twoColumnWatchNextResults/results/results/contents/{}/videoSecondaryInfoRenderer/owner/videoOwnerRenderer/title/runs/");
            if (titleRuns != null) {
                for (Map titleRun : titleRuns) {
                    String text = (String)titleRun.get("text");
                    if (!StringUtils.isNotEmpty((String)text)) continue;
                    author = author + text;
                }
            }
            if (StringUtils.isNotEmpty((String)author) && !ret.contains(author)) {
                ret.add(author);
            }
        }
        return ret.toArray(new String[0]);
    }

    public String getChannelIdFromMaps() {
        String result = null;
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        if (map != null) {
            result = (String)JavaScriptEngineFactory.walkJson(map, "videoDetails/channelId");
        }
        map = this.getYtInitialData();
        if (StringUtils.isEmpty((String)result) && map != null) {
            result = (String)JavaScriptEngineFactory.walkJson(map, "contents/twoColumnWatchNextResults/results/results/contents/{}/videoSecondaryInfoRenderer/owner/videoOwnerRenderer/navigationEndpoint/browseEndpoint/browseId");
        }
        map = this.getYtPlayerConfig();
        if (StringUtils.isEmpty((String)result) && map != null) {
            result = (String)JavaScriptEngineFactory.walkJson(map, "args/ucid");
        }
        return result;
    }

    protected void handleContentWarning(Browser ibr) throws Exception {
        Form[] forms;
        String vc = ibr.getRegex("\"([^\"]+verify_controversy\\?next_url[^\"]+)\"").getMatch(0);
        if (vc != null) {
            vc = (String)JSonStorage.restoreFromString((String)("\"" + vc + "\""), (TypeRef)TypeRef.STRING);
            ibr.getPage(vc);
        }
        if ((forms = ibr.getForms()) != null) {
            for (Form form : forms) {
                if (form.getAction() != null && form.getAction().contains("verify_age")) {
                    this.logger.info("Verify Age");
                    ibr.submitForm(form);
                    break;
                }
                if (form.getAction() == null || !form.getAction().contains("verify_controversy")) continue;
                this.logger.info("Verify Controversy");
                ibr.submitForm(form);
                break;
            }
        }
    }

    public void loadVideo(YoutubeClipData vid) throws Exception {
        this.refreshVideo(vid);
    }

    protected boolean addYoutubeStreamData(Map<YoutubeITAG, StreamCollection> map, YoutubeStreamData match) {
        if (!this.isSegmentLoadingAllowed(match)) {
            this.logger.info("itag not allowed(segments):" + match.toString());
            return false;
        }
        if (!this.cfg.isExternMultimediaToolUsageEnabled() && match.getItag().name().contains("DASH_")) {
            this.logger.info("itag not allowed(dash):" + match.toString());
            return false;
        }
        this.logger.info("add(" + this.vid.videoID + "/" + this.getPlayerID(this.html5PlayerJs) + "):" + match.toString());
        StreamCollection lst = map.get((Object)match.getItag());
        if (lst == null) {
            lst = new StreamCollection();
            map.put(match.getItag(), lst);
        }
        lst.add(match);
        return true;
    }

    public Request getPage(Browser br, String url) throws Exception {
        GetRequest getRequest = br.createGetRequest(url);
        return this.getPage(br, (Request)getRequest);
    }

    protected boolean isAPIPrefered(Browser br) {
        return true;
    }

    public Request getPage(Browser br, Request request) throws Exception {
        if (this.br != br) {
            this.setBr(br);
        }
        br.setCookie("youtube.com", "hideBrowserUpgradeBox", "true");
        br.getPage(request);
        if (br.getURL().matches(".*/supported_browsers\\?next.+")) {
            br.getPage(request.cloneRequest());
            if (br.getURL().matches(".*/supported_browsers\\?next.+")) {
                throw new PluginException(0x400000);
            }
        }
        if (this.handleConsent(br)) {
            br.getPage(request.cloneRequest());
            if (this.handleConsent(br)) {
                throw new PluginException(0x400000);
            }
        }
        if (br.getRequest().getHttpConnection().getResponseCode() == 429) {
            throw new PluginException(16, "Too Many Requests", 600000L);
        }
        return br.getRequest();
    }

    public void setConsentCookie(Browser browser, String id) {
        String host;
        if (StringUtils.isEmpty((String)id)) {
            id = String.valueOf(new Random().nextInt(899) + 100);
        }
        if ((host = this.br.getHost()) == null) {
            host = "youtube.com";
        }
        this.br.setCookie(host, "SOCS", "CAI");
    }

    public boolean isConsentCookieRequired() {
        return CONSENT_COOKIE_REQUIRED;
    }

    protected boolean handleConsent(Browser br) throws Exception {
        String consentRequired = br.getCookie(br.getHost(), "CONSENT");
        String consentCookie = br.getCookie(br.getHost(), "SOCS");
        if (consentRequired != null || consentCookie != null) {
            if (!StringUtils.startsWithCaseInsensitive((String)consentCookie, (String)"CAA")) {
                return false;
            }
            if (StringUtils.startsWithCaseInsensitive((String)consentRequired, (String)"YES")) {
                return false;
            }
            CONSENT_COOKIE_REQUIRED = true;
            String id = new org.appwork.utils.Regex(consentRequired, "PENDING\\+(.+)").getMatch(0);
            this.setConsentCookie(br, id);
            return true;
        }
        return false;
    }

    public void refreshVideo(YoutubeClipData vid) throws Exception {
        List<YoutubeStreamData> covers;
        List<YoutubeStreamData> thumbnails;
        this.account = this.login(this.logger, false);
        this.vid = vid;
        HashMap<YoutubeITAG, StreamCollection> ret = new HashMap<YoutubeITAG, StreamCollection>();
        YoutubeConfig cfg = PluginJsonConfig.get(YoutubeConfig.class);
        this.br.setFollowRedirects(true);
        this.prepareBrowser(this.br);
        this.br.addAllowedResponseCodes(new int[]{429});
        this.getPage(this.br, this.base + "/watch?bpctr=9999999999&has_verified=1&hl=en&v=" + vid.videoID + "&gl=US");
        this.parse(this.br);
        vid.approxThreedLayout = this.br.getRegex("\"approx_threed_layout\"\\s*\\:\\s*\"([^\"]*)").getMatch(0);
        String[][] keyWordsGrid = this.br.getRegex("<meta\\s+property=\"([^\"]*)\"\\s+content=\"yt3d\\:([^\"]+)=([^\"]+)\">").getMatches();
        vid.keywords3D = new HashMap();
        if (keyWordsGrid != null) {
            for (String[] keyValue : keyWordsGrid) {
                vid.keywords3D.put(keyValue[1], keyValue[2]);
            }
        }
        String keywords = this.br.getRegex("<meta name=\"keywords\" content=\"([^\"]*)").getMatch(0);
        vid.keywords = new HashSet();
        if (keywords != null) {
            for (String s : keywords.split("[,]+")) {
                vid.keywords.add(s);
            }
        } else {
            List kws = (List)JavaScriptEngineFactory.walkJson(this.getYtInitialPlayerResponse(), "videoDetails/keywords");
            if (kws != null) {
                for (String s : kws) {
                    vid.keywords.add(s);
                }
            }
        }
        this.handleRentalVideos();
        this.html5PlayerJs = this.getHtml5PlayerJs();
        Map<String, Object> map = this.getYtInitialPlayerResponse();
        this.fmtMaps = new LinkedHashSet<StreamMap>();
        this.subtitleUrls = new LinkedHashSet<String>();
        this.mpdUrls = new LinkedHashSet();
        String unavailableStatus = map != null ? (String)JavaScriptEngineFactory.walkJson(map, "playabilityStatus/status") : null;
        String unavailableReason = this.getUnavailableReason(unavailableStatus);
        vid.ageCheck = this.br.containsHTML("\"status\"\\s*:\\s*\"LOGIN_REQUIRED\"");
        this.logger.info("Login required:" + vid.ageCheck + "|Reason:" + unavailableReason);
        this.handleContentWarning(this.br);
        int collected = 0;
        if (this.isAPIPrefered(this.br) || vid.ageCheck) {
            collected = this.collectMapsFromAPIResponse(this.br);
            this.logger.info("found collectMapsFromAPIResponse(" + vid.videoID + "):" + collected);
        }
        if (collected <= 0) {
            collected = this.collectMapsFromPlayerResponse(map, this.br.getURL());
            this.logger.info("found collectMapsFromPlayerResponse(" + vid.videoID + "):" + collected);
            this.collectMapsFormHtmlSource(this.br.getRequest().getHtmlCode(), "base");
        }
        this.extractData(vid);
        if (unavailableReason != null) {
            if (unavailableReason.contains("This video is private")) {
                this.logger.warning("Abort Error:" + unavailableReason);
                vid.error = unavailableReason;
                return;
            }
            if (unavailableReason.startsWith("This video does not exist")) {
                this.logger.warning("Abort Error:" + unavailableReason);
                vid.error = unavailableReason;
                return;
            }
            if (unavailableReason.startsWith("This video has been removed")) {
                this.logger.warning("Abort Error:" + unavailableReason);
                vid.error = unavailableReason;
                return;
            }
            if (unavailableReason.contains("account associated with this video has been")) {
                this.logger.warning("Abort Error:" + unavailableReason);
                vid.error = unavailableReason;
                return;
            }
            if ("This live event has ended.".equalsIgnoreCase(unavailableReason)) {
                this.logger.warning("Abort Error:" + unavailableReason);
                vid.error = unavailableReason;
                return;
            }
            if (unavailableReason.contains("This video is no longer available due to a copyright claim")) {
                vid.title = new org.appwork.utils.Regex(unavailableReason, "\"(.*?(?:\\.\\.\\.)?)\"\\n").getMatch(0);
                this.logger.warning("Abort Error:" + unavailableReason);
                vid.error = "This video is no longer available due to a copyright claim";
                return;
            }
            if (unavailableReason.startsWith("This video contains content from ") && unavailableReason.contains("who has blocked it in your country on copyright grounds")) {
                String error = "Geo Blocked due to copyright grounds";
                this.logger.warning("Abort Error:" + unavailableReason);
                vid.error = "Geo Blocked due to copyright grounds";
                return;
            }
            if (unavailableReason.equals("This video is unavailable.") || unavailableReason.equals("This video is not available.")) {
                this.logger.warning("Abort Error:" + unavailableReason);
                vid.error = unavailableReason;
                return;
            }
            this.logger.warning("Continue Error:" + unavailableReason);
        }
        this.doFeedScan();
        this.doUserAPIScan();
        ArrayList<YoutubeStreamData> incomplete = new ArrayList<YoutubeStreamData>();
        for (StreamMap streamMap : this.fmtMaps) {
            if (streamMap.streamData != null) {
                try {
                    YoutubeStreamData match = streamMap.streamData;
                    if (this.looksIncomplete(match)) {
                        incomplete.add(match);
                        continue;
                    }
                    this.addYoutubeStreamData(ret, match);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
                continue;
            }
            if (!StringUtils.isNotEmpty((String)streamMap.mapData)) continue;
            for (String line : streamMap.mapData.split(",")) {
                try {
                    YoutubeStreamData match = this.parseLine(Request.parseQuery((String)line), streamMap);
                    if (this.looksIncomplete(match)) {
                        incomplete.add(match);
                        continue;
                    }
                    this.addYoutubeStreamData(ret, match);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
        }
        if (incomplete.size() > 0) {
            for (YoutubeStreamData youtubeStreamData : incomplete) {
                try {
                    if (ret.containsKey((Object)youtubeStreamData.getItag())) continue;
                    this.addYoutubeStreamData(ret, youtubeStreamData);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
        }
        if (!cfg.isExternMultimediaToolUsageEnabled()) {
            this.logger.info("ExternMultimediaToolUsageEnabled:disabled");
        } else {
            for (StreamMap streamMap : this.mpdUrls) {
                try {
                    if (StringUtils.isEmpty((String)streamMap.mapData)) continue;
                    Browser clone = this.br.cloneBrowser();
                    clone.setFollowRedirects(true);
                    String newv = streamMap.mapData;
                    String scrambledSign = new org.appwork.utils.Regex(streamMap.mapData, "/s/(.*?)/").getMatch(0);
                    if (StringUtils.isNotEmpty((String)scrambledSign)) {
                        scrambledSign = URLDecoder.decode(scrambledSign, "UTF-8");
                        String sign = this.descrambleSignature(scrambledSign);
                        newv = streamMap.mapData.replaceAll("/s/(.*?)/", "/signature/" + sign + "/");
                    }
                    clone.getPage(newv);
                    String xml = clone.getRequest().getHtmlCode();
                    if (!clone.getHttpConnection().isOK()) {
                        this.logger.severe("Bad Request: ");
                        this.logger.severe(clone.getHttpConnection() + "");
                        continue;
                    }
                    if (xml.trim().startsWith("#EXTM3U")) {
                        List<HlsContainer> containers = HlsContainer.getHlsQualities(clone);
                        for (HlsContainer c : containers) {
                            String[][] params = new org.appwork.utils.Regex(c.getDownloadurl(), "/([^/]+)/([^/]+)").getMatches();
                            UrlQuery query = Request.parseQuery((String)c.getDownloadurl());
                            if (params != null) {
                                for (int i = 1; i < params.length; ++i) {
                                    query.addAndReplace(params[i][0], Encoding.htmlDecode((String)params[i][1]));
                                }
                            }
                            query.addIfNoAvailable("codecs", c.getCodecs());
                            query.addIfNoAvailable("type", query.get("codecs") + "-" + query.get("mime"));
                            query.addIfNoAvailable("fps", query.get("frameRate"));
                            query.addIfNoAvailable("width", c.getWidth() + "");
                            query.addIfNoAvailable("height", c.getHeight() + "");
                            if (query.containsKey("width") && query.containsKey("height")) {
                                query.addIfNoAvailable("size", query.get("width") + "x" + query.get("height"));
                            }
                            String fps = query.get("fps");
                            int projectionType = -1;
                            try {
                                String v = query.get("projection_type");
                                projectionType = v == null ? -1 : Integer.parseInt(v);
                            }
                            catch (Throwable e) {
                                this.logger.log(e);
                            }
                            String itagID = query.get("itag");
                            YoutubeITAG itag = YoutubeITAG.get(Integer.parseInt(itagID), c.getWidth(), c.getHeight(), StringUtils.isEmpty((String)fps) ? -1 : Integer.parseInt(fps), query.getDecoded("type"), query, vid.datePublished);
                            if (itag == null) {
                                this.logger.info("Unknown Line: " + query);
                                this.logger.info(query + "");
                                try {
                                    if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE || Application.isJared(null)) continue;
                                    Dialog.getInstance().showMessageDialog("Unknown ITag found: " + itagID + "\r\nAsk Coalado to Update the ItagHelper for Video ID: " + vid.videoID);
                                }
                                catch (Exception e) {
                                    this.logger.log((Throwable)e);
                                }
                                continue;
                            }
                            if (Boolean.FALSE.equals(this.isSupported(itag))) {
                                this.logger.info("FFmpeg support for Itag'" + (Object)((Object)itag) + "' is missing");
                                continue;
                            }
                            YoutubeStreamData match = new YoutubeStreamData(streamMap.src, vid, c.getDownloadurl(), itag, query);
                            try {
                                match.setHeight(Integer.parseInt(query.get("height")));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                match.setWidth(Integer.parseInt(query.get("width")));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                match.setFps(query.get("fps"));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.addYoutubeStreamData(ret, match);
                        }
                        continue;
                    }
                    List<YoutubeStreamData> datas = this.parseDashManifest(streamMap.src, this.br, this.br.getURL(newv).toString());
                    for (YoutubeStreamData match : datas) {
                        this.addYoutubeStreamData(ret, match);
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Browser.BrowserException e) {
                    this.logger.log((Throwable)e);
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
        }
        if (unavailableReason != null) {
            if (ret.size() == 0) {
                this.logger.warning("Abort Error:" + unavailableReason);
                vid.error = unavailableReason;
                return;
            }
            this.logger.warning("Ignore Error:" + unavailableReason);
        }
        if ((thumbnails = this.crawlThumbnailData(vid.videoID, true)) != null) {
            for (YoutubeStreamData thumbnail : thumbnails) {
                if (thumbnail.getClip() == null) {
                    thumbnail.setClip(vid);
                }
                this.addYoutubeStreamData(ret, thumbnail);
            }
        }
        String string = this.getPlaylistID();
        if (!CFG_YOUTUBE.CFG.getBlacklistedGroups().contains((Object)VariantGroup.IMAGE_PLAYLIST_COVER) && string != null && (covers = this.crawlCoverData(string, true)) != null) {
            for (YoutubeStreamData cover : covers) {
                if (cover.getClip() == null) {
                    cover.setClip(vid);
                }
                this.addYoutubeStreamData(ret, cover);
            }
        }
        for (Map.Entry es : ret.entrySet()) {
            Collections.sort((List)es.getValue(), new Comparator<YoutubeStreamData>(){

                @Override
                public int compare(YoutubeStreamData o1, YoutubeStreamData o2) {
                    int ret = CompareUtils.compareBoolean((boolean)o2.getUrl().contains("ei="), (boolean)o1.getUrl().contains("ei="));
                    return ret;
                }
            });
        }
        vid.streams = ret;
        vid.subtitles = this.loadSubtitles();
    }

    protected Request buildAPI_TV_Request(Browser br) throws Exception {
        int clientNameID;
        if (!API_TV_ENABLED) {
            this.logger.info("buildAPI_TV_Request:disabled");
            return null;
        }
        LinkedHashMap<String, Object> post = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> client = new LinkedHashMap<String, Object>();
        if (this.vid.ageCheck) {
            client.put("clientName", "TVHTML5_SIMPLY_EMBEDDED_PLAYER");
            client.put("clientVersion", "2.0");
            clientNameID = 85;
        } else {
            client.put("clientName", "TVHTML5");
            client.put("clientVersion", "7.20250312.16.00");
            client.put("userAgent", "Mozilla/5.0 (ChromiumStylePlatform) Cobalt/Version");
            clientNameID = 7;
        }
        client.put("hl", "en");
        client.put("timeZone", "UTC");
        client.put("utcOffsetMinutes", 0);
        LinkedHashMap<String, LinkedHashMap<String, Object>> context = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        context.put("client", client);
        post.put("context", context);
        post.put("videoId", this.vid.videoID);
        LinkedHashMap<String, Object> contentPlaybackContext = new LinkedHashMap<String, Object>();
        contentPlaybackContext.put("html5Preferences", "HTML5_PREF_WANTS");
        String sts = this.getSts();
        if (sts == null) {
            return null;
        }
        contentPlaybackContext.put("signatureTimestamp", Integer.parseInt(sts));
        LinkedHashMap<String, LinkedHashMap<String, Object>> playbackContext = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        playbackContext.put("contentPlaybackContext", contentPlaybackContext);
        post.put("playbackContext", playbackContext);
        post.put("contentCheckOk", true);
        post.put("racyCheckOk", true);
        PostRequest request = br.createJSonPostRequest("https://www.youtube.com/youtubei/v1/player?prettyPrint=false", JSonStorage.serializeToJson(post));
        if (client.containsKey("userAgent")) {
            request.getHeaders().put("User-Agent", (String)client.get("userAgent"));
        }
        request.getHeaders().put("X-Youtube-Client-Name", Integer.toString(clientNameID));
        request.getHeaders().put("X-Youtube-Client-Version", (String)client.get("clientVersion"));
        String domain = "https://www.youtube.com";
        request.getHeaders().put("Origin", "https://www.youtube.com");
        Account account = this.getAccountLoggedIn();
        if (account != null) {
            String sapisidhash = GoogleHelper.getSAPISidHash(br, "https://www.youtube.com");
            if (sapisidhash != null) {
                request.getHeaders().put("Authorization", "SAPISIDHASH " + sapisidhash);
            }
            request.getHeaders().put("X-Goog-Authuser", "0");
        } else {
            request.getHeaders().remove("Authorization");
        }
        String visitorData = br.getRegex("\"visitor_data\"\\s*,\\s*\"value\"\\s*:\\s*\"(.*?)\"").getMatch(0);
        if (visitorData == null) {
            visitorData = br.getRegex("\"VISITOR_DATA\"\\s*:\\s*\"(.*?)\"").getMatch(0);
        }
        if (visitorData != null) {
            request.getHeaders().put("X-Goog-Visitor-Id", visitorData);
        }
        return request;
    }

    protected int collectMapsFromAPIResponse(Browser br) throws InterruptedException, Exception {
        int ret;
        block6: {
            if (!API_TV_ENABLED) {
                this.logger.info("collectMapsFromAPIResponse:disabled");
                return -1;
            }
            ret = 0;
            try {
                Browser brc = br.cloneBrowser();
                Request request = this.buildAPI_TV_Request(brc);
                if (request == null) break block6;
                brc.getPage(request);
                if (brc.getRegex("\"status\"\\s*:\\s*\"LOGIN_REQUIRED\"").patternFind()) break block6;
                if (request.getHttpConnection().getResponseCode() == 200) {
                    Map response = (Map)JSonStorage.restoreFromString((String)request.getHtmlCode(), (TypeRef)TypeRef.MAP);
                    if ((ret += this.collectMapsFromPlayerResponse(response, "api.tv")) > 0) {
                        return ret;
                    }
                    break block6;
                }
                throw new Exception("auto disable api due to unexpected responseCode:" + request.getHttpConnection().getResponseCode());
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                API_TV_ENABLED = false;
                this.logger.log((Throwable)e);
            }
        }
        return ret;
    }

    private boolean looksIncomplete(YoutubeStreamData data) {
        if (data.getSegments() == null && data.getContentLength() < 0L && data.estimatedContentLength() < 0L) {
            boolean isLive = StringUtils.containsIgnoreCase((String)data.getUrl(), (String)"live=1");
            this.logger.info("looksIncomplete:" + data + "|live:" + isLive);
            return true;
        }
        return false;
    }

    private String getSts() throws Exception {
        String player = this.ensurePlayerSource();
        String sts = new org.appwork.utils.Regex(player, "sts\\s*(?::|=)\\s*(?:\")(\\d+)").getMatch(0);
        return sts;
    }

    private String getHtml5PlayerJs() throws IOException {
        Map<String, Object> ytPlayerConfig = this.getYtPlayerConfig();
        String ret = (String)JavaScriptEngineFactory.walkJson(ytPlayerConfig, "assets/js");
        if (ret == null) {
            ret = (String)JavaScriptEngineFactory.walkJson(ytPlayerConfig, "jsUrl");
        }
        if (ret != null) {
            ret = ret.replace("\\/", "/");
            return this.br.getURL(ret).toExternalForm();
        }
        ret = this.br.getMatch("\"movie_player\"\\s*,\\s*\"jsUrl\"\\s*:\\s*\"([^\"<>]*?/base.js)\"[^<>]*n");
        if (ret == null && (ret = this.br.getMatch("src\\s*=\\s*\"((https?:)?//[^\"<>]*?/base.js)\"[^<>]*name=\"player\\\\?/base")) == null) {
            ret = this.br.getMatch("src\\s*=\\s*\"([^\"<>]*?/base.js)\"[^<>]*n");
        }
        if (ret != null) {
            return this.br.getURL(ret).toExternalForm();
        }
        return null;
    }

    private String getUnavailableReason(String unavailableStatus) {
        String result = null;
        if (StringUtils.isEmpty((String)unavailableStatus) || "OK".equals(unavailableStatus)) {
            return null;
        }
        result = "LOGIN_REQUIRED".equals(unavailableStatus) ? (String)JavaScriptEngineFactory.walkJson(this.getYtInitialPlayerResponse(), "playabilityStatus/errorScreen/playerErrorMessageRenderer/reason/simpleText") : (String)JavaScriptEngineFactory.walkJson(this.getYtInitialPlayerResponse(), "playabilityStatus/reason");
        return result;
    }

    private boolean isSegmentLoadingAllowed(YoutubeStreamData match) {
        if (match == null) {
            return false;
        }
        if (!this.cfg.isSegmentLoadingEnabled()) {
            if (match.getSegments() != null && match.getSegments().length > 0) {
                return false;
            }
            if (match.getUrl() != null && match.getUrl().contains("hls_playlist")) {
                return false;
            }
        }
        return true;
    }

    private DocumentBuilder createXMLParser() throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = XML.newSecureFactory();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        docBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return null;
            }
        });
        docBuilder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                YoutubeHelper.this.logger.log((Throwable)exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                YoutubeHelper.this.logger.log((Throwable)exception);
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                YoutubeHelper.this.logger.log((Throwable)exception);
            }
        });
        return docBuilder;
    }

    private void collectFmtMap(String htmlCode, String regex, String src) {
        String map = new org.appwork.utils.Regex(htmlCode, regex).getMatch(0);
        if (map != null && StringUtils.isNotEmpty((String)(map = (String)JSonStorage.restoreFromString((String)map, (TypeRef)TypeRef.STRING))) && !this.fmtMaps.contains(map)) {
            this.fmtMaps.add(new StreamMap(map, src));
        }
    }

    private void collectMapsFormHtmlSource(String html, String src) {
        if (this.subtitleUrls.size() == 0) {
            String captionTracks = new org.appwork.utils.Regex(html, "captionTracks\\\\\"\\s*:(\\[.*?\\])\\s*,").getMatch(0);
            if (captionTracks != null) {
                String decoded = captionTracks.replaceAll("\\\\u", "\\u");
                decoded = Encoding.unicodeDecode((String)decoded).replaceAll("\\\\", "");
                this.subtitleUrls.add(decoded);
            }
            this.collectSubtitleUrls(html, "['\"]TTS_URL['\"]\\s*:\\s*(['\"][^'\"]+['\"])");
        }
        this.collectFmtMap(html, REGEX_FMT_MAP_FROM_JSPLAYER_SETUP, "fmtMapJSPlayer." + src);
        this.collectFmtMap(html, REGEX_ADAPTIVE_FMTS_FROM_JSPLAYER_SETUP, "adaptiveFmtsJSPlayer." + src);
        this.collectMpdMap(html, REGEX_DASHMPD_FROM_JSPLAYER_SETUP, "dashMpdJSPlayer." + src);
        this.collectMpdMap(html, REGEX_HLSMPD_FROM_JSPLAYER_SETUP, "hlsJSPlayer." + src);
    }

    private boolean collectSubtitleUrls(String html, String pattern) {
        String json = new org.appwork.utils.Regex(html, pattern).getMatch(0);
        if (json != null && (json = (String)JSonStorage.restoreFromString((String)json, (TypeRef)TypeRef.STRING)) != null) {
            this.subtitleUrls.add(json);
            return true;
        }
        return false;
    }

    public YoutubeStreamData convert(UrlQuery query, String src) {
        HashMap<String, Object> qualityMap = new HashMap<String, Object>();
        for (Map.Entry es : query.toMap(true).entrySet()) {
            qualityMap.put((String)es.getKey(), es.getValue());
        }
        return this.convert(qualityMap, src);
    }

    public YoutubeStreamData convert(Map<String, Object> entry, String src) {
        YoutubeITAG itag;
        if (entry == null) {
            return null;
        }
        if (entry.containsKey("drm_families") || entry.containsKey("drmFamilies")) {
            this.logger.info("DRM?:" + JSonStorage.toString(entry));
            return null;
        }
        String url = (String)entry.get("url");
        int throttle = -1;
        try {
            if (StringUtils.isEmpty((String)url)) {
                UrlQuery query;
                String queryURL;
                String cipher = (String)entry.get("cipher");
                if (cipher == null) {
                    cipher = (String)entry.get("signatureCipher");
                }
                if (StringUtils.isEmpty((String)(queryURL = (query = UrlQuery.parse((String)cipher)).get("url")))) {
                    throw new PluginException(0x400000);
                }
                if ((queryURL = URLDecoder.decode(queryURL, "UTF-8")).contains("&n=")) {
                    throttle = 0;
                    String value = new org.appwork.utils.Regex(queryURL, "&n=(.*?)(&|$)").getMatch(0);
                    String result = this.descrambleThrottle(value);
                    if (result != null && !result.equals(value)) {
                        queryURL = queryURL.replaceFirst("(&n=" + value + ")", "&n=" + result);
                        throttle = 1;
                    }
                }
                if (query.containsKey("signature")) {
                    url = queryURL + "&signature=" + query.get("signature");
                } else if (query.containsKey("sig")) {
                    url = queryURL + "&signature=" + query.get("sig");
                } else if (query.containsKey("s")) {
                    String encrypted_sig = query.get("s");
                    encrypted_sig = URLDecoder.decode(encrypted_sig, "UTF-8");
                    String signature = this.descrambleSignature(encrypted_sig);
                    url = query.containsKey("sp") ? queryURL + "&" + query.get("sp") + "=" + Encoding.urlEncode((String)signature) : queryURL + "&signature=" + Encoding.urlEncode((String)signature);
                }
            } else if (url.contains("&n=")) {
                throttle = 0;
                String value = new org.appwork.utils.Regex(url, "&n=(.*?)(&|$)").getMatch(0);
                String result = this.descrambleThrottle(value);
                if (result != null && !result.equals(value)) {
                    url = url.replaceFirst("(&n=" + value + ")", "&n=" + result);
                    throttle = 1;
                }
            }
        }
        catch (PluginException e) {
            this.logger.log((Throwable)e);
            return null;
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            return null;
        }
        if (StringUtils.isEmpty((String)url)) {
            this.logger.info("URL?:" + JSonStorage.toString(entry));
            return null;
        }
        String type = (String)entry.get("type");
        if (StringUtils.equalsIgnoreCase((String)"FORMAT_STREAM_TYPE_OTF", (String)type)) {
            this.logger.info("UNSUPPORTED OTF:" + JSonStorage.toString(entry));
            return null;
        }
        Long width = JavaScriptEngineFactory.toLong(entry.get("width"), -1L);
        Long height = JavaScriptEngineFactory.toLong(entry.get("height"), -1L);
        Long contentLength = JavaScriptEngineFactory.toLong(entry.get("contentLength"), -1L);
        Long bitrate = JavaScriptEngineFactory.toLong(entry.get("bitrate"), -1L);
        Long averageBitrate = JavaScriptEngineFactory.toLong(entry.get("averageBitrate"), -1L);
        Long approxDurationMs = JavaScriptEngineFactory.toLong(entry.get("approxDurationMs"), -1L);
        Long itagID = JavaScriptEngineFactory.toLong(entry.get("itag"), -1L);
        Long fps = JavaScriptEngineFactory.toLong(entry.get("fps"), -1L);
        String stereoLayout = (String)entry.get("stereoLayout");
        String projectionType = (String)entry.get("projectionType");
        Boolean isDrc = (Boolean)entry.get("isDrc");
        long datePublished = -1L;
        if (this.vid != null) {
            datePublished = this.vid.datePublished;
        }
        if ((itag = YoutubeITAG.get(itagID.intValue(), width.intValue(), height.intValue(), fps.intValue(), null, null, datePublished)) == null) {
            this.logger.info("UNSUPPORTED/UNKNOWN?:" + JSonStorage.toString(entry));
            try {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && !Application.isJared(null)) {
                    Dialog.getInstance().showMessageDialog("Unknown ITag found: " + itagID + "\r\nAsk Coalado to Update the ItagHelper for Video ID: " + this.vid.videoID);
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            return null;
        }
        if (Boolean.FALSE.equals(this.isSupported(itag))) {
            this.logger.info("FFmpeg support for Itag'" + (Object)((Object)itag) + "' is missing");
            return null;
        }
        YoutubeStreamData ret = new YoutubeStreamData(src, this.vid, url, itag, null);
        Map audioTrack = (Map)entry.get("audioTrack");
        if (audioTrack != null) {
            ret.setLngId((String)audioTrack.get("id"));
        }
        ret.setThrottle(throttle);
        if (height > 0L) {
            ret.setHeight(height.intValue());
        }
        if (width > 0L) {
            ret.setWidth(width.intValue());
        }
        if (fps > 0L) {
            ret.setFps(fps.toString());
        }
        if (contentLength > 0L) {
            ret.setContentLength(contentLength);
        }
        if (bitrate > 0L) {
            ret.setBitrate(bitrate.intValue());
        }
        if (averageBitrate > 0L) {
            ret.setAverageBitrate(averageBitrate.intValue());
        }
        if (isDrc != null) {
            ret.setDrc(isDrc);
        }
        if (approxDurationMs > 0L) {
            ret.setApproxDurationMs(approxDurationMs);
        }
        if (StringUtils.equalsIgnoreCase((String)projectionType, (String)"RECTANGULAR")) {
            ret.setProjectionType(0);
        } else if (StringUtils.equalsIgnoreCase((String)projectionType, (String)"MESH")) {
            ret.setProjectionType(2);
        } else if (StringUtils.equalsIgnoreCase((String)projectionType, (String)"EQUIRECTANGULAR")) {
            ret.setProjectionType(2);
        }
        return ret;
    }

    private int collectMapsFromPlayerResponse(Map<String, Object> map, String src) {
        String url;
        List formats;
        String dataSrc;
        List adaptiveFormats;
        Map streamingData;
        if (map == null) {
            return 0;
        }
        int ret = 0;
        List captionTracks = (List)JavaScriptEngineFactory.walkJson(map, "captions/playerCaptionsTracklistRenderer/captionTracks");
        if (captionTracks != null) {
            this.subtitleUrls.add(JSonStorage.toString((Object)captionTracks));
        }
        if ((streamingData = (Map)map.get("streamingData")) != null && streamingData.containsKey("adaptiveFormats") && (adaptiveFormats = (List)streamingData.get("adaptiveFormats")) != null && adaptiveFormats.size() > 0) {
            dataSrc = "new_adaptive_fmts_map." + src;
            LinkedHashMap dataMap = new LinkedHashMap();
            for (Map map2 : adaptiveFormats) {
                YoutubeStreamData data = this.convert(map2, dataSrc);
                if (data == null) continue;
                ArrayList<YoutubeStreamData> list = (ArrayList<YoutubeStreamData>)dataMap.get((Object)data.getItag());
                if (list == null) {
                    list = new ArrayList<YoutubeStreamData>();
                    dataMap.put(data.getItag(), list);
                }
                list.add(data);
            }
            for (Map.Entry entry : dataMap.entrySet()) {
                if (((YoutubeITAG)((Object)entry.getKey())).getRawContainer() == StreamContainer.DASH_AUDIO) {
                    boolean hasLngId = false;
                    for (YoutubeStreamData data : (List)entry.getValue()) {
                        if (data.getLngId() == null) continue;
                        hasLngId = true;
                        break;
                    }
                    if (hasLngId) {
                        Iterator it = ((List)entry.getValue()).iterator();
                        while (it.hasNext()) {
                            YoutubeStreamData next = (YoutubeStreamData)it.next();
                            if (next.getLngId() != null) continue;
                            it.remove();
                        }
                    }
                }
                for (YoutubeStreamData data : (List)entry.getValue()) {
                    if (!this.fmtMaps.add(new StreamMap(data, dataSrc))) continue;
                    ++ret;
                }
            }
        }
        if (streamingData != null && streamingData.containsKey("formats") && (formats = (List)streamingData.get("formats")) != null && formats.size() > 0) {
            dataSrc = "new_fmt_stream_map." + src;
            for (Map format : formats) {
                YoutubeStreamData youtubeStreamData = this.convert(format, dataSrc);
                if (youtubeStreamData == null || !this.fmtMaps.add(new StreamMap(youtubeStreamData, dataSrc))) continue;
                ++ret;
            }
        }
        if (streamingData != null && streamingData.containsKey("dashManifestUrl") && StringUtils.isNotEmpty((String)(url = (String)streamingData.get("dashManifestUrl")))) {
            try {
                dataSrc = "new_dashManifestUrl." + src;
                List<YoutubeStreamData> datas = this.parseDashManifest(dataSrc, this.br, this.br.getURL(url).toString());
                for (YoutubeStreamData youtubeStreamData : datas) {
                    if (!this.fmtMaps.add(new StreamMap(youtubeStreamData, dataSrc))) continue;
                    ++ret;
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
        }
        return ret;
    }

    private List<YoutubeStreamData> parseDashManifest(String src, Browser br, String dashManifestURL) throws Exception {
        Browser brc = br.cloneBrowser();
        brc.setFollowRedirects(true);
        this.getPage(brc, dashManifestURL);
        if (brc.getHttpConnection().getResponseCode() != 200 || !brc.containsHTML("<?xml")) {
            throw new Exception("no xml response");
        }
        ArrayList<YoutubeStreamData> ret = new ArrayList<YoutubeStreamData>();
        DocumentBuilder docBuilder = this.createXMLParser();
        Document doc = docBuilder.parse(new InputSource(new StringReader(brc.toString())));
        NodeList representations = doc.getElementsByTagName("Representation");
        for (int r = 0; r < representations.getLength(); ++r) {
            Element representation = (Element)representations.item(r);
            Long itagID = JavaScriptEngineFactory.toLong(representation.getAttribute("id"), -1L);
            Long width = JavaScriptEngineFactory.toLong(representation.getAttribute("width"), -1L);
            Long height = JavaScriptEngineFactory.toLong(representation.getAttribute("height"), -1L);
            Long bitrate = JavaScriptEngineFactory.toLong(representation.getAttribute("bandwidth"), -1L);
            Long fps = JavaScriptEngineFactory.toLong(representation.getAttribute("frameRate"), -1L);
            Element baseUrlElement = (Element)representation.getElementsByTagName("BaseURL").item(0);
            String baseURL = baseUrlElement.getTextContent();
            YoutubeITAG itag = YoutubeITAG.get(itagID.intValue(), width.intValue(), height.intValue(), fps.intValue(), null, null, this.vid != null ? Long.valueOf(this.vid.datePublished) : null);
            if (itag == null) {
                this.logger.info("UNSUPPORTED/UNKNOWN?");
                try {
                    if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE || Application.isJared(null)) continue;
                    Dialog.getInstance().showMessageDialog("Unknown ITag found: " + itagID + "\r\nAsk Coalado to Update the ItagHelper for Video ID: " + this.vid.videoID);
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                }
                continue;
            }
            if (Boolean.FALSE.equals(this.isSupported(itag))) {
                this.logger.info("FFmpeg support for Itag'" + (Object)((Object)itag) + "' is missing");
                continue;
            }
            ArrayList<String> segments = new ArrayList<String>();
            NodeList segmentList = representation.getElementsByTagName("SegmentList").item(0).getChildNodes();
            long approxDurationMs = 0L;
            long estimatedContentLength = 0L;
            for (int i = 0; i < segmentList.getLength(); ++i) {
                long sqRange;
                Element segment = (Element)segmentList.item(i);
                String url = null;
                if ("Initialization".equals(segment.getNodeName())) {
                    url = segment.getAttribute("sourceURL");
                    if (StringUtils.isNotEmpty((String)url)) {
                        segments.add(url);
                    }
                } else if ("SegmentURL".equals(segment.getNodeName()) && StringUtils.isNotEmpty((String)(url = segment.getAttribute("media")))) {
                    segments.add(url);
                }
                if (url == null) continue;
                long sqDuration = this.parseMPDDuration(url);
                if (sqDuration > 0L) {
                    approxDurationMs += sqDuration;
                }
                if ((sqRange = this.parseMPDRange(url)) <= 0L) continue;
                estimatedContentLength += sqRange;
            }
            if (segments.size() == 0) {
                this.logger.info("UNSUPPORTED/UNKNOWN?");
                continue;
            }
            YoutubeStreamData data = new YoutubeStreamData(src, this.vid, baseURL, itag, null);
            data.setSegments(segments.toArray(new String[0]));
            if (height > 0L) {
                data.setHeight(height.intValue());
            }
            if (width > 0L) {
                data.setWidth(width.intValue());
            }
            if (fps > 0L) {
                data.setFps(fps.toString());
            }
            if (bitrate > 0L) {
                data.setBitrate(bitrate.intValue());
            }
            if (estimatedContentLength > 0L) {
                data.setEstimatedContentLength(estimatedContentLength);
            }
            if (approxDurationMs > 0L) {
                data.setApproxDurationMs(approxDurationMs);
            }
            ret.add(data);
        }
        return ret;
    }

    private long parseMPDRange(String url) {
        String[] range = new org.appwork.utils.Regex(url, "range/(\\d+)-(\\d+)").getRow(0);
        if (range != null) {
            return Long.parseLong(range[1]) - Long.parseLong(range[0]);
        }
        return -1L;
    }

    private long parseMPDDuration(String url) {
        String[] duration = new org.appwork.utils.Regex(url, "dur/(\\d+)(\\.(\\d+))?").getRow(0);
        if (duration == null) {
            return -1L;
        }
        String secs = duration[0];
        String msns = duration[2];
        if (duration.length == 1 || msns == null) {
            return Long.parseLong(secs) * 1000L;
        }
        long ret = Long.parseLong(secs) * 1000L;
        ret = msns.length() == 1 ? (ret += Long.parseLong(msns) * 100L) : (msns.length() == 2 ? (ret += Long.parseLong(msns) * 10L) : (msns.length() == 3 ? (ret += Long.parseLong(msns)) : (ret += Long.parseLong(msns.substring(0, 3)))));
        return ret;
    }

    private void collectMpdMap(String htmlCode, String regex, String src) {
        String url;
        String map = new org.appwork.utils.Regex(htmlCode, regex).getMatch(0);
        if (map == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)(map = (String)JSonStorage.restoreFromString((String)map, (TypeRef)TypeRef.STRING))) && (url = map) != null) {
            this.mpdUrls.add(new StreamMap(url, src));
        }
    }

    private void handleRentalVideos() throws Exception {
        String rentalText = this.br.getRegex("\"ypc_video_rental_bar_text\"\\s*\\:\\s*\"([^\"]+)").getMatch(0);
        if (StringUtils.isNotEmpty((String)rentalText)) {
            this.logger.warning("Download not possible: " + rentalText);
            throw new Exception(PAID_VIDEO + rentalText);
        }
        if (this.br.containsHTML("<meta itemprop=\"paid\" content=\"True\">")) {
            this.logger.warning("Download not possible: You have to pay to watch this video");
            throw new Exception("Paid Video: Download not possible");
        }
        if (this.br.containsHTML("watch-checkout-offers") && !this.br.containsHTML("The Polymer Project Authors. All rights reserved")) {
            this.logger.warning("Download not possible: You have to pay to watch this video");
            throw new Exception("Paid Video:Download not possible");
        }
    }

    private void doUserAPIScan() throws Exception {
        String checkName = this.cfg.getPackagePattern() + this.cfg.getVideoFilenamePattern() + this.cfg.getAudioFilenamePattern() + this.cfg.getSubtitleFilenamePattern() + this.cfg.getImageFilenamePattern() + this.cfg.getDescriptionFilenamePattern();
        boolean extended = false;
        for (YoutubeReplacer r : REPLACER) {
            if (r.getDataSource() != YoutubeReplacer.DataSource.API_USERS || !r.matches(checkName)) continue;
            extended = true;
            break;
        }
        if (!extended) {
            return;
        }
        if (StringUtils.isEmpty((String)this.vid.user)) {
            return;
        }
        Browser clone = this.br.cloneBrowser();
        this.getPage(clone, "https://gdata.youtube.com/feeds/api/users/" + this.vid.user + "?v=2");
        String googleID = clone.getRegex("<yt\\:googlePlusUserId>(.*?)</yt\\:googlePlusUserId>").getMatch(0);
        if (StringUtils.isNotEmpty((String)googleID)) {
            this.vid.userGooglePlusID = googleID;
        }
    }

    private void doFeedScan() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean probeSize(Browser br, YoutubeStreamData match) {
        Browser check = br.cloneBrowser();
        check.setFollowRedirects(true);
        try {
            URLConnectionAdapter con = check.openHeadConnection(match.getUrl());
            try {
                if (!con.isOK()) return false;
                if (!con.isContentDisposition()) {
                    if (!StringUtils.contains((String)con.getContentType(), (String)"image")) return false;
                }
                if (con.getCompleteContentLength() > 0L) {
                    match.setContentLength(con.getCompleteContentLength());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                con.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
        }
        return false;
    }

    public List<YoutubeStreamData> crawlThumbnailData(String itemID, boolean grabFilesize) {
        Regex thumbregex = this.br.getRegex("<meta property=\"og:image\" content=\"https?://i\\.ytimg.com/vi/([\\w-]+)/(.+\\.jpg)[^\"]*\">");
        if (!thumbregex.patternFind()) {
            return null;
        }
        String itemIDFromURL = thumbregex.getMatch(0);
        if (itemID == null) {
            itemID = itemIDFromURL;
        }
        String bestFname = thumbregex.getMatch(1);
        StreamCollection ret = new StreamCollection();
        LinkedHashMap<String, YoutubeITAG> thumbnails = new LinkedHashMap<String, YoutubeITAG>();
        thumbnails.put("maxresdefault.jpg", YoutubeITAG.IMAGE_MAX);
        thumbnails.put("hqdefault.jpg", YoutubeITAG.IMAGE_HQ);
        thumbnails.put("mqdefault.jpg", YoutubeITAG.IMAGE_MQ);
        thumbnails.put("default.jpg", YoutubeITAG.IMAGE_LQ);
        for (Map.Entry thumbnail : thumbnails.entrySet()) {
            YoutubeStreamData match = new YoutubeStreamData(null, this.vid, "https://i.ytimg.com/vi/" + itemID + "/" + (String)thumbnail.getKey(), (YoutubeITAG)((Object)thumbnail.getValue()), null);
            if (!grabFilesize || this.probeSize(this.br.cloneBrowser(), match)) {
                ret.add(match);
            }
            if (ret.size() <= 0 || !StringUtils.equalsIgnoreCase((String)((String)thumbnail.getKey()), (String)bestFname)) continue;
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(Account account, boolean refresh) throws Exception {
        Account account2 = account;
        synchronized (account2) {
            boolean forceUpdateAndBypassCache;
            this.br.setDebug(true);
            this.br.setCookiesExclusive(true);
            this.br.clearCookies(null);
            GoogleHelper googlehelper = new GoogleHelper(this.br);
            googlehelper.setLogger(this.br.getLogger());
            Thread thread = Thread.currentThread();
            boolean bl = forceUpdateAndBypassCache = thread instanceof AccountCheckerThread && ((AccountCheckerThread)((Object)thread)).getJob().isForce();
            if (forceUpdateAndBypassCache) {
                googlehelper.login(account, true);
            } else {
                googlehelper.login(account, refresh);
            }
            this.account = account;
        }
    }

    public Account login(LogInterface logger, boolean refresh) {
        ArrayList<Account> accounts = AccountController.getInstance().list("youtube.com");
        ArrayList<Account> debug = AccountController.getInstance().list("google.com");
        if (debug != null) {
            accounts.addAll(debug);
        }
        if ((debug = AccountController.getInstance().list("youtube.jd")) != null) {
            accounts.addAll(debug);
        }
        if (accounts != null && accounts.size() != 0) {
            for (Account n : accounts) {
                if (!n.isEnabled() || !n.isValid()) continue;
                try {
                    this.login(n, refresh);
                    if (!n.isValid()) continue;
                    return n;
                }
                catch (Exception e) {
                    logger.log((Throwable)e);
                    n.setValid(false);
                    return null;
                }
            }
        }
        return null;
    }

    public static boolean namePatternContainsSingleVideoSpecificEntries(String pattern) {
        if (pattern == null) {
            return false;
        }
        for (YoutubeReplacer rpl : REPLACER) {
            YoutubeReplacer.DataOrigin[] dataOrigins = rpl.getDataOrigins();
            if (!rpl.matches(pattern) || dataOrigins == null || dataOrigins.length <= 0 || dataOrigins[0] != YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO) continue;
            return true;
        }
        return false;
    }

    public String createFilename(DownloadLink link) {
        AbstractVariant variant = AbstractVariant.get(link);
        String formattedFilename = variant.getFileNamePattern(link);
        if (formattedFilename != null && !formattedFilename.toLowerCase(Locale.ENGLISH).matches(".*\\*[^\\*]*ext[^\\*]*\\*.*")) {
            formattedFilename = null;
        }
        if (formattedFilename == null || formattedFilename.equals("")) {
            formattedFilename = "*VIDEONAME* (*QUALITY*).*EXT*";
        }
        formattedFilename = this.replaceVariables(link, formattedFilename);
        if (!VariantGroup.IMAGE_PLAYLIST_COVER.equals((Object)variant.getBaseVariant().getGroup())) {
            String playlistID = link.getStringProperty(YT_PLAYLIST_ID);
            int playlistPosition = link.getIntegerProperty(YT_PLAYLIST_POSITION, -1);
            if (this.cfg.isPlaylistItemsIncludePlaylistPositionAtBeginningOfFilenames() && playlistID != null && playlistPosition != -1) {
                formattedFilename = playlistPosition + "." + formattedFilename.trim();
            }
        }
        return formattedFilename;
    }

    public String replaceVariables(DownloadLink link, String formattedFilename) {
        LogSource logger = LogController.getInstance().getPreviousThreadLogSource();
        if (logger == null) {
            logger = Log.DF;
        }
        AbstractVariant variant = AbstractVariant.get(link);
        try {
            formattedFilename = variant.modifyFileName(formattedFilename, link);
        }
        catch (Throwable e) {
            logger.log(e);
        }
        formattedFilename = YoutubeHelper.applyReplacer(formattedFilename, this, link);
        try {
            formattedFilename = variant.modifyFileName(formattedFilename, link);
        }
        catch (Throwable e) {
            logger.log(e);
        }
        return formattedFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean isSupported(YoutubeITAG itag) {
        if (itag == null) {
            return null;
        }
        Object object = FFMPEG_LOCK;
        synchronized (object) {
            FFmpeg ffmpeg;
            if (FFMPEG_SUPPORTED_FLAGS == null && (ffmpeg = new FFmpeg(null){

                @Override
                public LogInterface getLogger() {
                    return YoutubeHelper.this.logger;
                }
            }).isAvailable() && ffmpeg.isCompatible()) {
                FFMPEG_SUPPORTED_FLAGS = ffmpeg.getSupportedFlags();
            }
            if (FFMPEG_SUPPORTED_FLAGS != null) {
                if (itag.getVideoCodec() != null) {
                    switch (itag.getVideoCodec()) {
                        case AV1: {
                            return FFMPEG_SUPPORTED_FLAGS.contains((Object)AbstractFFmpegBinary.FLAG.AV1);
                        }
                    }
                }
                if (itag.getAudioCodec() != null) {
                    switch (itag.getAudioCodec()) {
                        case OPUS: 
                        case OPUS_SPATIAL: {
                            return FFMPEG_SUPPORTED_FLAGS.contains((Object)AbstractFFmpegBinary.FLAG.OPUS);
                        }
                        case VORBIS: 
                        case VORBIS_SPATIAL: {
                            return FFMPEG_SUPPORTED_FLAGS.contains((Object)AbstractFFmpegBinary.FLAG.VORBIS);
                        }
                    }
                }
            }
        }
        return null;
    }

    protected YoutubeStreamData parseLine(UrlQuery query, StreamMap src) throws MalformedURLException, IOException, PluginException {
        String[] splitted;
        String fallback_host;
        if (StringUtils.equalsIgnoreCase((String)query.get("conn"), (String)"rtmp")) {
            this.logger.info("Stream is not supported: " + query);
            this.vid.error = "RTMP(E) Stream not supported";
            return null;
        }
        if (StringUtils.equals((String)query.get("stream_type"), (String)"3")) {
            this.logger.info("UNSUPPORTED OTF:" + query);
            return null;
        }
        String url = query.getDecoded("url");
        if (url == null && (fallback_host = query.getDecoded("fallback_host")) != null) {
            url = new org.appwork.utils.Regex(fallback_host, "url=(.+)").getMatch(0);
        }
        if (!url.contains("ei=")) {
            System.out.println("ei");
        }
        if (StringUtils.isEmpty((String)url)) {
            throw new WTFException("No Url found " + query);
        }
        int throttle = -1;
        if (url.contains("&n=")) {
            throttle = 0;
            String value = new org.appwork.utils.Regex(url, "&n=(.*?)(&|$)").getMatch(0);
            String result = this.descrambleThrottle(value);
            if (result != null && !result.equals(value)) {
                url = url.replaceFirst("(&n=" + value + ")", "&n=" + result);
                throttle = 1;
            }
        }
        if (query.containsKey("signature")) {
            url = url + "&signature=" + query.get("signature");
        } else if (query.containsKey("sig")) {
            url = url + "&signature=" + query.get("sig");
        } else if (query.containsKey("s")) {
            String encrypted_sig = query.get("s");
            encrypted_sig = URLDecoder.decode(encrypted_sig, "UTF-8");
            String signature = this.descrambleSignature(encrypted_sig);
            url = query.containsKey("sp") ? url + "&" + query.get("sp") + "=" + Encoding.urlEncode((String)signature) : url + "&signature=" + Encoding.urlEncode((String)signature);
        }
        int bitrate = -1;
        String bitrateString = query.get("bitrate");
        if (StringUtils.isNotEmpty((String)bitrateString)) {
            bitrate = Integer.parseInt(bitrateString);
        }
        String size = query.get("size");
        int width = -1;
        int height = -1;
        if (StringUtils.isNotEmpty((String)size) && (splitted = size.split("\\s*x\\s*")) != null && splitted.length == 2) {
            width = Integer.parseInt(splitted[0]);
            height = Integer.parseInt(splitted[1]);
        }
        String fps = query.get("fps");
        String type = query.get("type");
        if (StringUtils.isNotEmpty((String)type)) {
            type = Encoding.urlDecode((String)type, (boolean)false);
        }
        String itagID = query.get("itag");
        YoutubeITAG itag = YoutubeITAG.get(Integer.parseInt(itagID), width, height, StringUtils.isEmpty((String)fps) ? -1 : Integer.parseInt(fps), type, query, this.vid.datePublished);
        if (itag == null) {
            this.logger.info("Unknown ITAG: " + itagID);
            this.logger.info(url + "");
            this.logger.info(query + "");
            try {
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && !Application.isJared(null)) {
                    Dialog.getInstance().showMessageDialog("Unknown ITag found: " + itagID + "\r\nAsk Coalado to Update the ItagHelper for Video ID: " + this.vid.videoID);
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            return null;
        }
        if (Boolean.FALSE.equals(this.isSupported(itag))) {
            this.logger.info("FFmpeg support for Itag'" + (Object)((Object)itag) + "' is missing");
            return null;
        }
        String quality = Encoding.urlDecode((String)query.get("quality"), (boolean)false);
        this.logger.info(Encoding.urlDecode((String)JSonStorage.toString((Object)query.list()), (boolean)false));
        if (url != null) {
            YoutubeStreamData vsd = new YoutubeStreamData(src.src, this.vid, url, itag, query);
            vsd.setThrottle(throttle);
            vsd.setHeight(height);
            vsd.setWidth(width);
            vsd.setFps(fps);
            return vsd;
        }
        return null;
    }

    private void itagWarning(YoutubeITAG itag, String string, Object size) {
        this.logger.warning("Youtube WARNING! Bad Itag choosen: " + (Object)((Object)itag) + " does not support " + string + " of " + size);
    }

    private String replaceHttps(String s) {
        return s.replaceFirst("http://", "https://");
    }

    public void setupProxy() {
        if (this.br == null) {
            return;
        }
        this.br.setProxy(this.br.getThreadProxy());
    }

    private ArrayList<YoutubeSubtitleStorable> loadSubtitles() throws Exception {
        Iterator name;
        LinkedHashMap urls = new LinkedHashMap();
        YoutubeSubtitleStorable defaultLanguage = null;
        for (String string : this.subtitleUrls) {
            String langTrans;
            String langOrg;
            String kind;
            String lang;
            if (string.startsWith("[")) {
                List tts = (List)JSonStorage.restoreFromString((String)string, (TypeRef)TypeRef.LIST);
                if (tts == null) continue;
                for (Object object : tts) {
                    String name2;
                    String url;
                    Map map;
                    Object isTranslatable;
                    if (!(object instanceof Map) || !"true".equalsIgnoreCase(String.valueOf(isTranslatable = (map = (Map)object).get("isTranslatable"))) || (url = (String)map.get("baseUrl")) == null) continue;
                    url = this.br.getURL(url).toString();
                    if (map.get("name") instanceof Map) {
                        Map nameMap = (Map)map.get("name");
                        String name3 = StringUtils.valueOrEmpty((String)((String)nameMap.get("simpleText")));
                    } else {
                        name2 = "";
                    }
                    String lang2 = (String)map.get("languageCode");
                    String kind2 = StringUtils.valueOrEmpty((String)((String)map.get("kind")));
                    String lngID = lang2;
                    ArrayList<YoutubeSubtitleStorable> list = (ArrayList<YoutubeSubtitleStorable>)urls.get(lngID);
                    YoutubeSubtitleStorable info = new YoutubeSubtitleStorable(null, name2, lang2, null, kind2);
                    info.setFullUrl(url);
                    if (info._getLocale() == null) {
                        this.logger.info("Unknown Subtitle Language: " + JSonStorage.serializeToJson((Object)info));
                        continue;
                    }
                    if (list == null) {
                        list = new ArrayList<YoutubeSubtitleStorable>();
                        urls.put(lngID, list);
                    }
                    if (list.size() > 0) {
                        info.setMulti(list.size());
                    }
                    list.add(info);
                    if (defaultLanguage != null || !"true".equalsIgnoreCase(StringUtils.valueOfOrNull(map.get("lang_default")))) continue;
                    defaultLanguage = info;
                }
                break;
            }
            String xml = this.getPage(this.br, this.replaceHttps(string + "&asrs=1&fmts=1&tlangs=1&ts=" + System.currentTimeMillis() + "&type=list")).getHtmlCode();
            name = null;
            DocumentBuilder docBuilder = this.createXMLParser();
            InputSource is = new InputSource(new StringReader(xml));
            Document doc = docBuilder.parse(is);
            NodeList tracks = doc.getElementsByTagName("track");
            for (int trackIndex = 0; trackIndex < tracks.getLength(); ++trackIndex) {
                Element track = (Element)tracks.item(trackIndex);
                String trackID = track.getAttribute("id");
                String cantran = track.getAttribute("cantran");
                if (!"true".equalsIgnoreCase(cantran)) continue;
                lang = track.getAttribute("lang_code");
                name = track.hasAttribute("name") ? track.getAttribute("name") : name;
                kind = track.getAttribute("kind");
                langOrg = track.getAttribute("lang_original");
                langTrans = track.getAttribute("lang_translated");
                if (name == null) {
                    name = "";
                }
                if (kind == null) {
                    kind = "";
                }
                String lngID = lang;
                if (StringUtils.isNotEmpty((String)langTrans)) {
                    langOrg = langTrans;
                }
                if (StringUtils.isEmpty((String)langOrg)) {
                    langOrg = TranslationFactory.stringToLocale((String)lang).getDisplayLanguage(Locale.ENGLISH);
                }
                ArrayList<YoutubeSubtitleStorable> list = (ArrayList<YoutubeSubtitleStorable>)urls.get(lngID);
                YoutubeSubtitleStorable info = new YoutubeSubtitleStorable(string, (String)((Object)name), lang, null, kind);
                if (info._getLocale() == null) {
                    this.logger.info("Unknown Subtitle Language: " + JSonStorage.serializeToJson((Object)info));
                    continue;
                }
                if (list == null) {
                    list = new ArrayList<YoutubeSubtitleStorable>();
                    urls.put(lngID, list);
                }
                if (list.size() > 0) {
                    info.setMulti(list.size());
                }
                list.add(info);
                if (defaultLanguage != null || !"true".equalsIgnoreCase(track.getAttribute("lang_default"))) continue;
                defaultLanguage = info;
            }
            if (defaultLanguage == null) continue;
            NodeList targets = doc.getElementsByTagName("target");
            for (int targetIndex = 0; targetIndex < targets.getLength(); ++targetIndex) {
                String cantran;
                ArrayList<YoutubeSubtitleStorable> list;
                Element target = (Element)targets.item(targetIndex);
                String targetID = target.getAttribute("id");
                lang = target.getAttribute("lang_code");
                kind = target.getAttribute("kind");
                langOrg = target.getAttribute("lang_original");
                langTrans = target.getAttribute("lang_translated");
                String urlfrag = target.getAttribute("urlfrag");
                if (name == null) {
                    name = "";
                }
                if (kind == null) {
                    kind = defaultLanguage.getKind();
                }
                String lngID = lang;
                if (StringUtils.isNotEmpty((String)langTrans)) {
                    langOrg = langTrans;
                }
                if (StringUtils.isEmpty((String)langOrg)) {
                    langOrg = TranslationFactory.stringToLocale((String)lang).getDisplayLanguage(Locale.ENGLISH);
                }
                if ((list = (ArrayList<YoutubeSubtitleStorable>)urls.get(lngID)) != null || !"true".equalsIgnoreCase(cantran = target.getAttribute("cantran"))) continue;
                YoutubeSubtitleStorable info = new YoutubeSubtitleStorable(string, (String)((Object)name), lang, defaultLanguage.getLanguage(), kind);
                if (info._getLocale() == null) {
                    this.logger.info("Unknown Subtitle Language: " + JSonStorage.serializeToJson((Object)info));
                    continue;
                }
                if (list == null) {
                    list = new ArrayList<YoutubeSubtitleStorable>();
                    urls.put(lngID, list);
                }
                list.add(info);
            }
        }
        if (defaultLanguage == null) {
            List en = (List)urls.get("en");
            if (en != null) {
                defaultLanguage = (YoutubeSubtitleStorable)en.get(0);
            } else {
                for (Object subtitles : urls.values()) {
                    YoutubeSubtitleStorable subtitle;
                    name = subtitles.iterator();
                    if (!name.hasNext()) continue;
                    defaultLanguage = subtitle = (YoutubeSubtitleStorable)name.next();
                }
            }
        }
        if (defaultLanguage != null) {
            HashSet<Locale> autoTranslatedSubtitlesSet = new HashSet<Locale>();
            List<String> list = CFG_YOUTUBE.CFG.getAutoTranslatedSubtitles();
            if (list != null && list.size() > 0) {
                for (String autoTranslatedSubtitle : list) {
                    try {
                        Locale locale = TranslationFactory.stringToLocale((String)autoTranslatedSubtitle);
                        if (StringUtils.isEmpty((String)locale.getISO3Language())) continue;
                        autoTranslatedSubtitlesSet.add(locale);
                    }
                    catch (Exception e) {
                        this.getLogger().log((Throwable)e);
                    }
                }
            }
            Locale desiredLocale = TranslationFactory.getDesiredLocale();
            for (Locale autoTranslateSubtitle : autoTranslatedSubtitlesSet) {
                String lng = autoTranslateSubtitle.getLanguage();
                String iso3Lng = autoTranslateSubtitle.getISO3Language();
                if (urls.containsKey(lng) || urls.containsKey(iso3Lng)) continue;
                YoutubeSubtitleStorable info = new YoutubeSubtitleStorable(null, autoTranslateSubtitle.getDisplayName(desiredLocale), lng, defaultLanguage.getLanguage(), defaultLanguage.getKind());
                String url = defaultLanguage.getFullUrl() + "&tlang=" + lng;
                info.setFullUrl(url);
                ArrayList<YoutubeSubtitleStorable> list2 = new ArrayList<YoutubeSubtitleStorable>();
                list2.add(info);
                urls.put(lng, list2);
                urls.put(iso3Lng, list2);
            }
        }
        ArrayList<YoutubeSubtitleStorable> ret = new ArrayList<YoutubeSubtitleStorable>();
        for (List list : urls.values()) {
            for (YoutubeSubtitleStorable entry : list) {
                if (ret.contains(entry)) continue;
                ret.add(entry);
            }
        }
        return ret;
    }

    public YoutubeConfig getConfig() {
        return this.cfg;
    }

    public static List<VariantIDStorable> readExtraList() {
        ArrayList<VariantIDStorable> list = new ArrayList<VariantIDStorable>();
        return list;
    }

    public static List<VariantIDStorable> readBlacklist() {
        ArrayList<VariantIDStorable> list = new ArrayList<VariantIDStorable>();
        return list;
    }

    public static String createLinkID(String mainContentID, AbstractVariant variant) {
        String ret = "youtubev2://" + mainContentID + "/" + Hash.getMD5((String)Encoding.urlEncode((String)variant._getUniqueId()));
        return ret;
    }

    public static void writeVariantToDownloadLink(DownloadLink downloadLink, AbstractVariant v) {
        downloadLink.getTempProperties().setProperty(YT_VARIANT, v);
        downloadLink.setProperty(YT_VARIANT, v.getStorableString());
    }

    public void extendedDataLoading(VariantInfo v, List<VariantInfo> variants) {
        this.extendedDataLoadingDemuxAudioBitrate(v, variants);
    }

    protected void checkFFProbe(FFprobe ffmpeg, String reason) throws SkipReasonException, InterruptedException {
        if (!ffmpeg.isAvailable()) {
            UpdateHandler handler = UpdateController.getInstance().getHandler();
            if (handler == null) {
                this.logger.warning("Please set FFMPEG: BinaryPath in advanced options");
                throw new SkipReasonException(SkipReason.FFMPEG_MISSING);
            }
            FFMpegInstallProgress progress = new FFMpegInstallProgress();
            progress.setProgressSource(this);
            FFmpegProvider.getInstance().install(progress, reason);
            ffmpeg.setPath(((FFmpegSetup)JsonConfig.create(FFmpegSetup.class)).getBinaryPath());
            if (!ffmpeg.isAvailable()) {
                List requestedInstalls = handler.getRequestedInstalls();
                String extensionID = FFMpegInstallThread.getFFmpegExtensionName();
                if (requestedInstalls != null && extensionID != null && requestedInstalls.contains(extensionID)) {
                    throw new SkipReasonException(SkipReason.UPDATE_RESTART_REQUIRED);
                }
                throw new SkipReasonException(SkipReason.FFMPEG_MISSING);
            }
        }
    }

    public void extendedDataLoading(List<VariantInfo> vs) {
        for (VariantInfo v : vs) {
            this.extendedDataLoading(v, vs);
        }
    }

    protected void extendedDataLoadingDemuxAudioBitrate(VariantInfo v, List<VariantInfo> variants) {
        if (!CFG_YOUTUBE.CFG.isDoExtendedAudioBitrateLookupEnabled()) {
            return;
        }
        YoutubeITAG itagVideo = v.getVariant().getiTagVideo();
        if (itagVideo == null) {
            return;
        }
        switch (itagVideo.getITAG()) {
            case 18: 
            case 22: 
            case 82: 
            case 84: {
                int bitrate = v.getVideoStreams().getAudioBitrate();
                if (bitrate <= 0) {
                    this.logger.info("Load Stream Probe for " + (Object)((Object)itagVideo) + " - " + itagVideo.getITAG());
                    block5: for (YoutubeStreamData vStream : v.getVideoStreams()) {
                        try {
                            if (vStream.getSegments() != null && vStream.getSegments().length > 0) {
                                System.out.println("HLS");
                                continue;
                            }
                            Browser clone = this.br.cloneBrowser();
                            List proxies = this.br.selectProxies(new URL("https://youtube.com"));
                            if (proxies != null && proxies.size() > 0) {
                                clone.setProxySelector((ProxySelectorInterface)new StaticProxySelector((HTTPProxy)proxies.get(0)));
                            }
                            FFprobe ffmpeg = new FFprobe(clone){

                                @Override
                                public LogInterface getLogger() {
                                    return YoutubeHelper.this.logger;
                                }
                            };
                            this.checkFFProbe(ffmpeg, "Detect the actual Audio Bitrate");
                            StreamInfo streamInfo = ffmpeg.getStreamInfo(vStream.getUrl());
                            if (streamInfo == null) continue;
                            for (Stream stream : streamInfo.getStreams()) {
                                int aBitrate;
                                if (!"audio".equals(stream.getCodec_type()) || (aBitrate = (int)(Double.parseDouble(stream.getBit_rate()) / 1000.0)) <= 0) continue;
                                bitrate = aBitrate;
                                v.getVideoStreams().setAudioBitrate(aBitrate);
                                break block5;
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (bitrate <= 0) break;
                for (VariantInfo av : variants) {
                    if (av.getVariant().getiTagVideo() != itagVideo || !(av.getVariant().getGenericInfo() instanceof GenericAudioInfo)) continue;
                    ((GenericAudioInfo)av.getVariant().getGenericInfo()).setaBitrate(bitrate);
                }
                break;
            }
        }
    }

    private Map<String, Object> jsonToJavaMap(String string, boolean throwException) throws Exception {
        try {
            return JavaScriptEngineFactory.jsonToJavaMap(string);
        }
        catch (Exception e) {
            if (throwException) {
                throw e;
            }
            if (!StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"window.ytplayer")) {
                this.logger.log((Throwable)e);
            }
            return null;
        }
    }

    public void parsePlayerConfig(Browser br) throws Exception {
        String ytplayerConfig = br.getRegex("ytplayer\\.(?:web_player_context_)?config\\s*=\\s*\\s*(\\{.*?\\});\\s*ytplayer\\.load").getMatch(0);
        if (ytplayerConfig == null && (ytplayerConfig = br.getRegex("ytplayer\\.(?:web_player_context_)?config\\s*=\\s*\\s*(\\{.*?\\});\\s*\\(\\s*function\\s*playerBootstrap").getMatch(0)) == null) {
            ytplayerConfig = br.getRegex("ytplayer\\.(?:web_player_context_)?config\\s*=\\s*\\s*(\\{.*?\\});").getMatch(0);
        }
        if (ytplayerConfig != null) {
            this.ytPlayerConfig = this.jsonToJavaMap(ytplayerConfig, false);
            if (this.ytPlayerConfig != null) {
                Object playerResponse = JavaScriptEngineFactory.walkJson(this.ytPlayerConfig, "args/player_response");
                if (playerResponse == null) {
                    playerResponse = JavaScriptEngineFactory.walkJson(this.ytPlayerConfig, "args/raw_player_response");
                }
                if (playerResponse instanceof String) {
                    Map<String, Object> ytInitialPlayerResponse = this.jsonToJavaMap(playerResponse.toString(), true);
                    if (this.ytInitialPlayerResponse == null) {
                        this.ytInitialPlayerResponse = ytInitialPlayerResponse;
                    } else {
                        this.logger.info("Merge ytInitialPlayerResponse");
                        this.ytInitialPlayerResponse.putAll(ytInitialPlayerResponse);
                    }
                }
            }
        } else {
            this.ytPlayerConfig = null;
        }
    }

    public void parse(Browser br) throws Exception {
        String ytInitialData = br.getRegex(">\\s*var\\s*ytInitialData\\s*=\\s*(\\{.*?\\})\\s*;?\\s*</script").getMatch(0);
        if (ytInitialData == null && (ytInitialData = br.getRegex("window\\[\"ytInitialData\"\\]\\s*=\\s*(\\{.*?\\})\\s*;\\s*[\r\n]").getMatch(0)) == null && (ytInitialData = br.getRegex("window\\[\"ytInitialData\"\\]\\s*=\\s*(?:JSON.parse)?\\s*\\(\\s*(\"\\{.*?\\}\")\\s*\\)\\s*;\\s*[\r\n]").getMatch(0)) != null) {
            ytInitialData = (String)JSonStorage.restoreFromString((String)ytInitialData, (TypeRef)TypeRef.STRING);
        }
        this.ytInitialData = ytInitialData != null ? this.jsonToJavaMap(ytInitialData, true) : null;
        String ytInitialPlayerResponse = br.getRegex(">\\s*var\\s*ytInitialPlayerResponse\\s*=\\s*(\\{.*?\\})\\s*;?\\s*(</script|var\\s*(?:meta|head)\\s*=\\s*document)").getMatch(0);
        if (ytInitialPlayerResponse == null && (ytInitialPlayerResponse = br.getRegex("window\\[\"ytInitialPlayerResponse\"\\]\\s*=\\s*\\(\\s*(\\{.*?\\})\\s*\\)\\s*;\\s*[\r\n]").getMatch(0)) == null && (ytInitialPlayerResponse = br.getRegex("window\\[\"ytInitialPlayerResponse\"\\]\\s*=\\s*(\\{.*?\\})\\s*;\\s*[\r\n]").getMatch(0)) == null && (ytInitialPlayerResponse = br.getRegex("window\\[\"ytInitialPlayerResponse\"\\]\\s*=\\s*(?:JSON.parse)?\\s*\\(\\s*(\"\\{.*?\\}\")\\s*\\)\\s*;\\s*[\r\n]").getMatch(0)) != null) {
            ytInitialPlayerResponse = (String)JSonStorage.restoreFromString((String)ytInitialPlayerResponse, (TypeRef)TypeRef.STRING);
        }
        this.ytInitialPlayerResponse = ytInitialPlayerResponse != null ? this.jsonToJavaMap(ytInitialPlayerResponse, true) : null;
        this.parsePlayerConfig(br);
        String[] ytcfgSet = br.getRegex("ytcfg\\.set\\((\\{.*?\\})\\);").getColumn(0);
        if (ytcfgSet != null) {
            HashMap<String, Object> set = new HashMap<String, Object>();
            for (String ytcfg : ytcfgSet) {
                Map<String, Object> map = this.jsonToJavaMap(ytcfg, false);
                if (map == null || map.size() <= 0) continue;
                set.putAll(map);
            }
            this.ytCfgSet = set.size() > 0 ? set : null;
        } else {
            this.ytCfgSet = null;
        }
    }

    public String getChannelPlaylistCrawlerContainerUrlOverride(String fallback) {
        if (this.channelPlaylistCrawlerContainerUrlOverride != null) {
            return this.channelPlaylistCrawlerContainerUrlOverride;
        }
        return fallback;
    }

    public void setChannelPlaylistCrawlerContainerUrlOverride(String channelPlaylistCrawlerContainerUrlOverride) {
        this.channelPlaylistCrawlerContainerUrlOverride = channelPlaylistCrawlerContainerUrlOverride;
    }

    public String getPlaylistID() {
        return this.playlistID;
    }

    public void setPlaylistID(String playlistID) {
        this.playlistID = playlistID;
    }

    public static String generatePlaylistURL(String playlistID) {
        return YoutubeHelper.getBaseURL() + "/playlist?list=" + playlistID;
    }

    public static String generateRadioPlaylistURL(String playlistID) {
        return YoutubeHelper.getBaseURL() + "/watch?v=&list=" + playlistID;
    }

    public static boolean looksLikeRadioPlaylistURL(String url) {
        return StringUtils.containsIgnoreCase((String)url, (String)"/watch") && StringUtils.containsIgnoreCase((String)url, (String)"list=RD");
    }

    public static String getBaseURL() {
        return "https://www.youtube.com";
    }

    public static String getChannelURLOLD(String channelID, String tabName) {
        String channelURL = YoutubeHelper.getBaseURL() + "/channel/" + channelID;
        if (tabName != null) {
            channelURL = channelURL + "/" + tabName;
        }
        return channelURL;
    }

    public static String getChannelURL(String userName, String tabName) {
        String channelURL = YoutubeHelper.getBaseURL() + "/@" + userName;
        if (tabName != null) {
            channelURL = channelURL + "/" + tabName;
        }
        return channelURL;
    }

    public static String generateContentURL(String videoID) {
        return YoutubeHelper.generateVideoContentURL(videoID, null, -1);
    }

    public static String generateVideoContentURL(String videoID, String playlistID, int playlistPosition) {
        String url = YoutubeHelper.getBaseURL() + "/watch?v=" + videoID;
        if (playlistID != null) {
            url = url + "&list=" + playlistID;
            if (playlistPosition > 0) {
                url = url + "&index=" + playlistPosition;
            }
        }
        return url;
    }

    public List<YoutubeStreamData> crawlCoverData(String playListID, boolean grabFilesize) throws Exception {
        String[][] customCovers;
        if (playListID == null) {
            return null;
        }
        List<YoutubeStreamData> cachedCovers = this.streamDataCache.get(playListID);
        if (cachedCovers != null) {
            return cachedCovers;
        }
        Browser brc = this.br.cloneBrowser();
        if (brc.getRequest() == null || !brc.getURL().equalsIgnoreCase(YoutubeHelper.generatePlaylistURL(playListID))) {
            brc.getPage(YoutubeHelper.generatePlaylistURL(playListID));
        }
        if ((customCovers = brc.getRegex("<meta property=\"og:image\" content=\"(https?://i\\.ytimg.com/pl_c/[^\"]*)\">(?:\\s*<meta property=\"og:image:(width|height)\" content=\"(\\d+)\">)?(?:\\s*<meta property=\"og:image:(width|height)\" content=\"(\\d+)\">)?").getMatches()) == null || customCovers.length == 0) {
            List<YoutubeStreamData> thumbnailData = this.crawlThumbnailData(null, grabFilesize);
            if (thumbnailData == null || thumbnailData.size() == 0) {
                return null;
            }
            for (YoutubeStreamData thumbnail : thumbnailData) {
                switch (thumbnail.getItag()) {
                    case IMAGE_MAX: {
                        thumbnail.setItag(YoutubeITAG.COVER_MAX);
                        break;
                    }
                    case IMAGE_HQ: {
                        thumbnail.setItag(YoutubeITAG.COVER_HQ);
                        break;
                    }
                    case IMAGE_LQ: {
                        thumbnail.setItag(YoutubeITAG.COVER_LQ);
                        break;
                    }
                    case IMAGE_MQ: {
                        thumbnail.setItag(YoutubeITAG.COVER_MQ);
                    }
                }
            }
            return thumbnailData;
        }
        StreamCollection data = new StreamCollection();
        for (String[] customCover : customCovers) {
            YoutubeITAG itag;
            int height = -1;
            if (customCover.length == 5) {
                height = "height".equals(customCover[1]) ? Integer.parseInt(customCover[2]) : Integer.parseInt(customCover[4]);
            } else if (customCover.length == 3) {
                int n = height = "height".equals(customCover[1]) ? Integer.parseInt(customCover[2]) : -1;
            }
            if (height >= 720) {
                itag = YoutubeITAG.COVER_MAX;
            } else if (height >= 360) {
                itag = YoutubeITAG.COVER_HQ;
            } else if (height >= 180) {
                itag = YoutubeITAG.COVER_MQ;
            } else {
                if (height < 90) continue;
                itag = YoutubeITAG.COVER_LQ;
            }
            YoutubeStreamData match = new YoutubeStreamData(null, this.vid, Encoding.htmlOnlyDecode((String)customCover[0]), itag, null);
            if (grabFilesize && !this.probeSize(this.br.cloneBrowser(), match)) continue;
            data.add(match);
        }
        this.streamDataCache.put(playListID, data);
        if (data.size() == 0) {
            return null;
        }
        return data;
    }

    static {
        YoutubeConfig cfg = PluginJsonConfig.get(YoutubeConfig.class);
        String filepattern = cfg.getFilenamePattern();
        if (filepattern != null && !"*videoname* (*quality*).*ext*".equals(filepattern)) {
            cfg.setVideoFilenamePattern(filepattern);
            cfg.setAudioFilenamePattern(filepattern);
            cfg.setFilenamePattern(null);
        }
        REPLACER_MAP = new HashMap<String, YoutubeReplacer>();
        REPLACER = new ArrayList<YoutubeReplacer>(){

            @Override
            public boolean add(YoutubeReplacer e) {
                for (String tag : e.getTags()) {
                    if (REPLACER_MAP.put(tag, e) == null || !DebugMode.TRUE_IN_IDE_ELSE_FALSE) continue;
                    throw new WTFException("Duplicate error:" + tag);
                }
                return super.add(e);
            }
        };
        REPLACER.add(new YoutubeReplacer(new String[]{"GROUP"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                try {
                    return variant.getGroup().getLabel();
                }
                catch (Throwable e) {
                    helper.logger.log(e);
                    return "[INVALID LINK!]";
                }
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_group();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"ITAG_AUDIO_NAME"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                try {
                    return variant.getiTagAudioOrVideoItagEquivalent().name();
                }
                catch (Throwable throwable) {
                    return "";
                }
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_itag_audio_name();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"ITAG_VIDEO_NAME"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                try {
                    return variant.getiTagVideo().name();
                }
                catch (Throwable throwable) {
                    return "";
                }
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_itag_video_name();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"ITAG_VIDEO_ID"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                try {
                    return variant.getiTagVideo().getITAG() + "";
                }
                catch (Throwable throwable) {
                    return "";
                }
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_itag_video_id();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"ITAG_AUDIO_ID"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                try {
                    return variant.getiTagAudioOrVideoItagEquivalent().getITAG() + "";
                }
                catch (Throwable throwable) {
                    return "";
                }
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_itag_audio_id();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"VARIANT", "V"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                if ("name".equalsIgnoreCase(mod)) {
                    return AbstractVariant.get(link)._getName(link);
                }
                return AbstractVariant.get(link)._getUniqueId();
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_variantid2();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"QUALITY"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_quality();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                try {
                    return variant.getFileNameQualityTag();
                }
                catch (Throwable e) {
                    helper.logger.log(e);
                    return "[INVALID LINK!]";
                }
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"COLLECTION", "COL"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_collection();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_COLLECTION, "");
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"VIDEOID", "VIDEO_ID", "ID"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_id();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_ID, "");
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"@ID", "ATID"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_atid();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_ATID, "");
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO, YoutubeReplacer.DataOrigin.YT_CHANNEL};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"360", "SPHERICAL"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_spherical();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                if (variant != null && variant instanceof VideoVariant) {
                    switch (((VideoVariant)variant).getProjection()) {
                        case SPHERICAL: 
                        case SPHERICAL_3D: {
                            return "Spherical";
                        }
                    }
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"THREED", "3D"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_3d();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                if (variant != null && variant instanceof VideoVariant) {
                    switch (((VideoVariant)variant).getProjection()) {
                        case SPHERICAL_3D: 
                        case ANAGLYPH_3D: {
                            return "3D";
                        }
                    }
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"FPS"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_fps();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                int fps;
                AbstractVariant variant = AbstractVariant.get(link);
                if (variant != null && variant instanceof VideoVariant && (fps = ((VideoInterface)((Object)variant)).getVideoFrameRate()) > 0) {
                    return fps + "";
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"EXT", "EXTENSION"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_extension();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                return variant.getContainer().getExtension();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"HEIGHT", "H"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_height();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                if (variant != null && variant instanceof VideoVariant) {
                    return ((VideoInterface)((Object)variant)).getVideoHeight() + "";
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"HEIGHT_BEST"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_best_height();
            }

            @Override
            public YoutubeReplacer.DataSource getDataSource() {
                return YoutubeReplacer.DataSource.WEBSITE;
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_BEST_VIDEO_HEIGHT, "");
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"WIDTH", "W"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_width();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                if (variant != null && variant instanceof VideoVariant) {
                    return ((VideoInterface)((Object)variant)).getVideoWidth() + "";
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"USERNAME", "USER"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_USER_NAME, "");
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_user();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO, YoutubeReplacer.DataOrigin.YT_CHANNEL};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"USERNAME_ALTERNATIVE", "USER_ALTERNATIVE"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_USER_NAME_ALTERNATIVE, link.getStringProperty(YoutubeHelper.YT_USER_NAME, ""));
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_user() + " " + _GUI.T.YoutubeHelper_getDescription_alternative();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO, YoutubeReplacer.DataOrigin.YT_CHANNEL};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"PLAYLIST_ID", "PL_ID"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_PLAYLIST_ID, "");
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_playlist_id();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_PLAYLIST};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"PLAYLIST_CREATOR", "PLAYLIST_USERNAME", "PL_USR"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_PLAYLIST_CREATOR, link.getStringProperty(YoutubeHelper.YT_USER_NAME));
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_playlist_creator();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_PLAYLIST};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"PLAYLIST_NAME", "PLAYLIST_TITLE", "PL_NAME"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_PLAYLIST_TITLE, "");
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_playlist_name();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_PLAYLIST};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"PLAYLIST_SIZE", "PL_SIZE"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                int ret = link.getIntegerProperty(YoutubeHelper.YT_PLAYLIST_SIZE, -1);
                if (ret == -1) {
                    return "";
                }
                return String.valueOf(ret);
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_playlist_size();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_PLAYLIST};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"PLAYLIST_DESCRIPTION", "PL_DESCR"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_PLAYLIST_DESCRIPTION, "");
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_playlist_description();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_PLAYLIST};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"PLAYLIST_POSITION", "PL_POS", "VIDEONUMBER"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_videonumber();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                int playlistNumber = link.getIntegerProperty(YoutubeHelper.YT_PLAYLIST_POSITION, -1);
                if (playlistNumber < 0) {
                    return "";
                }
                DecimalFormat df = new DecimalFormat("0000");
                try {
                    if (StringUtils.isNotEmpty((String)mod)) {
                        df = new DecimalFormat(mod);
                    }
                }
                catch (Throwable e) {
                    helper.logger.log(e);
                }
                return df.format(playlistNumber);
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO, YoutubeReplacer.DataOrigin.YT_PLAYLIST};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"CHANNEL_ID", "CH_ID"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_CHANNEL_ID, "");
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_channel_id();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO, YoutubeReplacer.DataOrigin.YT_CHANNEL};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"CHANNEL_SIZE", "CH_SIZE"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                int ret = link.getIntegerProperty(YoutubeHelper.YT_CHANNEL_SIZE, -1);
                if (ret == -1) {
                    return "";
                }
                return String.valueOf(ret);
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_channel_size();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_CHANNEL};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"GOOGLEPLUS_ID"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_GOOGLE_PLUS_ID, "");
            }

            @Override
            public YoutubeReplacer.DataSource getDataSource() {
                return YoutubeReplacer.DataSource.API_USERS;
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_googleplus_id();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"DURATION"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                int secs = link.getIntegerProperty(YoutubeHelper.YT_DURATION, -1);
                if (secs <= 0) {
                    return "";
                }
                if (StringUtils.isEmpty((String)mod)) {
                    return TimeFormatter.formatSeconds((long)secs, (int)0);
                }
                return secs + "s";
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_duration();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"CHANNEL", "CHANNELNAME", "CHANNEL_NAME"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_CHANNEL_TITLE, "");
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_channel();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO, YoutubeReplacer.DataOrigin.YT_CHANNEL};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"CHANNEL_ALTERNATIVE", "CHANNELNAME_ALTERNATIVE"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_CHANNEL_TITLE_ALTERNATIVE, link.getStringProperty(YoutubeHelper.YT_CHANNEL_TITLE, ""));
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_channel() + " " + _GUI.T.YoutubeHelper_getDescription_alternative();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO, YoutubeReplacer.DataOrigin.YT_CHANNEL};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"VIDEONAME", "VIDEO_NAME", "TITLE"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_TITLE, "");
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_title();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"VIDEONAME_ALTERNATIVE", "VIDEO_NAME_ALTERNATIVE", "TITLE_ALTERNATIVE"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_TITLE_ALTERNATIVE, link.getStringProperty(YoutubeHelper.YT_TITLE, ""));
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_title() + " " + _GUI.T.YoutubeHelper_getDescription_alternative();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"CATEGORY"}){

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_CATEGORY, "");
            }

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_category();
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"DATE", "DATE_TIME", "DATE_PUBLISH"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_date();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                long timestamp;
                DateFormat formatter = null;
                if (StringUtils.isNotEmpty((String)mod)) {
                    try {
                        formatter = new SimpleDateFormat(mod, TranslationFactory.getDesiredLocale());
                    }
                    catch (Throwable e) {
                        helper.logger.log(e);
                    }
                }
                if (formatter == null) {
                    formatter = DateFormat.getDateInstance(1, TranslationFactory.getDesiredLocale());
                }
                if ((timestamp = link.getLongProperty(YoutubeHelper.YT_DATE, -1L)) > 0L) {
                    String ret = formatter.format(timestamp);
                    helper.logger.info(" Youtube Replace DATE_PUBLISH " + mod + " - " + timestamp + " > " + ret);
                    return ret;
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"DATE_LIVESTREAM_START"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_date_livestream_start();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                long timestamp;
                DateFormat formatter = null;
                if (StringUtils.isNotEmpty((String)mod)) {
                    try {
                        formatter = new SimpleDateFormat(mod, TranslationFactory.getDesiredLocale());
                    }
                    catch (Throwable e) {
                        helper.logger.log(e);
                    }
                }
                if (formatter == null) {
                    formatter = DateFormat.getDateInstance(1, TranslationFactory.getDesiredLocale());
                }
                if ((timestamp = link.getLongProperty(YoutubeHelper.YT_DATE_LIVESTREAM_START, -1L)) > 0L) {
                    String ret = formatter.format(timestamp);
                    helper.logger.info(" Youtube Replace DATE_LIVESTREAM_START " + mod + " - " + timestamp + " > " + ret);
                    return ret;
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"DATE_LIVESTREAM_END"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_date_livestream_start();
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                long timestamp;
                DateFormat formatter = null;
                if (StringUtils.isNotEmpty((String)mod)) {
                    try {
                        formatter = new SimpleDateFormat(mod, TranslationFactory.getDesiredLocale());
                    }
                    catch (Throwable e) {
                        helper.logger.log(e);
                    }
                }
                if (formatter == null) {
                    formatter = DateFormat.getDateInstance(1, TranslationFactory.getDesiredLocale());
                }
                if ((timestamp = link.getLongProperty(YoutubeHelper.YT_DATE_LIVESTREAM_END, -1L)) > 0L) {
                    String ret = formatter.format(timestamp);
                    helper.logger.info(" Youtube Replace DATE_LIVESTREAM_END " + mod + " - " + timestamp + " > " + ret);
                    return ret;
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"DATE_UPLOAD", "DATE_UDPATE"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_date_upload();
            }

            @Override
            public YoutubeReplacer.DataSource getDataSource() {
                return YoutubeReplacer.DataSource.API_VIDEOS;
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                long timestamp;
                DateFormat formatter = null;
                if (StringUtils.isNotEmpty((String)mod)) {
                    try {
                        formatter = new SimpleDateFormat(mod, TranslationFactory.getDesiredLocale());
                    }
                    catch (Throwable e) {
                        helper.logger.log(e);
                    }
                }
                if (formatter == null) {
                    formatter = DateFormat.getDateTimeInstance(1, 1, TranslationFactory.getDesiredLocale());
                }
                if ((timestamp = link.getLongProperty(YoutubeHelper.YT_DATE_UPLOAD, -1L)) > 0L) {
                    String ret = formatter.format(timestamp);
                    helper.logger.info(" Youtube Replace Update-Date " + mod + " - " + timestamp + " > " + ret);
                    return ret;
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"VIDEO_CODEC", "CODEC_VIDEO"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_videoCodec();
            }

            @Override
            public YoutubeReplacer.DataSource getDataSource() {
                return YoutubeReplacer.DataSource.WEBSITE;
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                VideoCodec v;
                AbstractVariant variant = AbstractVariant.get(link);
                if (variant != null && variant instanceof VideoVariant && (v = ((VideoInterface)((Object)variant)).getVideoCodec()) != null) {
                    return v.getLabel();
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"RESOLUTION"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_resolution();
            }

            @Override
            public YoutubeReplacer.DataSource getDataSource() {
                return YoutubeReplacer.DataSource.WEBSITE;
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                VideoResolution v;
                AbstractVariant variant = AbstractVariant.get(link);
                if (variant != null && variant instanceof VideoVariant && (v = ((VideoInterface)((Object)variant)).getVideoResolution()) != null) {
                    return v.getLabel();
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"BESTRESOLUTION", "RESOLUTION_BEST"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_resolution_best();
            }

            @Override
            public YoutubeReplacer.DataSource getDataSource() {
                return YoutubeReplacer.DataSource.WEBSITE;
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                String var = link.getStringProperty(YoutubeHelper.YT_BEST_VIDEO, "");
                if (var == null) {
                    return "";
                }
                try {
                    return YoutubeITAG.valueOf(var).getVideoResolution().getLabel();
                }
                catch (Throwable e) {
                    helper.logger.log(e);
                    return "[INVALID LINK!]";
                }
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"AUDIO_CODEC", "CODEC_AUDIO"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_audioCodec();
            }

            @Override
            public YoutubeReplacer.DataSource getDataSource() {
                return YoutubeReplacer.DataSource.WEBSITE;
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                if (variant != null && variant instanceof AudioInterface) {
                    return ((AudioInterface)((Object)variant)).getAudioCodec().getLabel();
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"LNG"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_language();
            }

            @Override
            public YoutubeReplacer.DataSource getDataSource() {
                return YoutubeReplacer.DataSource.WEBSITE;
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                if (variant != null) {
                    AudioInterface audio;
                    Locale locale;
                    if (variant instanceof SubtitleVariant) {
                        SubtitleVariant subtitle = (SubtitleVariant)variant;
                        String asr = ((YoutubeSubtitleStorable)subtitle.getGenericInfo())._isSpeechToText() ? "_ASR" : "";
                        if ("full".equalsIgnoreCase(mod)) {
                            int multi = ((YoutubeSubtitleStorable)subtitle.getGenericInfo()).getMulti();
                            if (multi > 0) {
                                return ((YoutubeSubtitleStorable)subtitle.getGenericInfo())._getLocale().getDisplayName() + "(" + multi + ")" + asr;
                            }
                            return ((YoutubeSubtitleStorable)subtitle.getGenericInfo())._getLocale().getDisplayName() + asr;
                        }
                        if ("display".equalsIgnoreCase(mod)) {
                            return ((YoutubeSubtitleStorable)subtitle.getGenericInfo())._getLocale().getDisplayLanguage() + asr;
                        }
                        return ((YoutubeSubtitleStorable)subtitle.getGenericInfo()).getLanguage() + asr;
                    }
                    if (variant instanceof AudioInterface && (locale = (audio = (AudioInterface)((Object)variant)).getAudioLocale()) != null) {
                        AudioType type = audio.getAudioType();
                        StringBuilder sb = new StringBuilder();
                        if ("type".equalsIgnoreCase(mod)) {
                            if (type == null) {
                                return "";
                            }
                            sb.append(" (").append(type.getLabel()).append(")");
                        } else if ("code".equalsIgnoreCase(mod)) {
                            sb.append(locale.getLanguage());
                        } else if ("display".equalsIgnoreCase(mod)) {
                            sb.append(locale.getDisplayLanguage());
                        } else {
                            sb.append(locale.getDisplayName());
                        }
                        return sb.toString();
                    }
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"AUDIO_BITRATE"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_audioQuality();
            }

            @Override
            public YoutubeReplacer.DataSource getDataSource() {
                return YoutubeReplacer.DataSource.WEBSITE;
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                AbstractVariant variant = AbstractVariant.get(link);
                if (variant != null && variant instanceof AudioInterface) {
                    return ((AudioInterface)((Object)variant)).getAudioBitrate().getKbit() + "";
                }
                return "";
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        REPLACER.add(new YoutubeReplacer(new String[]{"VIEWS"}){

            @Override
            public String getDescription() {
                return _GUI.T.YoutubeHelper_getDescription_views();
            }

            @Override
            public YoutubeReplacer.DataSource getDataSource() {
                return YoutubeReplacer.DataSource.WEBSITE;
            }

            @Override
            protected String getValue(DownloadLink link, YoutubeHelper helper, String mod) {
                return link.getStringProperty(YoutubeHelper.YT_VIEWS, "");
            }

            @Override
            public YoutubeReplacer.DataOrigin[] getDataOrigins() {
                return new YoutubeReplacer.DataOrigin[]{YoutubeReplacer.DataOrigin.YT_SINGLE_VIDEO};
            }
        });
        enablePlaylistSpecialDupeCheck = null;
        PLAYERJS_CACHE = new HashMap<String, String>();
        CONSENT_COOKIE_REQUIRED = true;
        API_TV_ENABLED = true;
        FFMPEG_SUPPORTED_FLAGS = null;
        FFMPEG_LOCK = new Object();
    }

    public static class StreamMap {
        private YoutubeStreamData streamData = null;
        private String mapData;
        private String src;

        public StreamMap(String map, String src) {
            this.mapData = map;
            this.src = src;
        }

        public StreamMap(YoutubeStreamData streamData, String src) {
            this.streamData = streamData;
            this.src = src;
        }

        public String toString() {
            if (this.mapData != null) {
                return this.mapData + " (" + this.src + ")";
            }
            return this.streamData + " (" + this.src + ")";
        }

        public int hashCode() {
            if (this.mapData != null) {
                return this.mapData.hashCode();
            }
            return this.streamData.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StreamMap)) {
                return false;
            }
            if (this.mapData != null && ((StreamMap)obj).mapData != null) {
                return StringUtils.equalsIgnoreCase((String)this.mapData, (String)((StreamMap)obj).mapData);
            }
            if (this.streamData != null && ((StreamMap)obj).streamData != null) {
                return this.streamData.equals(((StreamMap)obj).streamData);
            }
            return false;
        }

        public YoutubeStreamData getStreamData() {
            return this.streamData;
        }
    }
}

