/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube;

import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.parser.UrlQuery;
import org.jdownloader.plugins.components.youtube.YoutubeClipData;
import org.jdownloader.plugins.components.youtube.itag.YoutubeITAG;

public class YoutubeStreamData {
    private YoutubeClipData clip;
    private String url;
    private String[] segments;
    YoutubeITAG itag;
    private int height;
    private int width;
    private String fps;
    private int projectionType = -1;
    private String src;
    private long contentLength = -1L;
    private long estimatedContentLength = -1L;
    private int throttle = -1;
    private String lngId = null;
    private long approxDurationMs = -1L;
    private int bitrate = -1;
    private int averageBitrate = -1;
    private boolean drc = false;

    public String toString() {
        if (this.lngId != null) {
            return "Itag" + this.itag.getITAG() + "(" + (Object)((Object)this.itag) + ")(" + this.lngId + ")";
        }
        return "Itag" + this.itag.getITAG() + "(" + (Object)((Object)this.itag) + ")";
    }

    public void setClip(YoutubeClipData clip) {
        this.clip = clip;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setItag(YoutubeITAG itag) {
        this.itag = itag;
    }

    public YoutubeClipData getClip() {
        return this.clip;
    }

    public String getUrl() {
        return this.url;
    }

    public String[] getSegments() {
        return this.segments;
    }

    public void setSegments(String[] segments) {
        this.segments = segments;
    }

    public YoutubeITAG getItag() {
        return this.itag;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getFps() {
        return this.fps;
    }

    public void setFps(String fps) {
        this.fps = fps;
    }

    public String getLngId() {
        return this.lngId;
    }

    public void setLngId(String lngId) {
        this.lngId = lngId;
    }

    public int hashCode() {
        return this.itag.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof YoutubeStreamData)) {
            return false;
        }
        YoutubeStreamData o = (YoutubeStreamData)obj;
        if (!StringUtils.equals((String)this.getClip().videoID, (String)o.getClip().videoID)) {
            return false;
        }
        if (this.getItag() != o.getItag()) {
            return false;
        }
        return StringUtils.equals((String)this.getLngId(), (String)o.getLngId());
    }

    public int getThrottle() {
        return this.throttle;
    }

    public void setThrottle(int throttle) {
        this.throttle = throttle;
    }

    public void setEstimatedContentLength(long estimatedContentLength) {
        this.estimatedContentLength = estimatedContentLength;
    }

    public long getApproxDurationMs() {
        return this.approxDurationMs;
    }

    public void setApproxDurationMs(long approxDurationMs) {
        this.approxDurationMs = approxDurationMs;
    }

    public boolean isDrc() {
        return this.drc;
    }

    public void setDrc(boolean drc) {
        this.drc = drc;
    }

    public int getAverageBitrate() {
        return this.averageBitrate;
    }

    public void setAverageBitrate(int averageBitrate) {
        this.averageBitrate = Math.max(-1, this.bitrate);
    }

    public void setContentLength(long contentLength) {
        this.contentLength = Math.max(-1L, contentLength);
    }

    public void setBitrate(int bitrate) {
        this.bitrate = Math.max(-1, bitrate);
    }

    public String getSrc() {
        return this.src;
    }

    public YoutubeStreamData(String src, YoutubeClipData vid, String url, YoutubeITAG itag, UrlQuery query) {
        this.src = src;
        this.clip = vid;
        this.itag = itag;
        this.url = url;
        if (query != null) {
            try {
                String cLenString = query.get("clen");
                if (cLenString != null) {
                    this.setContentLength(Long.parseLong(cLenString));
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
            try {
                String bitrateString = query.get("bitrate");
                if (bitrateString != null) {
                    this.setBitrate(Integer.parseInt(bitrateString));
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
            String v = query.get("projection_type");
            this.projectionType = v == null ? -1 : Integer.parseInt(v);
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getEstimatedContentLength() {
        return this.estimatedContentLength;
    }

    public long estimatedContentLength() {
        long estimatedContentLength = this.getEstimatedContentLength();
        if (estimatedContentLength > 0L) {
            return estimatedContentLength;
        }
        long duration = this.getApproxDurationMs();
        if (duration > 0L) {
            int bitrate = this.getAverageBitrate();
            if (bitrate <= 0) {
                bitrate = this.getBitrate();
            }
            if (bitrate > 0) {
                estimatedContentLength = (long)bitrate * (duration / 1000L) / 8L;
                return estimatedContentLength;
            }
        }
        return -1L;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getProjectionType() {
        return this.projectionType;
    }

    public void setProjectionType(int projectionType) {
        this.projectionType = projectionType;
    }
}

