/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.choosevariantdialog;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.components.youtube.choosevariantdialog.Filter;
import org.jdownloader.plugins.components.youtube.configpanel.AbstractVariantWrapper;
import org.jdownloader.plugins.components.youtube.configpanel.VariantsMapTableModel;
import org.jdownloader.plugins.components.youtube.variants.AbstractVariant;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;

public class CustomVariantsMapTableModel
extends VariantsMapTableModel {
    private AbstractVariant selected;
    private List<Filter> filters = new ArrayList<Filter>();

    public CustomVariantsMapTableModel(ArrayList<AbstractVariantWrapper> sorted, AbstractVariant selected) {
        super("ChooseYoutubeVariantDialog", sorted);
        this.selected = selected;
        super.init("ChooseYoutubeVariantDialog");
        super.initHighLighter();
    }

    protected void init(String id) {
    }

    @Override
    protected void initHighLighter() {
    }

    @Override
    public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
        this._fireTableStructureChanged(new ArrayList<AbstractVariantWrapper>(this.all), true);
    }

    @Override
    protected void addGroupingColumn() {
    }

    @Override
    protected void initColumns() {
        super.initColumns();
    }

    public void addFilter(Filter typeSel) {
        this.filters.add(typeSel);
    }

    @Override
    protected void filter(List<AbstractVariantWrapper> newtableData) {
        Iterator<AbstractVariantWrapper> it = newtableData.iterator();
        block0: while (it.hasNext()) {
            AbstractVariantWrapper next = it.next();
            for (Filter f : this.filters) {
                if (!f.isBlacklisted(next.variant)) continue;
                it.remove();
                continue block0;
            }
        }
    }

    @Override
    protected void addFileTypeColumn() {
        this.addColumn((ExtColumn)new VariantsMapTableModel.AutoResizingTextColumn(_GUI.T.YOUTUBE_CONFIG_PANEL_TABLE_FILETYPE()){
            {
                this.rendererField.setHorizontalAlignment(2);
            }

            @Override
            public boolean isAutoWidthEnabled() {
                return false;
            }

            public String getStringValue(AbstractVariantWrapper value) {
                return value.variant.getContainer().getLabel();
            }
        });
    }

    @Override
    protected void onStructureChanged(List<AbstractVariantWrapper> newtableData) {
        super.onStructureChanged(newtableData);
        if (this.typeColumn != null) {
            boolean showType = false;
            showType |= this.hasSubtitle;
            showType |= this.hasImage;
            int groups = 0;
            if (this.hasSubtitle) {
                ++groups;
            }
            if (this.hasVideo) {
                ++groups;
            }
            if (this.hasAudio) {
                ++groups;
            }
            if (this.hasDescription) {
                ++groups;
            }
            if (this.hasImage) {
                ++groups;
            }
            this.setColumnVisible((ExtColumn)this.typeColumn, showType |= groups > 1);
        }
    }

    @Override
    public void save() {
    }

    @Override
    protected void initListeners() {
        CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_AUDIO_BITRATES.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_AUDIO_CODECS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_FILE_CONTAINERS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_GROUPS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_PROJECTIONS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_RESOLUTIONS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_VIDEO_CODECS.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_YOUTUBE.CHOOSE_VARIANT_DIALOG_BLACKLISTED_VIDEO_FRAMERATES.getEventSender().addListener((EventListener)((Object)this), true);
        this.onConfigValueModified(null, null);
    }

    @Override
    protected void addCheckBoxColumn() {
    }
}

