/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.choosevariantdialog;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtCheckBox;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.utils.CounterMap;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.components.youtube.choosevariantdialog.CustomVariantsMapTable;
import org.jdownloader.plugins.components.youtube.choosevariantdialog.CustomVariantsMapTableModel;
import org.jdownloader.plugins.components.youtube.choosevariantdialog.YoutubeVariantSelectionDialog;
import org.jdownloader.plugins.components.youtube.configpanel.AbstractVariantWrapper;
import org.jdownloader.plugins.components.youtube.configpanel.VariantsMapTableModel;
import org.jdownloader.plugins.components.youtube.variants.SubtitleVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantInfo;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;

public class YoutubeVariantSelectionDialogAddMulti
extends YoutubeVariantSelectionDialog {
    private CounterMap<String> matchingLinks;
    private int linksCount;
    private MigPanel alternativePanel;
    private ExtCheckBox checkbox;
    private JLabel alternativesLabel;

    public YoutubeVariantSelectionDialogAddMulti(CounterMap<String> matchingLinks, int linkCount, List<VariantInfo> variants) {
        super(null, _GUI.T.youtube_variant_add_variant_dialog_title(), _GUI.T.lit_add(), variants);
        this.matchingLinks = matchingLinks;
        this.linksCount = linkCount;
    }

    @Override
    public JComponent layoutDialogContent() {
        JComponent ret = super.layoutDialogContent();
        this.alternativePanel = new MigPanel("ins 0", "[grow,fill]0[]", "[]");
        this.alternativesLabel = new JLabel(_GUI.T.youtube_variant_add_variant_dialog_help());
        this.alternativePanel.add((Component)this.alternativesLabel, (Object)"");
        this.alternativesLabel.setHorizontalAlignment(4);
        this.checkbox = new ExtCheckBox(CFG_YOUTUBE.CHOOSE_ALTERNATIVE_FOR_MASS_CHANGE_OR_ADD_DIALOG, new JComponent[0]);
        this.alternativePanel.add((Component)this.checkbox, (Object)("hidemode 3,gapleft 2,height " + this.alternativesLabel.getPreferredSize().height + "!"));
        if (this.linksCount > 1) {
            ret.add((Component)this.alternativePanel, "spanx,growx,pushx");
        }
        this.valueChanged(null);
        return ret;
    }

    public boolean isAutoAlternativesEnabled() {
        return this.checkbox.isSelected();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
    }

    @Override
    protected CustomVariantsMapTable createTable(CustomVariantsMapTableModel model) {
        CustomVariantsMapTable ret = super.createTable(model);
        ret.getSelectionModel().setSelectionMode(2);
        return ret;
    }

    @Override
    protected CustomVariantsMapTableModel createTableModel() {
        return new CustomVariantsMapTableModel(this.variantWrapperList, null){
            private VariantsMapTableModel.AutoResizingIntColumn matches;

            @Override
            protected void onStructureChanged(List<AbstractVariantWrapper> newtableData) {
                super.onStructureChanged(newtableData);
                if (this.matches != null) {
                    this.setColumnVisible((ExtColumn)this.matches, YoutubeVariantSelectionDialogAddMulti.this.linksCount > 1);
                }
            }

            @Override
            protected void initColumns() {
                super.initColumns();
                this.matches = new VariantsMapTableModel.AutoResizingIntColumn(_GUI.T.youtube_matching_links()){

                    @Override
                    public String getStringValue(AbstractVariantWrapper value) {
                        if (value.variant instanceof SubtitleVariant) {
                            return YoutubeVariantSelectionDialogAddMulti.this.matchingLinks.getInt((Object)value.variant._getUniqueId()) + "/" + YoutubeVariantSelectionDialogAddMulti.this.linksCount;
                        }
                        return YoutubeVariantSelectionDialogAddMulti.this.matchingLinks.getInt((Object)value.getVariableIDStorable().createUniqueID()) + "/" + YoutubeVariantSelectionDialogAddMulti.this.linksCount;
                    }

                    @Override
                    public boolean isAutoWidthEnabled() {
                        return true;
                    }

                    @Override
                    public int getInt(AbstractVariantWrapper value) {
                        if (value.variant instanceof SubtitleVariant) {
                            return YoutubeVariantSelectionDialogAddMulti.this.matchingLinks.getInt((Object)value.variant._getUniqueId());
                        }
                        return YoutubeVariantSelectionDialogAddMulti.this.matchingLinks.getInt((Object)value.getVariableIDStorable().createUniqueID());
                    }
                };
                this.addColumn((ExtColumn)this.matches);
            }
        };
    }

    @Override
    protected String getDescriptionText() {
        return _GUI.T.youtube_add_variants_help(this.linksCount);
    }
}

