/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.choosevariantdialog;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtCheckBox;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.utils.CounterMap;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.plugins.components.youtube.choosevariantdialog.CustomVariantsMapTableModel;
import org.jdownloader.plugins.components.youtube.choosevariantdialog.YoutubeVariantSelectionDialog;
import org.jdownloader.plugins.components.youtube.configpanel.AbstractVariantWrapper;
import org.jdownloader.plugins.components.youtube.configpanel.VariantsMapTableModel;
import org.jdownloader.plugins.components.youtube.variants.SubtitleVariant;
import org.jdownloader.plugins.components.youtube.variants.VariantGroup;
import org.jdownloader.plugins.components.youtube.variants.VariantInfo;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;

public class YoutubeVariantSelectionDialogSetMulti
extends YoutubeVariantSelectionDialog {
    private CounterMap<String> matchingLinks;
    private int linksCount;
    private VariantGroup group;
    private MigPanel alternativePanel;
    private ExtCheckBox checkbox;
    private JLabel alternativesLabel;

    public YoutubeVariantSelectionDialogSetMulti(CounterMap<String> matchingLinks, VariantGroup g, int links, List<VariantInfo> variants) {
        super(g, _GUI.T.youtube_variant_selection_dialog_title2(g.getLabel(), links), _GUI.T.lit_choose(), variants);
        this.matchingLinks = matchingLinks;
        this.group = g;
        this.linksCount = links;
    }

    @Override
    public JComponent layoutDialogContent() {
        JComponent ret = super.layoutDialogContent();
        this.alternativePanel = new MigPanel("ins 0", "[grow,fill]0[]", "[]");
        this.alternativesLabel = new JLabel(_GUI.T.youtube_mass_change_or_add_choose_help());
        this.alternativePanel.add((Component)this.alternativesLabel, (Object)"");
        this.alternativesLabel.setHorizontalAlignment(4);
        this.checkbox = new ExtCheckBox(CFG_YOUTUBE.CHOOSE_ALTERNATIVE_FOR_MASS_CHANGE_OR_ADD_DIALOG, new JComponent[0]);
        this.alternativePanel.add((Component)this.checkbox, (Object)("hidemode 3,gapleft 2,height " + this.alternativesLabel.getPreferredSize().height + "!"));
        if (this.linksCount > 1) {
            ret.add((Component)this.alternativePanel, "spanx,growx,pushx");
        }
        this.valueChanged(null);
        return ret;
    }

    public boolean isAutoAlternativesEnabled() {
        return this.checkbox.isSelected();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        List selectedObject = this.table.getModel().getSelectedObjects(1);
        if (selectedObject == null || selectedObject.size() == 0) {
            this.checkbox.setVisible(false);
            this.alternativesLabel.setEnabled(false);
            this.alternativesLabel.setText(_GUI.T.youtube_mass_change_or_add_choose_help());
        } else {
            AbstractVariantWrapper s = (AbstractVariantWrapper)this.table.getModel().getTableData().get(this.table.getSelectedRow());
            int matching = this.matchingLinks.getInt((Object)s.getVariableIDStorable().createUniqueID());
            if (matching == this.linksCount) {
                this.checkbox.setVisible(false);
                this.alternativesLabel.setEnabled(false);
                this.alternativesLabel.setText(_GUI.T.youtube_mass_change_or_add_choose_ok(this.group.getLabel(), this.linksCount));
            } else {
                this.checkbox.setVisible(true);
                this.alternativesLabel.setEnabled(true);
                this.alternativesLabel.setText(_GUI.T.youtube_mass_change_or_add_choose_alternative(this.group.getLabel(), matching, this.linksCount));
            }
        }
    }

    @Override
    protected CustomVariantsMapTableModel createTableModel() {
        return new CustomVariantsMapTableModel(this.variantWrapperList, null){
            private VariantsMapTableModel.AutoResizingIntColumn matches;

            @Override
            protected void onStructureChanged(List<AbstractVariantWrapper> newtableData) {
                super.onStructureChanged(newtableData);
                if (this.matches != null) {
                    this.setColumnVisible((ExtColumn)this.matches, YoutubeVariantSelectionDialogSetMulti.this.linksCount > 1);
                }
            }

            @Override
            protected void initColumns() {
                super.initColumns();
                this.matches = new VariantsMapTableModel.AutoResizingIntColumn(_GUI.T.youtube_matching_links()){

                    @Override
                    public String getStringValue(AbstractVariantWrapper value) {
                        if (value.variant instanceof SubtitleVariant) {
                            return YoutubeVariantSelectionDialogSetMulti.this.matchingLinks.getInt((Object)value.variant._getUniqueId()) + "/" + YoutubeVariantSelectionDialogSetMulti.this.linksCount;
                        }
                        return YoutubeVariantSelectionDialogSetMulti.this.matchingLinks.getInt((Object)value.getVariableIDStorable().createUniqueID()) + "/" + YoutubeVariantSelectionDialogSetMulti.this.linksCount;
                    }

                    @Override
                    public boolean isAutoWidthEnabled() {
                        return true;
                    }

                    @Override
                    public int getInt(AbstractVariantWrapper value) {
                        if (value.variant instanceof SubtitleVariant) {
                            return YoutubeVariantSelectionDialogSetMulti.this.matchingLinks.getInt((Object)value.variant._getUniqueId());
                        }
                        return YoutubeVariantSelectionDialogSetMulti.this.matchingLinks.getInt((Object)value.getVariableIDStorable().createUniqueID());
                    }
                };
                this.addColumn((ExtColumn)this.matches);
            }
        };
    }

    @Override
    protected String getDescriptionText() {
        return _GUI.T.youtube_coose_variant_help();
    }
}

