/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.plugins.components.youtube.configpanel;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import jd.gui.swing.jdgui.BasicJDTable;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtComponentRowHighlighter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.CounterMap;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.components.youtube.VariantIDStorable;
import org.jdownloader.plugins.components.youtube.configpanel.CollectionsTableModel;
import org.jdownloader.plugins.components.youtube.configpanel.YoutubeVariantCollection;
import org.jdownloader.plugins.components.youtube.configpanel.YoutubeVariantsListChooser;
import org.jdownloader.settings.staticreferences.CFG_YOUTUBE;
import org.jdownloader.updatev2.gui.LAFOptions;

public class CollectionsTable
extends BasicJDTable<YoutubeVariantCollection> {
    public CollectionsTable(CollectionsTableModel model) {
        super((ExtTableModel)model);
        this.setColumnBottonVisibility(false);
        this.getModel().addExtComponentRowHighlighter((ExtComponentRowHighlighter)new ExtComponentRowHighlighter<YoutubeVariantCollection>(LAFOptions.getInstance().getColorForTableAlternateRowForeground(), LAFOptions.getInstance().getColorForTableAlternateRowBackground(), null){

            protected Color getBackground(Color current) {
                return LAFOptions.getInstance().getColorForPanelHeaderBackground();
            }

            public boolean accept(ExtColumn<YoutubeVariantCollection> column, YoutubeVariantCollection value, boolean selected, boolean focus, int row) {
                return value.getGroupingID() != null;
            }
        });
    }

    public CollectionsTableModel getModel() {
        return (CollectionsTableModel)super.getModel();
    }

    public void load() {
        this.getModel().load();
    }

    protected JPopupMenu onContextMenu(JPopupMenu popup, final YoutubeVariantCollection contextObject, final List<YoutubeVariantCollection> selection, ExtColumn<YoutubeVariantCollection> column, MouseEvent mouseEvent) {
        popup.add((Action)((Object)new AppAction(){
            {
                this.setSmallIcon(new AbstractIcon("remove", 20));
                this.setName(_GUI.T.lit_delete());
                this.setEnabled(false);
                if (selection != null) {
                    for (YoutubeVariantCollection l : selection) {
                        if (l.getGroupingID() != null) continue;
                        this.setEnabled(true);
                        break;
                    }
                }
            }

            public void actionPerformed(ActionEvent e) {
                CollectionsTable.this.onShortcutDelete(CollectionsTable.this.getModel().getSelectedObjects(), null, false);
            }
        }));
        popup.add((Action)((Object)new AppAction(){
            {
                this.setSmallIcon(new AbstractIcon("popDownLarge", 20));
                this.setName(_GUI.T.youtube_edit_variant_dropdown_list());
            }

            public void actionPerformed(ActionEvent e) {
                new Thread("Choose Youtube Variant"){

                    @Override
                    public void run() {
                        try {
                            YoutubeVariantsListChooser d = new YoutubeVariantsListChooser(contextObject);
                            ((YoutubeVariantsListChooser)UIOManager.I().show(null, (UserIODefinition)d)).throwCloseExceptions();
                            List<VariantIDStorable> newList = d.getSelection();
                            contextObject.setDropdown(newList);
                            CFG_YOUTUBE.CFG.setCollections(CollectionsTable.this.getModel().getElements());
                        }
                        catch (DialogClosedException e) {
                            e.printStackTrace();
                        }
                        catch (DialogCanceledException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
            }
        }));
        return popup;
    }

    protected boolean onShortcutDelete(List<YoutubeVariantCollection> selectedObjects, KeyEvent evt, boolean direct) {
        if (selectedObjects == null || selectedObjects.size() == 0) {
            return false;
        }
        if (direct || UIOManager.I().showConfirmDialog(0, _GUI.T.lit_are_you_sure(), _GUI.T.lit_are_you_sure())) {
            this.getSelectionModel().clearSelection();
            List<YoutubeVariantCollection> links = CFG_YOUTUBE.CFG.getCollections();
            for (YoutubeVariantCollection l : selectedObjects) {
                if (l.getGroupingID() != null) continue;
                links.remove(l);
            }
            CFG_YOUTUBE.CFG.setCollections(links);
            return true;
        }
        return false;
    }

    public void onEnabledMapUpdate(CounterMap<String> enabledMap) {
        this.getModel().onEnabledMapUpdate(enabledMap);
    }
}

